/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import statistics.distributions.Distribution;
import statistics.distributions.NormalDistribution;
import statistics.simulators.Model;

public class ArmaModel
extends Model {
    double[] ar;
    double[] ma;
    int p;
    int q;
    double[] xRecord;
    double[] eRecord;
    public static double GLOBALVAR = 1.0;
    double sigma = GLOBALVAR;

    public static void setGlobalVariance(double v) {
        GLOBALVAR = v;
    }

    public ArmaModel(int p, int q) {
        this.p = p;
        this.q = q;
        if (p > 0) {
            this.ar = new double[p];
            this.xRecord = new double[p];
        }
        if (q > 0) {
            this.ma = new double[q];
            this.eRecord = new double[q];
        }
        this.t = 0.0;
        this.sigma = GLOBALVAR;
        this.error = new NormalDistribution(0.0, this.sigma);
    }

    public ArmaModel(int p) {
        this.p = p;
        this.q = 0;
        this.ar = new double[p];
        this.xRecord = new double[p];
        this.t = 0.0;
        this.sigma = GLOBALVAR;
        this.error = new NormalDistribution(0.0, this.sigma);
    }

    public ArmaModel(double[] pi) {
        this(pi.length);
        this.setParas(pi);
    }

    public ArmaModel(double[] ar, double[] ma) {
        this(ar.length, ma.length);
        this.setParas(ar, ma);
    }

    @Override
    public void setParameters(double[] pi) {
        if (pi.length != this.p) {
            this.p = pi.length;
            this.ar = new double[this.p];
            this.xRecord = new double[this.p];
        }
        this.q = 0;
        for (int i = 0; i < this.p; ++i) {
            this.ar[i] = pi[i];
        }
    }

    public void setParas(double[] pi) {
        if (pi.length != this.p) {
            this.p = pi.length;
            this.ar = new double[this.p];
            this.xRecord = new double[this.p];
        }
        this.q = 0;
        for (int i = 0; i < this.p; ++i) {
            this.ar[i] = pi[i];
        }
    }

    public void setParas(double[] ar, double[] ma) {
        int i;
        if (this.p > 0 && ar.length != this.p) {
            this.p = ar.length;
            this.ar = new double[this.p];
            this.xRecord = new double[this.p];
        }
        if (this.q > 0 && ma.length != this.q) {
            this.q = ma.length;
            this.ma = new double[this.q];
            this.eRecord = new double[this.q];
        }
        for (i = 0; i < this.p; ++i) {
            this.ar[i] = ar[i];
        }
        for (i = 0; i < this.q; ++i) {
            this.ma[i] = ma[i];
        }
    }

    public double[] getParas() {
        return this.ar;
    }

    public void setSigma(double s) {
        this.sigma = s;
        ((NormalDistribution)this.error).setSigma(s);
    }

    public void setInitialValues(double[] initX, double[] initE) {
        int i;
        for (i = 0; i < this.p; ++i) {
            this.xRecord[i] = initX[i];
        }
        for (i = 0; i < this.q; ++i) {
            this.eRecord[i] = initE[i];
        }
    }

    @Override
    public double generate(double x) {
        return -1.0;
    }

    public double generateError() {
        return this.error.simulate();
    }

    @Override
    public void reset() {
        this.t = 0.0;
        this.randomise();
    }

    public void randomise() {
        int i;
        for (i = 0; i < this.p; ++i) {
            this.xRecord[i] = -2.0 * this.sigma + 4.0 * this.sigma * Distribution.RNG.nextDouble();
        }
        for (i = 0; i < this.q; ++i) {
            this.eRecord[i] = -2.0 * this.sigma + 4.0 * this.sigma * Distribution.RNG.nextDouble();
        }
    }

    public void resetToZero() {
        int i;
        this.t = 0.0;
        for (i = 0; i < this.p; ++i) {
            this.xRecord[i] = 0.0;
        }
        for (i = 0; i < this.q; ++i) {
            this.eRecord[i] = 0.0;
        }
    }

    @Override
    public double generate() {
        int i;
        double x = 0.0;
        int t = (int)this.t;
        if (t < this.p) {
            this.t += 1.0;
            return this.xRecord[t];
        }
        for (i = 0; i < this.p; ++i) {
            x += this.ar[this.p - i - 1] * this.xRecord[(t + i) % this.p];
        }
        for (i = 0; i < this.q; ++i) {
            x += this.ma[(t + i) % this.q] * this.eRecord[(t + i) % this.q];
        }
        double e = this.error.simulate();
        x += e;
        if (this.p > 0) {
            this.xRecord[t % this.p] = x;
        }
        if (this.q > 0) {
            this.eRecord[t % this.q] = e;
        }
        this.t += 1.0;
        return x;
    }

    public String toString() {
        String str = "";
        return str;
    }

    public static double[] differenceData(double[] d) {
        double[] newD = new double[d.length - 1];
        for (int i = 0; i < d.length - 1; ++i) {
            newD[i] = d[i + 1] - d[i];
        }
        return newD;
    }

    public static void simulateData(int p, int q, int t) {
        int i;
        ArmaModel a = new ArmaModel(p, q);
        double[] ar = new double[p];
        double[] ma = new double[q];
        for (i = 0; i < p; ++i) {
            ar[i] = 1.0;
        }
        for (i = 0; i < q; ++i) {
            ma[i] = 1.0;
        }
        a.setParas(ar, ma);
        a.setSigma(GLOBALVAR);
        for (i = 0; i < p; ++i) {
            ar[i] = 10.0;
        }
        for (i = 0; i < q; ++i) {
            ma[i] = 10.0;
        }
        a.setInitialValues(ar, ma);
        System.out.println("Model = ARMA(" + p + "," + q + ")");
        for (i = 0; i < t; ++i) {
            System.out.println("Data = " + a.generate());
        }
    }

    public static void main(String[] args) {
        ArmaModel.simulateDataForForecastingWithMP();
        System.exit(0);
        System.out.println("Testing Arma Models");
        System.out.println("Generating Data");
        ArmaModel.simulateData(0, 1, 30);
    }

    public static void simulateDataForForecastingWithMP() {
        int i;
        OutFile ex = new OutFile("C:\\Temp\\ARSeries.csv");
        double[][] p = new double[][]{{0.5}, {-0.5}};
        ArmaModel ar1 = new ArmaModel(p[0]);
        ArmaModel ar2 = new ArmaModel(p[1]);
        for (i = 0; i < 10000; ++i) {
            ex.writeLine(ar1.generate() + "");
        }
        for (i = 0; i < 10000; ++i) {
            ex.writeLine(ar2.generate() + "");
        }
    }
}

