/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;
import statistics.distributions.IntervalData;

public class RandomVariable {
    private Distribution distribution;
    private IntervalData intervalData;
    private String name;

    public RandomVariable(Distribution d, String n) {
        this.distribution = d;
        this.name = n;
        this.intervalData = new IntervalData(this.distribution.getDomain(), this.name);
    }

    public RandomVariable(Distribution d) {
        this(d, "X");
    }

    public void setDistribution(Distribution d) {
        this.distribution = d;
        this.intervalData.setDomain(this.distribution.getDomain());
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public IntervalData getIntervalData() {
        return this.intervalData;
    }

    public void setValue(double x) {
        this.intervalData.setValue(x);
    }

    public double getValue() {
        return this.intervalData.getValue();
    }

    public void sample() {
        this.intervalData.setValue(this.distribution.simulate());
    }

    public double simulate() {
        double x = this.distribution.simulate();
        this.intervalData.setValue(x);
        return x;
    }

    public void reset() {
        this.intervalData.setDomain(this.distribution.getDomain());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
        this.intervalData.setName(this.name);
    }
}

