/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;
import statistics.distributions.Domain;

public class OrderStatisticDistribution
extends Distribution {
    Distribution dist;
    int sampleSize;
    int order;

    public OrderStatisticDistribution(Distribution d, int n, int k) {
        this.setParameters(d, n, k);
    }

    public void setParameters(Distribution d, int n, int k) {
        if (n < 1) {
            n = 1;
        }
        if (k < 1) {
            k = 1;
        } else if (k > n) {
            k = n;
        }
        this.dist = d;
        this.sampleSize = n;
        this.order = k;
        int t = this.dist.getType();
        Domain domain = this.dist.getDomain();
        if (t == 0) {
            super.setParameters(domain.getLowerValue(), domain.getUpperValue(), domain.getWidth(), t);
        } else {
            super.setParameters(domain.getLowerBound(), domain.getUpperBound(), domain.getWidth(), t);
        }
    }

    @Override
    public double getDensity(double x) {
        double p = this.dist.getCDF(x);
        if (this.dist.getType() == 0) {
            return this.getCDF(x) - this.getCDF(x - this.getDomain().getWidth());
        }
        return (double)this.order * OrderStatisticDistribution.comb(this.sampleSize, this.order) * Math.pow(p, this.order - 1) * Math.pow(1.0 - p, this.sampleSize - this.order) * this.dist.getDensity(x);
    }

    @Override
    public double getCDF(double x) {
        double sum = 0.0;
        double p = this.dist.getCDF(x);
        for (int j = this.order; j <= this.sampleSize; ++j) {
            sum += OrderStatisticDistribution.comb(this.sampleSize, j) * Math.pow(p, j) * Math.pow(1.0 - p, this.sampleSize - j);
        }
        return sum;
    }
}

