/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class NormalDistribution
extends Distribution {
    public static final double C = Math.sqrt(Math.PI * 2);
    private double mu;
    private double sigma;
    private double cSigma;

    public NormalDistribution(double mu, double sigma) {
        this.setParameters(mu, sigma);
    }

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public void setParameters(double m, double s) {
        if (s < 0.0) {
            s = 1.0;
        }
        this.mu = m;
        this.sigma = s;
        this.cSigma = C * this.sigma;
        double upper = this.mu + 4.0 * this.sigma;
        double lower = this.mu - 4.0 * this.sigma;
        double width = (upper - lower) / 100.0;
        super.setParameters(lower, upper, width, 1);
    }

    @Override
    public double getDensity(double x) {
        double z = (x - this.mu) / this.sigma;
        return Math.exp(-z * z / 2.0) / this.cSigma;
    }

    @Override
    public double getMaxDensity() {
        return this.getDensity(this.mu);
    }

    @Override
    public double getMedian() {
        return this.mu;
    }

    @Override
    public double getMean() {
        return this.mu;
    }

    @Override
    public double getVariance() {
        return this.sigma * this.sigma;
    }

    @Override
    public double simulate() {
        double r = Math.sqrt(-2.0 * Math.log(RNG.nextDouble()));
        double theta = Math.PI * 2 * RNG.nextDouble();
        return this.mu + this.sigma * r * Math.cos(theta);
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double m) {
        this.setParameters(m, this.sigma);
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double s) {
        this.setParameters(this.mu, s);
    }

    @Override
    public double getCDF(double x) {
        double z = (x - this.mu) / this.sigma;
        if (z >= 0.0) {
            return 0.5 + 0.5 * NormalDistribution.gammaCDF(z * z / 2.0, 0.5);
        }
        return 0.5 - 0.5 * NormalDistribution.gammaCDF(z * z / 2.0, 0.5);
    }

    public String toString() {
        String str = super.toString();
        str = str + " mean " + this.mu + " sigma = " + this.sigma;
        return str;
    }
}

