/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class NegativeBinomialDistribution
extends Distribution {
    private int successes;
    private double probability;

    public NegativeBinomialDistribution(int k, double p) {
        this.setParameters(k, p);
    }

    public NegativeBinomialDistribution() {
        this(1, 0.5);
    }

    public void setParameters(int k, double p) {
        if (k < 1) {
            k = 1;
        }
        if (p <= 0.0) {
            p = 0.05;
        }
        if (p > 1.0) {
            p = 1.0;
        }
        this.successes = k;
        this.probability = p;
        super.setParameters(this.successes, Math.ceil(this.getMean() + 4.0 * this.getSD()), 1.0, 0);
    }

    public void setSuccesses(int k) {
        this.setParameters(k, this.probability);
    }

    public int getSuccesses() {
        return this.successes;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double p) {
        this.setParameters(this.successes, p);
    }

    @Override
    public double getDensity(double x) {
        int n = (int)Math.rint(x);
        if (n < this.successes) {
            return 0.0;
        }
        return NegativeBinomialDistribution.comb(n - 1, this.successes - 1) * Math.pow(this.probability, this.successes) * Math.pow(1.0 - this.probability, n - this.successes);
    }

    @Override
    public double getMaxDensity() {
        double mode = (double)(this.successes - 1) / this.probability + 1.0;
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        return (double)this.successes / this.probability;
    }

    @Override
    public double getVariance() {
        return (double)this.successes * (1.0 - this.probability) / (this.probability * this.probability);
    }

    @Override
    public double simulate() {
        int count = 0;
        int trials = 0;
        while (count < this.successes) {
            if (Math.random() < this.probability) {
                ++count;
            }
            ++trials;
        }
        System.out.println("In simulate, prob =" + this.probability + "\t success= " + this.successes + "\t trials =" + trials);
        return trials;
    }
}

