/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class HypergeometricDistribution
extends Distribution {
    private int populationSize;
    private int sampleSize;
    private int type1Size;
    double c;

    public HypergeometricDistribution(int m, int r, int n) {
        this.setParameters(m, r, n);
    }

    public HypergeometricDistribution() {
        this(100, 50, 10);
    }

    public void setParameters(int m, int r, int n) {
        if (m < 1) {
            m = 1;
        }
        if (r < 0) {
            r = 0;
        } else if (r > m) {
            r = m;
        }
        if (n < 0) {
            n = 0;
        } else if (n > m) {
            n = m;
        }
        this.populationSize = m;
        this.type1Size = r;
        this.sampleSize = n;
        this.c = HypergeometricDistribution.comb(this.populationSize, this.sampleSize);
        super.setParameters(Math.max(0, this.sampleSize - this.populationSize + this.type1Size), Math.min(this.type1Size, this.sampleSize), 1.0, 0);
    }

    @Override
    public double getDensity(double x) {
        int k = (int)Math.rint(x);
        return HypergeometricDistribution.comb(this.type1Size, k) * HypergeometricDistribution.comb(this.populationSize - this.type1Size, this.sampleSize - k) / this.c;
    }

    @Override
    public double getMaxDensity() {
        double mode = Math.floor((double)(this.sampleSize + 1) * (double)(this.type1Size + 1) / (double)(this.populationSize + 2));
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        return (double)this.sampleSize * (double)this.type1Size / (double)this.populationSize;
    }

    @Override
    public double getVariance() {
        return (double)this.sampleSize * (double)this.type1Size * (double)(this.populationSize - this.type1Size) * (double)(this.populationSize - this.sampleSize) / (double)(this.populationSize * this.populationSize * (this.populationSize - 1));
    }

    public void setPopulationSize(int m) {
        this.setParameters(m, this.type1Size, this.sampleSize);
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setType1Size(int r) {
        this.setParameters(this.populationSize, r, this.sampleSize);
    }

    public int getType1Size() {
        return this.type1Size;
    }

    public void setSampleSize(int n) {
        this.setParameters(this.populationSize, this.type1Size, n);
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public double simulate() {
        int i;
        double x = 0.0;
        int m0 = this.populationSize;
        int[] b = new int[m0];
        for (i = 0; i < m0; ++i) {
            b[i] = i;
        }
        for (i = 0; i < this.sampleSize; ++i) {
            int k = m0 - i;
            int u = (int)((double)k * Math.random());
            if (u < this.type1Size) {
                x += 1.0;
            }
            int j = b[k - 1];
            b[k - 1] = b[u];
            b[u] = j;
        }
        return x;
    }
}

