/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class GammaDistribution
extends Distribution {
    private double shape;
    private double scale;
    private double c;

    public GammaDistribution(double k, double b) {
        this.setParameters(k, b);
    }

    public GammaDistribution() {
        this(1.0, 1.0);
    }

    public void setParameters(double k, double b) {
        if (k < 0.0) {
            k = 1.0;
        }
        if (b < 0.0) {
            b = 1.0;
        }
        this.shape = k;
        this.scale = b;
        this.c = this.shape * Math.log(this.scale) + GammaDistribution.logGamma(this.shape);
        double upperBound = this.getMean() + 4.0 * this.getSD();
        super.setParameters(0.0, upperBound, 0.01 * upperBound, 1);
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double getDensity(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x == 0.0 & this.shape < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0 & this.shape == 1.0) {
            return Math.exp(-this.c);
        }
        if (x == 0.0 & this.shape > 1.0) {
            return 0.0;
        }
        return Math.exp(-this.c + (this.shape - 1.0) * Math.log(x) - x / this.scale);
    }

    @Override
    public double getMaxDensity() {
        double mode = this.shape < 1.0 ? 0.01 : this.scale * (this.shape - 1.0);
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        return this.shape * this.scale;
    }

    @Override
    public double getVariance() {
        return this.shape * this.scale * this.scale;
    }

    @Override
    public double getCDF(double x) {
        return GammaDistribution.gammaCDF(x / this.scale, this.shape);
    }

    @Override
    public double simulate() {
        if (this.shape == Math.rint(this.shape)) {
            double sum = 0.0;
            int i = 1;
            while ((double)i <= this.shape) {
                sum -= this.scale * Math.log(1.0 - Math.random());
                ++i;
            }
            return sum;
        }
        return super.simulate();
    }
}

