/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.GammaDistribution;

public class ExponentialDistribution
extends GammaDistribution {
    double rate;

    public ExponentialDistribution(double r) {
        this.setRate(r);
    }

    public ExponentialDistribution() {
        this(1.0);
    }

    public void setRate(double r) {
        if (r <= 0.0) {
            r = 1.0;
        }
        this.rate = r;
        super.setParameters(1.0, 1.0 / this.rate);
    }

    public double getRate() {
        return this.rate;
    }

    @Override
    public double getDensity(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.rate * Math.exp(-this.rate * x);
    }

    @Override
    public double getCDF(double x) {
        return 1.0 - Math.exp(-this.rate * x);
    }

    @Override
    public double getQuantile(double p) {
        return -Math.log(1.0 - p) / this.rate;
    }
}

