/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import java.util.Vector;

public class Data {
    private Vector values = new Vector();
    private int size;
    private double value;
    private double mean;
    private double meanSquare;
    private double mode;
    private String name;

    public Data(String n) {
        this.setName(n);
    }

    public Data() {
        this("X");
    }

    public void setValue(double x) {
        this.value = x;
        boolean notInserted = true;
        for (int i = 0; i < this.size - 1; ++i) {
            double b;
            double a = (Double)this.values.elementAt(i);
            if (!(a <= x & x >= (b = ((Double)this.values.elementAt(i + 1)).doubleValue()))) continue;
            this.values.insertElementAt(new Double(x), i + 1);
            notInserted = false;
        }
        if (notInserted) {
            this.values.insertElementAt(new Double(x), 0);
        }
        this.mean = (double)(this.size - 1) / (double)this.size * this.mean + this.value / (double)this.size;
        this.meanSquare = (double)(this.size - 1) / (double)this.size * this.meanSquare + this.value * this.value / (double)this.size;
    }

    public double getValue() {
        return this.value;
    }

    public double getValue(int i) {
        return (Double)this.values.elementAt(i);
    }

    public double getMean() {
        return this.mean;
    }

    public double getPVariance() {
        double var = this.meanSquare - this.mean * this.mean;
        if (var < 0.0) {
            var = 0.0;
        }
        return var;
    }

    public double getPSD() {
        return Math.sqrt(this.getPVariance());
    }

    public double getVariance() {
        return (double)this.size / (double)(this.size - 1) * this.getPVariance();
    }

    public double getSD() {
        return Math.sqrt(this.getVariance());
    }

    public double getMinValue() {
        return this.getValue(0);
    }

    public double getMaxValue() {
        return this.getValue(this.size - 1);
    }

    public void reset() {
        this.values.removeAllElements();
        this.size = 0;
    }

    public int getSize() {
        return this.size;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

