/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class CouponDistribution
extends Distribution {
    int popSize;
    int distinctValues;
    int upperValue;
    double[][] prob;

    public CouponDistribution(int m, int k) {
        this.setParameters(m, k);
    }

    public CouponDistribution() {
        this(10, 10);
    }

    public void setParameters(int m, int k) {
        if (m < 1) {
            m = 1;
        }
        if (k < 1) {
            k = 1;
        } else if (k > m) {
            k = m;
        }
        this.popSize = m;
        this.distinctValues = k;
        this.upperValue = (int)Math.ceil(this.getMean() + 4.0 * this.getSD());
        super.setParameters(this.distinctValues, this.upperValue, 1.0, 0);
        this.prob = new double[this.upperValue + 1][this.popSize + 1];
        this.prob[0][0] = 1.0;
        this.prob[1][1] = 1.0;
        for (int i = 1; i < this.upperValue; ++i) {
            int upperIndex = i < this.popSize ? i + 1 : this.popSize;
            for (int n = 1; n <= upperIndex; ++n) {
                this.prob[i + 1][n] = this.prob[i][n] * ((double)n / (double)this.popSize) + this.prob[i][n - 1] * ((double)(this.popSize - n + 1) / (double)this.popSize);
            }
        }
    }

    @Override
    public double getDensity(double x) {
        int k = (int)Math.rint(x);
        if (k < this.distinctValues | k > this.upperValue) {
            return 0.0;
        }
        return (double)(this.popSize - this.distinctValues + 1) / (double)this.popSize * this.prob[k - 1][this.distinctValues - 1];
    }

    @Override
    public double getMean() {
        double sum = 0.0;
        for (int i = 1; i <= this.distinctValues; ++i) {
            sum += (double)this.popSize / (double)(this.popSize - i + 1);
        }
        return sum;
    }

    @Override
    public double getVariance() {
        double sum = 0.0;
        for (int i = 1; i <= this.distinctValues; ++i) {
            sum += (double)(this.popSize * (i - 1)) / (double)((this.popSize - i + 1) * (this.popSize - i + 1));
        }
        return sum;
    }

    public double getPopSize() {
        return this.popSize;
    }

    public void setPopSize(int m) {
        this.setParameters(m, this.distinctValues);
    }

    public double getDistinctValues() {
        return this.distinctValues;
    }

    public void setDistinctValues(int k) {
        this.setParameters(this.popSize, k);
    }

    @Override
    public double simulate() {
        int[] cellCount = new int[this.popSize];
        double occupiedCells = 0.0;
        int ballCount = 0;
        while (occupiedCells <= (double)this.distinctValues) {
            ++ballCount;
            int ballIndex = (int)((double)this.popSize * Math.random());
            if (cellCount[ballIndex] == 0) {
                occupiedCells += 1.0;
            }
            int n = ballIndex;
            cellCount[n] = cellCount[n] + 1;
        }
        return ballCount;
    }
}

