/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class CircleDistribution
extends Distribution {
    private double radius;

    public CircleDistribution(double r) {
        this.setRadius(r);
    }

    public CircleDistribution() {
        this(1.0);
    }

    public void setRadius(double r) {
        if (r <= 0.0) {
            r = 1.0;
        }
        this.radius = r;
        super.setParameters(-this.radius, this.radius, 0.02 * this.radius, 1);
    }

    @Override
    public double getDensity(double x) {
        if (-this.radius <= x & x <= this.radius) {
            return 2.0 * Math.sqrt(this.radius * this.radius - x * x) / (Math.PI * this.radius * this.radius);
        }
        return 0.0;
    }

    @Override
    public double getMaxDensity() {
        return this.getDensity(0.0);
    }

    @Override
    public double getMean() {
        return 0.0;
    }

    @Override
    public double getVariance() {
        return this.radius * this.radius / 4.0;
    }

    @Override
    public double getMedian() {
        return 0.0;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public double simulate() {
        double u = this.radius * Math.random();
        double v = this.radius * Math.random();
        double r = Math.max(u, v);
        double theta = Math.PI * 2 * Math.random();
        return r * Math.cos(theta);
    }

    @Override
    public double getCDF(double x) {
        return 0.5 + Math.asin(x / this.radius) / Math.PI + x * Math.sqrt(1.0 - x * x / (this.radius * this.radius)) / (Math.PI * this.radius);
    }
}

