/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.DiscreteUniformDistribution;
import statistics.distributions.Distribution;

public class BinomialRandomNDistribution
extends Distribution {
    double probability;
    double sum;
    Distribution dist;

    public BinomialRandomNDistribution(Distribution d, double p) {
        this.setParameters(d, p);
    }

    public BinomialRandomNDistribution(double p) {
        this(new DiscreteUniformDistribution(1.0, 6.0, 1.0), p);
    }

    public BinomialRandomNDistribution() {
        this(new DiscreteUniformDistribution(1.0, 6.0, 1.0), 0.5);
    }

    public void setParameters(Distribution d, double p) {
        this.dist = d;
        this.probability = p;
        super.setParameters(0.0, this.dist.getDomain().getUpperValue(), 1.0, 0);
    }

    @Override
    public double getDensity(double x) {
        int k = (int)Math.rint(x);
        if (this.probability == 0.0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.probability == 1.0) {
            return this.dist.getDensity(k);
        }
        this.sum = 0.0;
        for (int i = 0; i < this.dist.getDomain().getSize(); ++i) {
            double trials = this.dist.getDomain().getValue(i);
            this.sum += this.dist.getDensity(trials) * BinomialRandomNDistribution.comb(trials, k) * Math.pow(this.probability, k) * Math.pow(1.0 - this.probability, trials - (double)k);
        }
        return this.sum;
    }

    @Override
    public double getMean() {
        return this.dist.getMean() * this.probability;
    }

    @Override
    public double getVariance() {
        return this.dist.getMean() * this.probability * (1.0 - this.probability) + this.dist.getVariance() * this.probability * this.probability;
    }

    @Override
    public double simulate() {
        int trials = (int)this.dist.simulate();
        int successes = 0;
        for (int i = 1; i <= trials; ++i) {
            if (!(Math.random() < this.probability)) continue;
            ++successes;
        }
        return successes;
    }
}

