/*
 * Decompiled with CFR 0.152.
 */
package papers.bagnall17defaultparas;

import development.DataSets;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.TunedRandomForest;
import vector_classifiers.TunedRotationForest;
import vector_classifiers.TunedSVM;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.lazy.IB1;
import weka.classifiers.lazy.IBk;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;

public class ClassifierComparison {
    public static String[] classifiers = new String[]{"TunedSVM", "TunedRandF", "TunedRotF", "Logistic", "NB", "IB1", "C4.5", "IBk", "RandF", "RotF", "SVML", "SVMQ", "SVMRBF"};
    public static double propInTrain = 0.5;
    public static int folds = 30;
    static String[] fileNames = new String[]{"acute-inflammation", "acute-nephritis", "adult", "annealing", "arrhythmia", "audiology-std", "balance-scale", "balloons", "bank", "blood", "breast-cancer", "breast-cancer-wisc", "breast-cancer-wisc-diag", "breast-cancer-wisc-prog", "breast-tissue", "car", "cardiotocography-10clases", "cardiotocography-3clases", "congressional-voting", "conn-bench-sonar-mines-rocks", "conn-bench-vowel-deterding", "contrac", "credit-approval", "cylinder-bands", "dermatology", "echocardiogram", "ecoli", "energy-y1", "energy-y2", "fertility", "flags", "glass", "haberman-survival", "hayes-roth", "heart-cleveland", "heart-hungarian", "heart-switzerland", "heart-va", "hepatitis", "hill-valley", "horse-colic", "ilpd-indian-liver", "image-segmentation", "ionosphere", "iris", "led-display", "lenses", "letter", "libras", "low-res-spect", "lung-cancer", "lymphography", "magic", "mammographic", "molec-biol-promoter", "molec-biol-splice", "monks-1", "monks-2", "monks-3", "mushroom", "musk-1", "musk-2", "nursery", "oocytes_merluccius_nucleus_4d", "oocytes_merluccius_states_2f", "oocytes_trisopterus_nucleus_2f", "oocytes_trisopterus_states_5b", "optical", "ozone", "page-blocks", "parkinsons", "pendigits", "pima", "pittsburg-bridges-MATERIAL", "pittsburg-bridges-REL-L", "pittsburg-bridges-SPAN", "pittsburg-bridges-T-OR-D", "pittsburg-bridges-TYPE", "planning", "plant-margin", "plant-shape", "plant-texture", "post-operative", "primary-tumor", "ringnorm", "seeds", "semeion", "soybean", "spambase", "spect", "spectf", "statlog-australian-credit", "statlog-german-credit", "statlog-heart", "statlog-image", "statlog-landsat", "statlog-shuttle", "statlog-vehicle", "steel-plates", "synthetic-control", "teaching", "thyroid", "tic-tac-toe", "titanic", "trains", "twonorm", "vertebral-column-2clases", "vertebral-column-3clases", "wall-following", "waveform", "waveform-noise", "wine", "wine-quality-red", "wine-quality-white", "yeast", "zoo"};
    static boolean debug = false;
    static double[] svmParas = new double[]{0.00390625, 0.015625, 0.0625, 0.25, 0.5, 1.0, 2.0, 4.0, 16.0, 256.0};
    static int[] numTrees = new int[]{10, 50, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1250, 1500, 1750, 2000};

    public static void generateScripts(boolean grace, int mem) {
        String path = DataSets.dropboxPath + "Code\\Cluster Scripts\\UCIScripts\\";
        File f = new File(path);
        f.delete();
        f.mkdirs();
        ArrayList<String> list = new ArrayList<String>();
        for (String s : classifiers) {
            OutFile of2 = grace ? new OutFile(path + s + "Grace.txt") : new OutFile(path + s + ".txt");
            for (String a : fileNames) {
                OutFile of = grace ? new OutFile(path + s + a + "Grace.bsub") : new OutFile(path + s + a + ".bsub");
                of.writeLine("#!/bin/csh");
                if (grace) {
                    of.writeLine("#BSUB -q short");
                } else {
                    of.writeLine("#BSUB -q long-eth");
                }
                of.writeLine("#BSUB -J " + s + a + "[1-" + folds + "]");
                of.writeLine("#BSUB -oo output/" + a + ".out");
                of.writeLine("#BSUB -eo error/" + a + ".err");
                if (grace) {
                    of.writeLine("#BSUB -R \"rusage[mem=" + mem + "]\"");
                    of.writeLine("#BSUB -M " + mem);
                    of.writeLine(" module add java/jdk/1.8.0_31");
                } else {
                    of.writeLine("#BSUB -R \"rusage[mem=" + (2000 + mem) + "]\"");
                    of.writeLine("#BSUB -M " + (2000 + mem));
                    of.writeLine("module add java/jdk1.8.0_51");
                }
                of.writeLine("java -jar CompareClassifiers.jar " + s + " " + a + " $LSB_JOBINDEX");
                if (grace) {
                    of2.writeLine("bsub < Scripts/UCIScripts/" + s + a + "Grace.bsub");
                    continue;
                }
                list.add("bsub < Scripts/UCIScripts/" + s + a + ".bsub");
            }
            if (grace) continue;
            Collections.reverse(list);
            for (String str : list) {
                of2.writeLine(str);
            }
        }
    }

    public static boolean foldComplete(String path, int fold, int numTrain, int numTest) {
        File f = new File(path + "//testFold" + fold + ".csv");
        File f2 = new File(path + "//trainFold" + fold + ".csv");
        if (!f.exists() || !f2.exists()) {
            return false;
        }
        InFile inf1 = new InFile(path + "//testFold" + fold + ".csv");
        InFile inf2 = new InFile(path + "//testFold" + fold + ".csv");
        int c1 = inf1.countLines();
        int c2 = inf2.countLines();
        return c1 >= 3 && c2 >= 3;
    }

    public static void collateTrain() {
        String base = "C:\\Research\\Papers\\2017\\ECML Standard Parameters\\Section 4 Bakeoff\\TuneCompare\\";
        OutFile test = new OutFile(base + "inOneLineTest.csv");
        OutFile train = new OutFile(base + "inOneLineTrain.csv");
        InFile svmTrain = new InFile(base + "TunedSVMTrainCV.csv");
        InFile svmTest = new InFile(base + "TunedSVMTest.csv");
        InFile randFTrain = new InFile(base + "TunedRandFTrainCV.csv");
        InFile randFTest = new InFile(base + "TunedRandFTest.csv");
        InFile rotFTrain = new InFile(base + "TunedRotFTrainCV.csv");
        InFile rotFTest = new InFile(base + "TunedRotFTest.csv");
        for (String str : fileNames) {
            String[] svmTr = svmTrain.readLine().split(",");
            String[] svmTe = svmTest.readLine().split(",");
            String[] randFTr = randFTrain.readLine().split(",");
            String[] randFTe = randFTest.readLine().split(",");
            String[] rotFTr = rotFTrain.readLine().split(",");
            String[] rotFTe = rotFTest.readLine().split(",");
            int l = 31;
            if (svmTr.length != l || svmTe.length != l || randFTr.length != l || randFTe.length != l || rotFTr.length != l || rotFTe.length != l) continue;
            for (int i = 1; i < l; ++i) {
                train.writeLine(svmTr[i] + "," + randFTr[i] + "," + rotFTr[i]);
                test.writeLine(svmTe[i] + "," + randFTe[i] + "," + rotFTe[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collateResults(int folds, boolean onCluster) {
        int i;
        if (onCluster) {
            DataSets.resultsPath = DataSets.clusterPath + "Results/UCIResults/";
        }
        String basePath = DataSets.resultsPath;
        for (String cls : classifiers) {
            File f = new File(basePath + cls);
            if (!f.isDirectory()) continue;
            OutFile clsResults = new OutFile(basePath + cls + "//" + cls + "Test.csv");
            OutFile trainResults = new OutFile(basePath + cls + "//" + cls + "TrainCV.csv");
            OutFile cPara = new OutFile(basePath + cls + "//" + cls + "ParameterC.csv");
            OutFile gammaPara = new OutFile(basePath + cls + "//" + cls + "ParameterGamma.csv");
            OutFile missing = null;
            int missingCount = 0;
            for (int i2 = 0; i2 < fileNames.length; ++i2) {
                int j;
                String name = fileNames[i2];
                clsResults.writeString(fileNames[i2] + ",");
                trainResults.writeString(fileNames[i2] + ",");
                cPara.writeString(fileNames[i2] + ",");
                gammaPara.writeString(fileNames[i2] + ",");
                String path = basePath + cls + "//Predictions//" + fileNames[i2];
                if (missing != null && missingCount > 0) {
                    missing.writeString("\n");
                }
                missingCount = 0;
                for (j = 0; j < folds; ++j) {
                    f = new File(path + "//testFold" + j + ".csv");
                    if (f.exists() && f.length() > 0L) {
                        InFile inf = null;
                        String[] trainRes = null;
                        try {
                            inf = new InFile(path + "//testFold" + j + ".csv");
                            inf.readLine();
                            trainRes = inf.readLine().split(",");
                            clsResults.writeString(inf.readDouble() + ",");
                            if (trainRes.length > 1) {
                                trainResults.writeString(Double.parseDouble(trainRes[1]) + ",");
                                cPara.writeString(Double.parseDouble(trainRes[3]) + ",");
                                if (trainRes.length > 4) {
                                    gammaPara.writeString(Double.parseDouble(trainRes[5]) + ",");
                                    continue;
                                }
                                gammaPara.writeString(",");
                                continue;
                            }
                            trainResults.writeString(",");
                            cPara.writeString(",");
                            gammaPara.writeString(",");
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println(" Error " + e + " in " + path);
                            trainResults.writeString(",");
                            cPara.writeString(",");
                            gammaPara.writeString(",");
                            if (trainRes == null) continue;
                            System.out.println(" second line read has " + trainRes.length + " entries :");
                            for (String str : trainRes) {
                                System.out.println(str);
                            }
                            continue;
                        }
                        finally {
                            if (inf != null) {
                                inf.closeFile();
                            }
                        }
                    }
                    if (missing == null) {
                        missing = new OutFile(basePath + cls + "//" + cls + "MISSING.csv");
                    }
                    if (missingCount == 0) {
                        missing.writeString(name);
                    }
                    ++missingCount;
                    missing.writeString("," + j);
                }
                for (j = 0; j < folds; ++j) {
                }
                clsResults.writeString("\n");
                trainResults.writeString("\n");
                cPara.writeString("\n");
                gammaPara.writeString("\n");
            }
            clsResults.closeFile();
            trainResults.closeFile();
            cPara.closeFile();
            gammaPara.closeFile();
        }
        OutFile acc = new OutFile(basePath + "CombinedAcc.csv");
        OutFile count = new OutFile(basePath + "CombinedCount.csv");
        for (String cls : classifiers) {
            acc.writeString("," + cls);
            count.writeString("," + cls);
        }
        acc.writeString("\n");
        count.writeString("\n");
        InFile[] allTest = new InFile[classifiers.length];
        for (i = 0; i < allTest.length; ++i) {
            String p = basePath + classifiers[i] + "/" + classifiers[i] + "Test.csv";
            allTest[i] = new File(p).exists() ? new InFile(p) : null;
        }
        for (i = 0; i < fileNames.length; ++i) {
            acc.writeString(fileNames[i] + ",");
            count.writeString(fileNames[i] + ",");
            String prev = "First";
            for (int j = 0; j < allTest.length; ++j) {
                if (allTest[j] == null) {
                    acc.writeString(",");
                    count.writeString("0,");
                    continue;
                }
                try {
                    String r = allTest[j].readLine();
                    String[] res = r.split(",");
                    count.writeString(res.length - 1 + ",");
                    double mean = 0.0;
                    for (int k = 1; k < res.length; ++k) {
                        mean += Double.parseDouble(res[k]);
                    }
                    if (res.length > 1) {
                        acc.writeString(mean / (double)(res.length - 1) + ",");
                    } else {
                        acc.writeString(",");
                    }
                    prev = r;
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("failed to read line: " + ex + " previous line = " + prev);
                }
            }
            acc.writeString("\n");
            count.writeString("\n");
        }
        for (InFile inf : allTest) {
            if (inf == null) continue;
            inf.closeFile();
        }
        acc.closeFile();
        count.closeFile();
    }

    public static void collateTrainTestResults(int folds) {
        int i;
        String basePath = "C:\\Research\\Results\\UCIResults\\";
        for (String cls : classifiers) {
            File f = new File(basePath + cls);
            if (!f.isDirectory()) continue;
            OutFile clsResults = new OutFile(basePath + cls + "//" + cls + "TrainTestDiffs.csv");
            OutFile missing = null;
            int missingCount = 0;
            for (int i2 = 0; i2 < fileNames.length; ++i2) {
                int j;
                String name = fileNames[i2];
                clsResults.writeString(fileNames[i2] + ",");
                String path = basePath + cls + "//Predictions//" + fileNames[i2];
                if (missing != null && missingCount > 0) {
                    missing.writeString("\n");
                }
                missingCount = 0;
                for (j = 0; j < folds; ++j) {
                    f = new File(path + "//testFold" + j + ".csv");
                    File f2 = new File(path + "//trainFold" + j + ".csv");
                    if (f2.exists() && f2.length() > 0L && f.exists() && f.length() > 0L) {
                        InFile inf = new InFile(path + "//testFold" + j + ".csv");
                        inf.readLine();
                        inf.readLine();
                        double test = inf.readDouble();
                        inf = new InFile(path + "//trainFold" + j + ".csv");
                        inf.readLine();
                        inf.readLine();
                        double train = inf.readDouble();
                        clsResults.writeString(test - train + ",");
                        continue;
                    }
                    if (missing == null) {
                        missing = new OutFile(basePath + cls + "//" + cls + "MISSING.csv");
                    }
                    if (missingCount == 0) {
                        missing.writeString(name);
                    }
                    ++missingCount;
                    missing.writeString("," + j);
                }
                for (j = 0; j < folds; ++j) {
                }
                clsResults.writeString("\n");
            }
            clsResults.closeFile();
        }
        OutFile diff = new OutFile(basePath + "TrainTestDiff.csv");
        for (String cls : classifiers) {
            diff.writeString("," + cls);
        }
        diff.writeString("\n");
        InFile[] allDiffs = new InFile[classifiers.length];
        for (i = 0; i < allDiffs.length; ++i) {
            String p = basePath + classifiers[i] + "//" + classifiers[i] + "TrainTestDiffs.csv";
            allDiffs[i] = new File(p).exists() ? new InFile(p) : null;
        }
        for (i = 0; i < fileNames.length; ++i) {
            diff.writeString(fileNames[i] + ",");
            for (int j = 0; j < allDiffs.length; ++j) {
                if (allDiffs[j] == null) {
                    diff.writeString(",");
                    continue;
                }
                String[] res = allDiffs[j].readLine().split(",");
                diff.writeString(res.length - 1 + ",");
                double diffMean = 0.0;
                for (int k = 1; k < res.length; ++k) {
                    diffMean += Double.parseDouble(res[k]);
                }
                if (res.length > 1) {
                    diff.writeString(diffMean / (double)(res.length - 1) + ",");
                    continue;
                }
                diff.writeString(",");
            }
            diff.writeString("\n");
        }
    }

    public static Classifier setClassifier(String classifier, int fold) {
        AbstractClassifier basic;
        switch (classifier) {
            case "TunedRandF": {
                TunedRandomForest randF = new TunedRandomForest();
                randF.setNumTreesRange(numTrees);
                randF.tuneParameters(false);
                randF.debug(debug);
                randF.setSeed(fold);
                return randF;
            }
            case "TunedRotF": {
                TunedRotationForest rotF = new TunedRotationForest();
                rotF.tuneParameters(true);
                rotF.setNumTreesRange(numTrees);
                rotF.debug(debug);
                rotF.setSeed(fold);
                return rotF;
            }
            case "TunedSVM": {
                TunedSVM svm = new TunedSVM();
                svm.optimiseKernel(false);
                svm.optimiseParas(true);
                svm.debug(debug);
                svm.setSeed(fold);
                return svm;
            }
            case "Logistic": {
                basic = new Logistic();
                break;
            }
            case "IB1": {
                basic = new IB1();
                break;
            }
            case "NB": {
                basic = new NaiveBayes();
                break;
            }
            case "C4.5": {
                basic = new J48();
                break;
            }
            case "IBk": {
                basic = new IBk();
                ((IBk)basic).setCrossValidate(true);
                break;
            }
            case "RotF": {
                basic = new RotationForest();
                break;
            }
            case "RandF": {
                basic = new RandomForest();
                break;
            }
            case "SVML": {
                basic = new SMO();
                PolyKernel poly1 = new PolyKernel();
                poly1.setExponent(1.0);
                ((SMO)basic).setKernel(poly1);
                break;
            }
            case "SVMQ": {
                basic = new SMO();
                PolyKernel poly2 = new PolyKernel();
                poly2.setExponent(2.0);
                ((SMO)basic).setKernel(poly2);
                break;
            }
            case "SVMRBF": {
                basic = new SMO();
                RBFKernel kernel = new RBFKernel();
                ((SMO)basic).setKernel(kernel);
                break;
            }
            default: {
                throw new RuntimeException("Unknown classifier");
            }
        }
        return basic;
    }

    public static void singleClassifierAndFold(String[] args) {
        String predictions;
        String classifier = args[0];
        String problem = args[1];
        int fold = Integer.parseInt(args[2]) - 1;
        Classifier c = ClassifierComparison.setClassifier(classifier, fold);
        Instances all = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem);
        all.randomize(new Random());
        Instances[] split = InstanceTools.resampleInstances(all, fold, propInTrain);
        File f = new File(DataSets.resultsPath + classifier);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + classifier + "/Predictions/" + problem)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            if (c instanceof TrainAccuracyEstimate) {
                ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(predictions + "/trainFold" + fold + ".csv");
            }
            double acc = ClassifierComparison.singleClassifierAndFold(split[0], split[1], c, fold, predictions);
            System.out.println(classifier + "," + problem + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndFold(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        double acc = 0.0;
        OutFile p = null;
        try {
            c.buildClassifier(train);
            StringBuilder str = new StringBuilder();
            DecimalFormat df = new DecimalFormat("##.######");
            for (int j = 0; j < test.numInstances(); ++j) {
                int act = (int)test.instance(j).classValue();
                test.instance(j).setClassMissing();
                double[] probs = c.distributionForInstance(test.instance(j));
                int pred = 0;
                for (int i = 1; i < probs.length; ++i) {
                    if (!(probs[i] > probs[pred])) continue;
                    pred = i;
                }
                if (act == pred) {
                    acc += 1.0;
                }
                str.append(act);
                str.append(",");
                str.append(pred);
                str.append(",,");
                for (double d : probs) {
                    str.append(df.format(d));
                    str.append(",");
                }
                str.append("\n");
            }
            acc /= (double)test.numInstances();
            p = new OutFile(resultsPath + "/testFold" + fold + ".csv");
            if (p == null) {
                throw new Exception(" file wont open!! " + resultsPath + "/testFold" + fold + ".csv");
            }
            p.writeLine(train.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                p.writeLine("No parameter info");
            }
            p.writeLine(acc + "");
            p.writeLine(str.toString());
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method singleClassifierAndFold in class ClassifierComparison");
            System.out.println(" Classifier = " + c.getClass().getName());
            System.out.println(" Results path=" + resultsPath);
            System.out.println(" Outfile = " + p);
            System.out.println(" Train Split = " + train.toSummaryString());
            System.out.println(" Test Split = " + test.toSummaryString());
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void collateResults() {
        int i;
        String basePath = "C:\\Users\\ajb\\Dropbox\\Results\\Forest\\";
        OutFile acc = new OutFile(basePath + "CombinedAcc.csv");
        for (String cls : classifiers) {
            acc.writeString("," + cls);
        }
        acc.writeString("\n");
        InFile[] allTest = new InFile[classifiers.length];
        for (i = 0; i < allTest.length; ++i) {
            String p = basePath + classifiers[i] + "Test.csv";
            allTest[i] = new File(p).exists() ? new InFile(p) : null;
        }
        for (i = 0; i < fileNames.length; ++i) {
            acc.writeString(fileNames[i] + ",");
            String prev = "First";
            for (int j = 0; j < allTest.length; ++j) {
                if (allTest[j] == null) {
                    acc.writeString(",");
                    continue;
                }
                try {
                    String r = allTest[j].readLine();
                    String[] res = r.split(",");
                    double mean = 0.0;
                    for (int k = 1; k < res.length; ++k) {
                        mean += Double.parseDouble(res[k]);
                    }
                    if (res.length > 1) {
                        acc.writeString(mean / (double)(res.length - 1) + ",");
                    } else {
                        acc.writeString(",");
                    }
                    prev = r;
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("failed to read line: " + ex + " previous line = " + prev);
                    System.exit(0);
                }
            }
            acc.writeString("\n");
        }
        for (InFile inf : allTest) {
            if (inf == null) continue;
            inf.closeFile();
        }
    }

    public static void summariseData() {
        OutFile out = new OutFile(DataSets.problemPath + "SummaryInfo.csv");
        out.writeLine("problem,numCases,numAtts,numClasses");
        for (String str : fileNames) {
            File f = new File(DataSets.problemPath + str + "/" + str + ".arff");
            if (f.exists()) {
                Instances ins = ClassifierTools.loadData(DataSets.problemPath + str + "/" + str);
                out.writeLine(str + "," + ins.numInstances() + "," + (ins.numAttributes() - 1) + "," + ins.numClasses());
                continue;
            }
            out.writeLine(str + ",,");
        }
    }

    public static void collateSVMParameters() {
        InFile c = new InFile("C:\\Research\\Papers\\2017\\ECML Standard Parameters\\Section 6 choosing parameters\\TunedSVMParameterC.csv");
        InFile g = new InFile("C:\\Research\\Papers\\2017\\ECML Standard Parameters\\Section 6 choosing parameters\\TunedSVMParameterGamma.csv");
        int[][] counts = new int[25][25];
        double[] vals = new double[]{1.5E-5, 3.1E-5, 6.1E-5, 1.22E-4, 2.44E-4, 4.88E-4, 9.77E-4, 0.001953, 0.003906, 0.007813, 0.015625, 0.03125, 0.0625, 0.125, 0.25, 0.5, 1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0};
        for (int i = 0; i < fileNames.length; ++i) {
            String line = c.readLine();
            String gLine = g.readLine();
            String[] splitC = line.split(",");
            String[] splitG = gLine.split(",");
            System.out.print("\n Problem=" + splitC[0]);
            int cPos = 0;
            for (int j = 1; j < splitC.length; ++j) {
                if (splitC[j].equals("")) continue;
                int k = 0;
                double v = Double.parseDouble(splitC[j]);
                try {
                    while (vals[k] != v) {
                        ++k;
                    }
                    cPos = k;
                }
                catch (Exception e) {
                    System.out.println(" EXCEPTION : =" + e + " v = " + v + " k=" + k);
                }
                k = 0;
                v = Double.parseDouble(splitG[j]);
                while (vals[k] != v) {
                    ++k;
                }
                int gPos = k;
                int[] nArray = counts[cPos];
                int n = gPos;
                nArray[n] = nArray[n] + 1;
            }
        }
        OutFile svm = new OutFile("C:\\Research\\Papers\\2017\\ECML Standard Parameters\\Section 6 choosing parameters\\svmParaCounts.csv");
        for (int i = 0; i < counts.length; ++i) {
            for (int j = 0; j < counts[i].length; ++j) {
                svm.writeString(counts[i][j] + ",");
            }
            svm.writeString("\n");
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            System.out.println(new File("C:\\Program Files\\Java\\jdk1.8.0_40\\bin").toURI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
        ClassifierComparison.generateScripts(true, 8000);
        ClassifierComparison.generateScripts(false, 8000);
        System.exit(0);
        if (args.length > 0) {
            DataSets.problemPath = DataSets.clusterPath + "UCIContinuous/";
            DataSets.resultsPath = DataSets.clusterPath + "Results/UCIResults/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            ClassifierComparison.singleClassifierAndFold(args);
        } else {
            DataSets.problemPath = DataSets.dropboxPath + "UCI Problems/";
            DataSets.resultsPath = DataSets.dropboxPath + "Results/UCIResults/";
            File f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            String[] paras = new String[]{"TunedRandF", "balloons", "1"};
            ClassifierComparison.singleClassifierAndFold(paras);
        }
    }
}

