/*
 * Decompiled with CFR 0.152.
 */
package papers;

import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.boss.BOSSSpatialPyramids;
import timeseriesweka.classifiers.boss.BOSSSpatialPyramids_BD;
import timeseriesweka.classifiers.boss.BoTSWEnsemble;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import weka.core.Instances;

public class PKDD2017 {
    public static final boolean verbose = false;
    public static final int numResamples = 25;
    public static String[] allDatasets = new String[]{"Adiac", "ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Car", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "Computers", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "DistalPhalanxOutlineCorrect", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxTW", "Earthquakes", "ECG200", "ECG5000", "ECGFiveDays", "FaceAll", "FaceFour", "FacesUCR", "FiftyWords", "Fish", "GunPoint", "Ham", "Haptics", "Herring", "InlineSkate", "InsectWingbeatSound", "ItalyPowerDemand", "LargeKitchenAppliances", "Lightning2", "Lightning7", "Mallat", "Meat", "MedicalImages", "MiddlePhalanxOutlineCorrect", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxTW", "MoteStrain", "OliveOil", "OSULeaf", "PhalangesOutlinesCorrect", "Phoneme", "Plane", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "ShapesAll", "SmallKitchenAppliances", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2", "Strawberry", "SwedishLeaf", "Symbols", "SyntheticControl", "ToeSegmentation1", "ToeSegmentation2", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "Wafer", "Wine", "WordSynonyms", "Worms", "WormsTwoClass", "Yoga"};
    public static String[] quickTestDataset = new String[]{"ItalyPowerDemand"};
    public static String[] datasetsToRun;

    public static void main(String[] args) throws Exception {
        datasetsToRun = quickTestDataset;
        PKDD2017.reproduceBOSSResults();
        PKDD2017.reproduceResultsBOTSW_HI();
        PKDD2017.reproduceResultsBOTSW_BD();
        PKDD2017.reproduceResultsBOSSSP_HI();
        PKDD2017.reproduceResultsBOSSSP_BD();
    }

    public static void reproduceBOSSResults() throws Exception {
        for (String dset : datasetsToRun) {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println("Starting BOSS on " + dset);
            BOSS boss = new BOSS();
            double[] accs = new double[25];
            for (int i = 0; i < 25; ++i) {
                Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
                boss.buildClassifier(data[0]);
                accs[i] = ClassifierTools.accuracy(data[1], boss);
            }
            double mean = 0.0;
            for (int i = 0; i < 25; ++i) {
                mean += accs[i];
            }
            System.out.println("BOSS on " + dset + " over " + 25 + " folds: " + (mean /= 25.0) + "\n");
        }
    }

    public static void reproduceResultsBOTSW_HI() throws Exception {
        for (String dset : datasetsToRun) {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println("Starting BOTSW_HI on " + dset);
            BoTSWEnsemble botsw = new BoTSWEnsemble();
            botsw.setDistanceFunction(BoTSWEnsemble.BoTSW.DistFunction.HISTOGRAM_INTERSECTION);
            double[] accs = new double[25];
            for (int i = 0; i < 25; ++i) {
                Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
                botsw.buildClassifier(data[0]);
                accs[i] = ClassifierTools.accuracy(data[1], botsw);
            }
            double mean = 0.0;
            for (int i = 0; i < 25; ++i) {
                mean += accs[i];
            }
            System.out.println("BOTSW_HI on " + dset + " over " + 25 + " folds: " + (mean /= 25.0) + "\n");
        }
    }

    public static void reproduceResultsBOTSW_BD() throws Exception {
        for (String dset : datasetsToRun) {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println("Starting BOTSW_BD on " + dset);
            BoTSWEnsemble botsw = new BoTSWEnsemble();
            botsw.setDistanceFunction(BoTSWEnsemble.BoTSW.DistFunction.BOSS_DISTANCE);
            double[] accs = new double[25];
            for (int i = 0; i < 25; ++i) {
                Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
                botsw.buildClassifier(data[0]);
                accs[i] = ClassifierTools.accuracy(data[1], botsw);
            }
            double mean = 0.0;
            for (int i = 0; i < 25; ++i) {
                mean += accs[i];
            }
            System.out.println("BOTSW_BD on " + dset + " over " + 25 + " folds: " + (mean /= 25.0) + "\n");
        }
    }

    public static void reproduceResultsBOSSSP_HI() throws Exception {
        for (String dset : datasetsToRun) {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println("Starting BOSSSP_HI on " + dset);
            BOSSSpatialPyramids bosssp = new BOSSSpatialPyramids();
            double[] accs = new double[25];
            for (int i = 0; i < 25; ++i) {
                Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
                bosssp.buildClassifier(data[0]);
                accs[i] = ClassifierTools.accuracy(data[1], bosssp);
            }
            double mean = 0.0;
            for (int i = 0; i < 25; ++i) {
                mean += accs[i];
            }
            System.out.println("BOSSSP_HI on " + dset + " over " + 25 + " folds: " + (mean /= 25.0) + "\n");
        }
    }

    public static void reproduceResultsBOSSSP_BD() throws Exception {
        for (String dset : datasetsToRun) {
            Instances train = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\TSC Problems\\" + dset + "\\" + dset + "_TEST.arff");
            System.out.println("Starting BOSSSP_BD on " + dset);
            BOSSSpatialPyramids_BD bosssp = new BOSSSpatialPyramids_BD();
            double[] accs = new double[25];
            for (int i = 0; i < 25; ++i) {
                Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, i);
                bosssp.buildClassifier(data[0]);
                accs[i] = ClassifierTools.accuracy(data[1], bosssp);
            }
            double mean = 0.0;
            for (int i = 0; i < 25; ++i) {
                mean += accs[i];
            }
            System.out.println("BOSSSP_BD on " + dset + " over " + 25 + " folds: " + (mean /= 25.0) + "\n");
        }
    }
}

