/*
 * Decompiled with CFR 0.152.
 */
package papers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQuality;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.SMO;
import weka.classifiers.lazy.IB1;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.classifiers.trees.shapelet_trees.FStatShapeletTreeWithInfoGain;
import weka.classifiers.trees.shapelet_trees.KruskalWallisTree;
import weka.classifiers.trees.shapelet_trees.MoodsMedianTree;
import weka.classifiers.trees.shapelet_trees.MoodsMedianTreeWithInfoGain;
import weka.classifiers.trees.shapelet_trees.ShapeletTreeClassifier;
import weka.core.Instances;

public class Hills14shapelet {
    private static String[] fileNames = new String[]{"Adiac", "Beef", "ChlorineConcentration", "Coffee", "DiatomSizeReduction", "DP_Little", "DP_Middle", "DP_Thumb", "ECGFiveDays", "ElectricDevices", "FaceFour", "GunPoint", "ItalyPowerDemand", "Lighting7", "MedicalImages", "MoteStrain", "MP_Little", "MP_Middle", "PP_Little", "PP_Middle", "PP_Thumb", "SonyAIBORobotSurface", "Symbols", "SyntheticControl", "Trace", "TwoLeadECG", "Herrings", "SyntheticData"};
    private static final String userPath = "C:\\Users\\ajb\\Dropbox\\TSC Problems\\";
    private static String[] filePaths = new String[]{"C:\\Users\\ajb\\Dropbox\\TSC Problems\\Adiac/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Beef/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\ChlorineConcentration/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Coffee/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\DiatomSizeReduction/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Bones/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Bones/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Bones/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\ECGFiveDays/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\ElectricDevices/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\FaceFour/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\GunPoint/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\ItalyPowerDemand/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Lighting7/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\MedicalImages/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\MoteStrain/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Bones/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Bones/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Bones/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Bones/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Bones/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\SonyAIBORobotSurface/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Symbols/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\SyntheticControl/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Trace/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\TwoLeadECG/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\Otoliths/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\SyntheticData/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\MPEG7Shapes/", "C:\\Users\\ajb\\Dropbox\\TSC Problems\\MPEG7Shapes/"};
    private static AssesmentType[] assesmentTypes = new AssesmentType[]{AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.TRAIN_TEST, AssesmentType.LOOCV, AssesmentType.TRAIN_TEST, AssesmentType.LOOCV, AssesmentType.LOOCV, AssesmentType.TRAIN_TEST};
    private static int[][] shapeletMinMax = new int[][]{{3, 10}, {8, 30}, {7, 20}, {18, 30}, {7, 16}, {9, 36}, {15, 43}, {11, 47}, {24, 76}, {10, 42}, {20, 120}, {24, 55}, {7, 14}, {20, 80}, {9, 35}, {16, 31}, {15, 41}, {20, 53}, {13, 38}, {14, 34}, {14, 41}, {15, 36}, {52, 155}, {20, 56}, {62, 232}, {7, 13}, {30, 101}, {30, 101}, {25, 35}, {30, 101}, {30, 101}, {30, 110}};
    private static ShapeletTransform shapeletFilter;
    private static Instances[] instancesTrain;
    private static Instances[] instancesTest;
    private static Classifier[] classifiers;
    private static String[] classifierNames;
    private static int tableToProduceIndex;
    private static String outFileName;
    private static int fileToProcessIndex;
    private static int classifierToProcessIndex;

    private static void loadData() {
        instancesTrain = new Instances[fileNames.length];
        instancesTest = new Instances[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            if (assesmentTypes[i] == AssesmentType.TRAIN_TEST) {
                Hills14shapelet.instancesTrain[i] = ShapeletTransform.loadData(filePaths[i] + fileNames[i] + "_TRAIN.arff");
                Hills14shapelet.instancesTest[i] = ShapeletTransform.loadData(filePaths[i] + fileNames[i] + "_TEST.arff");
            } else if (assesmentTypes[i] == AssesmentType.LOOCV) {
                Hills14shapelet.instancesTrain[i] = ShapeletTransform.loadData(filePaths[i] + fileNames[i] + ".arff");
                Hills14shapelet.instancesTest[i] = null;
            }
            instancesTrain[i].setClassIndex(instancesTrain[i].numAttributes() - 1);
            if (assesmentTypes[i] != AssesmentType.TRAIN_TEST) continue;
            instancesTest[i].setClassIndex(instancesTest[i].numAttributes() - 1);
        }
    }

    public static void table2() throws Exception {
        classifiers = new Classifier[4];
        Hills14shapelet.classifiers[0] = new ShapeletTreeClassifier("infoTree.txt");
        Hills14shapelet.classifiers[1] = new KruskalWallisTree("kwTree.txt");
        Hills14shapelet.classifiers[2] = new MoodsMedianTreeWithInfoGain("mmWithInfoTree.txt");
        Hills14shapelet.classifiers[3] = new FStatShapeletTreeWithInfoGain("fStatTree.txt");
        classifierNames = new String[4];
        Hills14shapelet.classifierNames[0] = "IG";
        Hills14shapelet.classifierNames[1] = "KruskalWallis";
        Hills14shapelet.classifierNames[2] = "MoodMedIG";
        Hills14shapelet.classifierNames[3] = "F-stat";
        if ((classifierToProcessIndex < 1 || classifierToProcessIndex > classifiers.length) && classifierToProcessIndex != -1) {
            throw new IOException("Invalid classifier identifier.");
        }
        if (classifierToProcessIndex != -1) {
            --classifierToProcessIndex;
        }
        double[][] accuracies = new double[classifiers.length][];
        for (int i = 0; i < classifiers.length; ++i) {
            if (i != classifierToProcessIndex && classifierToProcessIndex != -1) continue;
            accuracies[i] = Hills14shapelet.classifierAccuracy(i, false, true, false);
        }
        Hills14shapelet.writeFileContent(accuracies);
    }

    public static void table3() throws Exception {
        classifiers = new Classifier[4];
        Hills14shapelet.classifiers[0] = new ShapeletTreeClassifier("infoTree.txt");
        Hills14shapelet.classifiers[1] = new FStatShapeletTreeWithInfoGain("fStatTree.txt");
        Hills14shapelet.classifiers[2] = new KruskalWallisTree("kwTree.txt");
        Hills14shapelet.classifiers[3] = new MoodsMedianTree("mmTree.txt");
        classifierNames = new String[4];
        Hills14shapelet.classifierNames[0] = "Information Gain";
        Hills14shapelet.classifierNames[1] = "F-stat";
        Hills14shapelet.classifierNames[2] = "Kruskal-Wallis";
        Hills14shapelet.classifierNames[3] = "Mood's Median";
        if ((classifierToProcessIndex < 1 || classifierToProcessIndex > classifiers.length) && classifierToProcessIndex != -1) {
            throw new IOException("Invalid classifier identifier.");
        }
        if (classifierToProcessIndex != -1) {
            --classifierToProcessIndex;
        }
        double[][] times = new double[classifiers.length][instancesTrain.length];
        for (int i = 0; i < classifiers.length; ++i) {
            if (i != classifierToProcessIndex && classifierToProcessIndex != -1) continue;
            for (int j = 0; j < instancesTrain.length; ++j) {
                if (fileToProcessIndex != j && fileToProcessIndex != -1) continue;
                Instances data = null;
                if (assesmentTypes[j] == AssesmentType.TRAIN_TEST) {
                    data = instancesTrain[j];
                } else if (assesmentTypes[j] == AssesmentType.LOOCV) {
                    data = instancesTrain[j].trainCV(instancesTrain[j].numInstances(), 0);
                }
                if (classifiers[i] instanceof ShapeletTreeClassifier) {
                    times[i][j] = ((ShapeletTreeClassifier)classifiers[i]).timingForSingleShapelet(data, shapeletMinMax[j][0], shapeletMinMax[j][1]);
                    continue;
                }
                if (classifiers[i] instanceof KruskalWallisTree) {
                    times[i][j] = ((KruskalWallisTree)classifiers[i]).timingForSingleShapelet(data, shapeletMinMax[j][0], shapeletMinMax[j][1]);
                    continue;
                }
                if (classifiers[i] instanceof MoodsMedianTree) {
                    times[i][j] = ((MoodsMedianTree)classifiers[i]).timingForSingleShapelet(data, shapeletMinMax[j][0], shapeletMinMax[j][1]);
                    continue;
                }
                if (classifiers[i] instanceof MoodsMedianTreeWithInfoGain) {
                    times[i][j] = ((MoodsMedianTreeWithInfoGain)classifiers[i]).timingForSingleShapelet(data, shapeletMinMax[j][0], shapeletMinMax[j][1]);
                    continue;
                }
                if (!(classifiers[i] instanceof FStatShapeletTreeWithInfoGain)) continue;
                times[i][j] = ((FStatShapeletTreeWithInfoGain)classifiers[i]).timingForSingleShapelet(data, shapeletMinMax[j][0], shapeletMinMax[j][1]);
            }
        }
        Hills14shapelet.writeFileContent(times);
    }

    public static void table4_5() throws Exception {
        classifiers = new Classifier[8];
        Hills14shapelet.classifiers[0] = new ShapeletTreeClassifier("infoTree.txt");
        Hills14shapelet.classifiers[1] = new J48();
        Hills14shapelet.classifiers[2] = new IB1();
        Hills14shapelet.classifiers[3] = new NaiveBayes();
        Hills14shapelet.classifiers[4] = new BayesNet();
        Hills14shapelet.classifiers[5] = new RandomForest();
        Hills14shapelet.classifiers[6] = new RotationForest();
        Hills14shapelet.classifiers[7] = new SMO();
        classifierNames = new String[8];
        Hills14shapelet.classifierNames[0] = "ShapeletTree";
        Hills14shapelet.classifierNames[1] = "C4.5";
        Hills14shapelet.classifierNames[2] = "1NN";
        Hills14shapelet.classifierNames[3] = "Naive Bayes";
        Hills14shapelet.classifierNames[4] = "Bayesian Network";
        Hills14shapelet.classifierNames[5] = "Random Forest";
        Hills14shapelet.classifierNames[6] = "Rotation Forest";
        Hills14shapelet.classifierNames[7] = "SVM (linear)";
        if ((classifierToProcessIndex < 1 || classifierToProcessIndex > classifiers.length) && classifierToProcessIndex != -1) {
            throw new IOException("Invalid classifier identifier.");
        }
        if (classifierToProcessIndex != -1) {
            --classifierToProcessIndex;
        }
        double[][] accuracies = new double[classifiers.length][];
        boolean transFlag = false;
        for (int i = 0; i < classifiers.length; ++i) {
            if (!(classifiers[i] instanceof ShapeletTreeClassifier)) {
                transFlag = true;
            }
            if (i != classifierToProcessIndex && classifierToProcessIndex != -1) continue;
            accuracies[i] = Hills14shapelet.classifierAccuracy(i, transFlag, false, true);
        }
        Hills14shapelet.writeFileContent(accuracies);
    }

    private static double[] classifierAccuracy(int classifierIndex, boolean useTransformedData, boolean computeErrorRate, boolean usePercentage) {
        double[] accuracies = new double[instancesTrain.length];
        for (int n = 0; n < instancesTrain.length; ++n) {
            if (fileToProcessIndex != n && fileToProcessIndex != -1) continue;
            try {
                if (assesmentTypes[n] == AssesmentType.TRAIN_TEST) {
                    accuracies[n] = Hills14shapelet.classiferAccuracyTrainTest(classifierIndex, n, useTransformedData);
                } else if (assesmentTypes[n] == AssesmentType.LOOCV) {
                    accuracies[n] = Hills14shapelet.classiferAccuracyLOOCV(classifierIndex, n, useTransformedData);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (computeErrorRate) {
                accuracies[n] = 1.0 - accuracies[n];
            }
            if (!usePercentage) continue;
            int n2 = n;
            accuracies[n2] = accuracies[n2] * 100.0;
        }
        return accuracies;
    }

    private static double classiferAccuracyTrainTest(int classifierIndex, int dataIndex, boolean useTransformedData) {
        double accuracy = 0.0;
        Instances trainData = null;
        Instances testData = null;
        if (useTransformedData) {
            try {
                shapeletFilter = ShapeletTransform.createFilterFromFile(filePaths[dataIndex] + fileNames[dataIndex] + "_TRAIN_TRANS.txt", instancesTrain[dataIndex].numAttributes() / 2);
                shapeletFilter.supressOutput();
            }
            catch (Exception e) {
                shapeletFilter = new ShapeletTransform();
                shapeletFilter.setQualityMeasure(ShapeletQuality.ShapeletQualityChoice.INFORMATION_GAIN);
                shapeletFilter.supressOutput();
                shapeletFilter.setNumberOfShapelets(instancesTrain[dataIndex].numAttributes() / 2);
                shapeletFilter.setShapeletMinAndMax(shapeletMinMax[dataIndex][0], shapeletMinMax[dataIndex][1]);
                shapeletFilter.setLogOutputFile(filePaths[dataIndex] + fileNames[dataIndex] + "_TRAIN_TRANS.txt");
            }
            try {
                trainData = shapeletFilter.process(instancesTrain[dataIndex]);
                testData = shapeletFilter.process(instancesTest[dataIndex]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            trainData = instancesTrain[dataIndex];
            testData = instancesTest[dataIndex];
        }
        Hills14shapelet.buildClassifier(classifierIndex, trainData, dataIndex);
        for (int j = 0; j < testData.numInstances(); ++j) {
            double classifierPrediction = 0.0;
            try {
                classifierPrediction = classifiers[classifierIndex].classifyInstance(testData.instance(j));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double actualClass = testData.instance(j).classValue();
            if (classifierPrediction == actualClass) {
                accuracy += 1.0;
            }
            if (j != testData.numInstances() - 1) continue;
            accuracy /= (double)testData.numInstances();
        }
        return accuracy;
    }

    private static double classiferAccuracyLOOCV(int classifierIndex, int dataIndex, boolean useTransformedData) {
        Instances data = instancesTrain[dataIndex];
        double accuracy = 0.0;
        for (int n = 0; n < data.numInstances(); ++n) {
            System.out.println("\n\n\n\n\nProcessing fold: " + n + "\n\n\n\n\n");
            Instances trainFold = data.trainCV(data.numInstances(), n);
            Instances testFold = data.testCV(data.numInstances(), n);
            if (useTransformedData) {
                try {
                    shapeletFilter = ShapeletTransform.createFilterFromFile(filePaths[dataIndex] + fileNames[dataIndex] + "_TRANS_" + n + ".txt", instancesTrain[dataIndex].numAttributes() / 2);
                    shapeletFilter.supressOutput();
                }
                catch (Exception e) {
                    shapeletFilter = new ShapeletTransform();
                    shapeletFilter.setQualityMeasure(ShapeletQuality.ShapeletQualityChoice.INFORMATION_GAIN);
                    shapeletFilter.supressOutput();
                    shapeletFilter.setNumberOfShapelets(instancesTrain[dataIndex].numAttributes() / 2);
                    shapeletFilter.setShapeletMinAndMax(shapeletMinMax[dataIndex][0], shapeletMinMax[dataIndex][1]);
                    shapeletFilter.setLogOutputFile(filePaths[dataIndex] + fileNames[dataIndex] + "_TRANS_" + n + ".txt");
                }
                try {
                    trainFold = shapeletFilter.process(trainFold);
                    testFold = shapeletFilter.process(testFold);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Hills14shapelet.buildClassifier(classifierIndex, trainFold, dataIndex);
            double classifierPrediction = 0.0;
            try {
                classifierPrediction = classifiers[classifierIndex].classifyInstance(testFold.instance(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double actualClass = testFold.instance(0).classValue();
            if (classifierPrediction == actualClass) {
                accuracy += 1.0;
            }
            if (n != data.numInstances() - 1) continue;
            accuracy /= (double)data.numInstances();
        }
        return accuracy;
    }

    private static void buildClassifier(int classifierIndex, Instances instances, int dataSetIndex) {
        if (classifiers[classifierIndex] instanceof ShapeletTreeClassifier) {
            ((ShapeletTreeClassifier)classifiers[classifierIndex]).setShapeletMinMaxLength(shapeletMinMax[dataSetIndex][0], shapeletMinMax[dataSetIndex][1]);
        } else if (classifiers[classifierIndex] instanceof KruskalWallisTree) {
            ((KruskalWallisTree)classifiers[classifierIndex]).setShapeletMinMaxLength(shapeletMinMax[dataSetIndex][0], shapeletMinMax[dataSetIndex][1]);
        } else if (classifiers[classifierIndex] instanceof MoodsMedianTree) {
            ((MoodsMedianTree)classifiers[classifierIndex]).setShapeletMinMaxLength(shapeletMinMax[dataSetIndex][0], shapeletMinMax[dataSetIndex][1]);
        } else if (classifiers[classifierIndex] instanceof MoodsMedianTreeWithInfoGain) {
            ((MoodsMedianTreeWithInfoGain)classifiers[classifierIndex]).setShapeletMinMaxLength(shapeletMinMax[dataSetIndex][0], shapeletMinMax[dataSetIndex][1]);
        } else if (classifiers[classifierIndex] instanceof FStatShapeletTreeWithInfoGain) {
            ((FStatShapeletTreeWithInfoGain)classifiers[classifierIndex]).setShapeletMinMaxLength(shapeletMinMax[dataSetIndex][0], shapeletMinMax[dataSetIndex][1]);
        }
        try {
            classifiers[classifierIndex].buildClassifier(instances);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeFileContent(double[][] content) {
        int i;
        if (outFileName == null || outFileName.isEmpty()) {
            outFileName = "Table_" + tableToProduceIndex + "_File_" + (fileToProcessIndex + 1) + "_Classifier_" + (classifierToProcessIndex + 1) + ".csv";
        }
        StringBuilder sb = new StringBuilder();
        if (!Hills14shapelet.isFileExists(outFileName)) {
            sb.append("Data Set, ");
            for (i = 0; i < classifierNames.length; ++i) {
                if (i == classifierToProcessIndex || classifierToProcessIndex == -1) {
                    sb.append(classifierNames[i]);
                }
                if (-1 != classifierToProcessIndex || i == classifierNames.length - 1) continue;
                sb.append(", ");
            }
            Hills14shapelet.writeToFile(outFileName, sb.toString(), false);
        }
        sb = new StringBuilder();
        for (i = 0; i < fileNames.length; ++i) {
            if (fileToProcessIndex != i && fileToProcessIndex != -1) continue;
            for (int k = 0; k < classifiers.length; ++k) {
                if (k == 0) {
                    sb.append(fileNames[i]);
                    sb.append(", ");
                }
                if (k == classifierToProcessIndex || classifierToProcessIndex == -1) {
                    sb.append(content[k][i]);
                }
                if (-1 != classifierToProcessIndex || k == classifiers.length - 1) continue;
                sb.append(", ");
            }
        }
        Hills14shapelet.writeToFile(outFileName, sb.toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String filename, String text, boolean append) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(filename, append));
            bufferedWriter.write(text);
            bufferedWriter.newLine();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static boolean isFileExists(String filename) {
        File f = new File(filename);
        return f.isFile() && f.canWrite();
    }

    public static void main(String[] args) throws Exception {
        tableToProduceIndex = 2;
        try {
            tableToProduceIndex = Integer.parseInt(args[0]);
            outFileName = args[1];
            fileToProcessIndex = Integer.parseInt(args[2]);
            classifierToProcessIndex = Integer.parseInt(args[3]);
            if (fileToProcessIndex < 1 || fileToProcessIndex > fileNames.length) {
                throw new IOException("Invalid file identifier.");
            }
            --fileToProcessIndex;
        }
        catch (Exception e) {
            System.err.println("Invalid user input. Using default values");
            tableToProduceIndex = 2;
            fileToProcessIndex = 0;
            classifierToProcessIndex = -1;
        }
        Hills14shapelet.loadData();
        try {
            switch (tableToProduceIndex) {
                case 2: {
                    Hills14shapelet.table2();
                    break;
                }
                case 3: {
                    Hills14shapelet.table3();
                    break;
                }
                case 4: {
                    Hills14shapelet.table4_5();
                    break;
                }
                case 5: {
                    Hills14shapelet.table4_5();
                    break;
                }
                default: {
                    throw new IOException("Unknow table identifier.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static enum AssesmentType {
        LOOCV,
        TRAIN_TEST;

    }
}

