/*
 * Decompiled with CFR 0.152.
 */
package papers;

import development.DataSets;
import fileIO.InFile;
import fileIO.OutFile;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import timeseriesweka.classifiers.FastDTW_1NN;
import timeseriesweka.classifiers.ensembles.TransformEnsembles;
import timeseriesweka.filters.ACF;
import timeseriesweka.filters.PowerSpectrum;
import utilities.ClassifierTools;
import weka.attributeSelection.PrincipalComponents;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.IteratedSingleClassifierEnhancer;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.lazy.kNN;
import weka.classifiers.meta.AdaBoostM1;
import weka.classifiers.meta.Bagging;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;
import weka.filters.NormalizeCase;

public class Bagnall12ensemble {
    static String resultPath = "C:\\Users\\ajb\\Dropbox\\Results\\Ensembles";
    public static String[] sdm2012fileNames = new String[]{"Adiac", "ARSim", "Beef", "CBF", "Lighting2", "Lighting7", "ECG200", "FaceFour", "fiftywords", "fish", "GunPoint", "OSULeaf", "SwedishLeaf", "SyntheticControl", "Trace", "TwoPatterns", "wafer", "yoga", "FaceAll", "Coffee", "OliveOil", "Earthquakes", "HandOutlines", "FordA", "FordB", "ElectricDevices"};

    public static boolean normalise(String fileName) {
        return fileName.equals("FordA") || fileName.equals("FordB") || fileName.equals("OliveOil") || fileName.equals("Beef") || fileName.equals("Coffee") || fileName.equals("Earthquakes");
    }

    public static Classifier[] getFilters(ArrayList<String> names) {
        ArrayList<kNN> sc2 = new ArrayList<kNN>();
        for (double i = 1.0; i > 0.0; i -= 0.1) {
            kNN c1 = new kNN(1);
            c1.setFilterAttributes(true);
            c1.setProportion(i);
            sc2.add(c1);
            names.add("(1NN" + i + ")");
        }
        Classifier[] sc = new Classifier[sc2.size()];
        for (int i = 0; i < sc.length; ++i) {
            sc[i] = (Classifier)sc2.get(i);
        }
        return sc;
    }

    public static Classifier[] setSingleClassifiers(ArrayList<String> names) {
        ArrayList<AbstractClassifier> sc2 = new ArrayList<AbstractClassifier>();
        sc2.add(new kNN(1));
        names.add("NN");
        AbstractClassifier c = new FastDTW_1NN();
        c.optimiseWindow(false);
        sc2.add(c);
        names.add("NNDTW");
        sc2.add(new NaiveBayes());
        names.add("NB");
        sc2.add(new J48());
        names.add("C45");
        c = new SMO();
        PolyKernel kernel = new PolyKernel();
        kernel.setExponent(1.0);
        ((SMO)c).setKernel(kernel);
        sc2.add(c);
        names.add("SVML");
        c = new SMO();
        kernel = new PolyKernel();
        kernel.setExponent(2.0);
        ((SMO)c).setKernel(kernel);
        sc2.add(c);
        names.add("SVMQ");
        c = new SMO();
        RBFKernel kernel2 = new RBFKernel();
        ((SMO)c).setKernel(kernel2);
        sc2.add(c);
        names.add("SVMR");
        c = new RandomForest();
        ((RandomForest)c).setNumTrees(30);
        sc2.add(c);
        names.add("RandF30");
        c = new RandomForest();
        ((RandomForest)c).setNumTrees(100);
        sc2.add(c);
        names.add("RandF100");
        c = new RotationForest();
        sc2.add(c);
        names.add("RotF30");
        Classifier[] sc = new Classifier[sc2.size()];
        for (int i = 0; i < sc.length; ++i) {
            sc[i] = (Classifier)sc2.get(i);
        }
        return sc;
    }

    public static Classifier[] setNNClassifiers(ArrayList<String> names) {
        ArrayList<AbstractClassifier> sc2 = new ArrayList<AbstractClassifier>();
        kNN c1 = new kNN(1);
        sc2.add(c1);
        names.add("(1NN)");
        kNN c2 = new kNN(50);
        c2.setCrossValidate(true);
        sc2.add(c2);
        names.add("(kNN)");
        kNN c3 = new kNN(1);
        c3.setFilterAttributes(true);
        c3.setProportion(0.5);
        sc2.add(c3);
        names.add("(1NN-50\\% Filter");
        int bagPercent = 50;
        IteratedSingleClassifierEnhancer c = new Bagging();
        c.setClassifier(new kNN(1));
        c.setNumIterations(20);
        c.setBagSizePercent(bagPercent);
        names.add("Bagging," + bagPercent + "%,20 1NN");
        sc2.add(c);
        c = new Bagging();
        c.setClassifier(new kNN(1));
        c.setNumIterations(50);
        c.setBagSizePercent(66);
        names.add("Bagging," + bagPercent + "%,100 1NN");
        sc2.add(c);
        c = new AdaBoostM1();
        ((AdaBoostM1)c).setClassifier(new kNN(1));
        ((AdaBoostM1)c).setNumIterations(20);
        ((AdaBoostM1)c).setUseResampling(true);
        sc2.add(c);
        names.add("Boosting 20 1NN");
        Classifier[] sc = new Classifier[sc2.size()];
        for (int i = 0; i < sc.length; ++i) {
            sc[i] = (Classifier)sc2.get(i);
        }
        System.out.print("Testing NN Classifiers: ");
        for (String s : names) {
            System.out.print(s + ",");
        }
        return sc;
    }

    public static void timeDomain(String tableName) {
        OutFile of = new OutFile(resultPath + "table" + tableName + ".csv");
        ArrayList<String> names = new ArrayList<String>();
        Classifier[] sc = null;
        if (tableName.equals("SingleClassifiers")) {
            System.out.println("SINGLE CLASSIFIERS");
            of.writeLine("SINGLE CLASSIFIERS,  results in Time Domain");
            sc = Bagnall12ensemble.setSingleClassifiers(names);
        } else if (tableName.equals("NN_EuclidClassifiers")) {
            System.out.println("NN Euclidean CLASSIFIER VARIANTS");
            of.writeLine("NN CLASSIFIERS,  results in Time Domain");
            sc = Bagnall12ensemble.setNNClassifiers(names);
        } else {
            System.out.println("ERROR: Unknown classifier generation name");
            System.exit(0);
        }
        of.writeString(",,");
        for (String s : names) {
            of.writeString(s + ",");
        }
        of.writeLine("\n");
        try {
            for (int i = 0; i < sdm2012fileNames.length; ++i) {
                Instances test = ClassifierTools.loadData(DataSets.dropboxPath + sdm2012fileNames[i] + "\\" + sdm2012fileNames[i] + "_TEST");
                Instances train = ClassifierTools.loadData(DataSets.dropboxPath + sdm2012fileNames[i] + "\\" + sdm2012fileNames[i] + "_TRAIN");
                if (Bagnall12ensemble.normalise(DataSets.fileNames[i])) {
                    System.out.println("Standardising " + DataSets.fileNames[i]);
                    NormalizeCase nc = new NormalizeCase();
                    train = nc.process(train);
                    test = nc.process(test);
                }
                if (tableName.equals("SingleClassifiers")) {
                    sc = Bagnall12ensemble.setSingleClassifiers(names);
                } else if (tableName.equals("NN_EuclidClassifiers")) {
                    sc = Bagnall12ensemble.setNNClassifiers(names);
                }
                int folds = Bagnall12ensemble.setNosFolds(test, train);
                of.writeString("\n" + DataSets.fileNames[i] + "," + folds + ",");
                System.out.println("Train size = " + train.numInstances() + " Test size =" + test.numInstances() + " folds =" + folds);
                System.out.println(DataSets.fileNames[i]);
                System.out.println("************************************");
                ClassifierTools.ResultsStats[] stats = ClassifierTools.evalClassifiers(test, train, folds, sc);
                for (int j = 0; j < stats.length; ++j) {
                    of.writeString(stats[j].accuracy + ",");
                    System.out.println("\t" + names.get(j) + " error =" + (1.0 - stats[j].accuracy));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception = " + e);
            e.printStackTrace();
        }
    }

    public static void basicDataTransforms(String baseClassifier) {
        DecimalFormat dc = new DecimalFormat("###.###");
        OutFile of = new OutFile(resultPath + baseClassifier + "BasicDataTransforms.csv");
        System.out.println("NEAREST NEIGHBOUR CLASSIFIERS");
        of.writeLine("NEAREST NEIGHBOUR CLASSIFIERS, 10 fold cross validation results");
        of.writeLine(",TimeDomain,PowerSpectrumDomain,ACFDomain,PCADomain");
        of.writeLine(",1-NN");
        String[] files = DataSets.fileNames;
        AbstractClassifier base = null;
        if (baseClassifier.equals("1NN")) {
            base = new kNN(1);
        } else if (baseClassifier.equals("DTW")) {
            base = new FastDTW_1NN();
        } else if (baseClassifier.equals("RotationForest")) {
            base = new RotationForest();
        } else if (baseClassifier.equals("RandomForest")) {
            base = new RandomForest();
            ((RandomForest)base).setNumTrees(30);
        } else {
            System.out.println("Classifier Not Included, exiting");
            System.exit(0);
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                int j;
                Instances timeTest;
                Instances timeTrain;
                Instances test = ClassifierTools.loadData(DataSets.dropboxPath + files[i] + "\\" + files[i] + "_TEST");
                Instances train = ClassifierTools.loadData(DataSets.dropboxPath + files[i] + "\\" + files[i] + "_TRAIN");
                of.writeString("\n" + DataSets.fileNames[i] + ",");
                System.out.println("\n" + DataSets.fileNames[i] + ",");
                int folds = Bagnall12ensemble.setNosFolds(test, train);
                Classifier[] sc = new Classifier[1];
                if (Bagnall12ensemble.normalise(DataSets.fileNames[i])) {
                    System.out.println("Standardising " + DataSets.fileNames[i]);
                    NormalizeCase nc = new NormalizeCase();
                    timeTrain = new Instances(train);
                    timeTest = new Instances(test);
                    nc.process(timeTrain);
                    nc.process(timeTest);
                } else {
                    timeTrain = train;
                    timeTest = test;
                }
                System.out.println("******************Time Domain******************");
                sc[0] = AbstractClassifier.makeCopy(base);
                ClassifierTools.ResultsStats[] stats = ClassifierTools.evalClassifiers(timeTest, timeTrain, folds, sc);
                for (int j2 = 0; j2 < stats.length; ++j2) {
                    of.writeString(stats[j2].accuracy + ",");
                    System.out.print("\n \t TIME: " + dc.format(stats[j2].accuracy) + ",");
                }
                System.out.println("******************Power Spectrum Domain******************");
                PowerSpectrum ps = new PowerSpectrum();
                Instances psTrain = ps.process(train);
                Instances psTest = ps.process(test);
                psTrain.deleteAttributeAt(0);
                psTest.deleteAttributeAt(0);
                int atts = (psTrain.numAttributes() - 1) / 2 - 2;
                for (j = 0; j < atts; ++j) {
                    psTrain.deleteAttributeAt(psTrain.numAttributes() - 2);
                    psTest.deleteAttributeAt(psTest.numAttributes() - 2);
                }
                sc[0] = AbstractClassifier.makeCopy(base);
                stats = ClassifierTools.evalClassifiers(psTest, psTrain, folds, sc);
                for (j = 0; j < stats.length; ++j) {
                    of.writeString(stats[j].accuracy + ",");
                    System.out.print("\n\t SPECTRUM: " + dc.format(stats[j].accuracy) + ",");
                }
                System.out.println("\n******************ACF Domain******************");
                ACF acf = new ACF();
                acf.setMaxLag(train.numAttributes() - (int)((double)train.numAttributes() * 0.1));
                sc[0] = AbstractClassifier.makeCopy(base);
                Instances acfTrain = acf.process(train);
                Instances acfTest = acf.process(test);
                stats = ClassifierTools.evalClassifiers(acfTest, acfTrain, folds, sc);
                for (int j3 = 0; j3 < stats.length; ++j3) {
                    of.writeString(stats[j3].accuracy + ",");
                    System.out.print("\n\t ACF: " + dc.format(stats[j3].accuracy) + ",");
                }
                System.out.println("\n******************PCA Domain******************");
                PrincipalComponents pca = new PrincipalComponents();
                sc[0] = AbstractClassifier.makeCopy(base);
                pca.buildEvaluator(train);
                Instances pcaTrain = pca.transformedData(train);
                Instances pcaTest = pca.transformedData(test);
                stats = ClassifierTools.evalClassifiers(pcaTest, pcaTrain, folds, sc);
                for (int j4 = 0; j4 < stats.length; ++j4) {
                    of.writeString(stats[j4].accuracy + ",");
                    System.out.print("\n\t Pca: " + dc.format(stats[j4].accuracy) + ",");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception =" + e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void ensembleTransforms(String baseClassifier) {
        PolyKernel kernel;
        DecimalFormat dc = new DecimalFormat("###.###");
        OutFile of = new OutFile(resultPath + baseClassifier + "EnsembleTransforms.csv");
        OutFile of2 = new OutFile(resultPath + baseClassifier + "EnsembleWeights.csv");
        System.out.println("ENSEMBLECLASSIFIERS");
        of.writeLine(baseClassifier + ",CombinedEqual,CombinedBest,CombinedWeighted,CombinedStep");
        String[] files = DataSets.fileNames;
        AbstractClassifier base = null;
        if (baseClassifier.equals("1NN")) {
            base = new kNN(1);
        } else if (baseClassifier.equals("DTW")) {
            base = new FastDTW_1NN();
        } else if (baseClassifier.equals("RotationForest")) {
            base = new RotationForest();
        } else if (baseClassifier.equals("RandomForest")) {
            base = new RandomForest();
            ((RandomForest)base).setNumTrees(30);
        } else if (baseClassifier.equals("C4.5")) {
            base = new J48();
        } else if (baseClassifier.equals("NB")) {
            base = new NaiveBayes();
        } else if (baseClassifier.equals("SVMO")) {
            base = new SMO();
            kernel = new PolyKernel();
            kernel.setExponent(2.0);
            ((SMO)base).setKernel(kernel);
        } else if (baseClassifier.equals("SVML")) {
            base = new SMO();
            kernel = new PolyKernel();
            kernel.setExponent(1.0);
            ((SMO)base).setKernel(kernel);
        } else {
            System.out.println("Classifier Not Included, exiting");
            System.exit(0);
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                int j;
                Instances timeTest;
                Instances timeTrain;
                Instances test = ClassifierTools.loadData(DataSets.dropboxPath + files[i] + "\\" + files[i] + "_TEST");
                Instances train = ClassifierTools.loadData(DataSets.dropboxPath + files[i] + "\\" + files[i] + "_TRAIN");
                of.writeString("\n" + DataSets.fileNames[i] + ",");
                System.out.println("\n" + DataSets.fileNames[i] + ",");
                int folds = Bagnall12ensemble.setNosFolds(test, train);
                Classifier[] sc = new Classifier[1];
                if (Bagnall12ensemble.normalise(DataSets.fileNames[i])) {
                    System.out.println("Standardising " + DataSets.fileNames[i]);
                    NormalizeCase nc = new NormalizeCase();
                    timeTrain = new Instances(train);
                    timeTest = new Instances(test);
                    nc.process(timeTrain);
                    nc.process(timeTest);
                } else {
                    timeTrain = train;
                    timeTest = test;
                }
                sc[0] = new TransformEnsembles();
                System.out.println("\n******************Combined Equal******************");
                ((TransformEnsembles)sc[0]).setBaseClassifier(AbstractClassifier.makeCopy(base));
                ((TransformEnsembles)sc[0]).setWeightType(TransformEnsembles.WeightType.EQUAL);
                ClassifierTools.ResultsStats[] stats = ClassifierTools.evalClassifiers(test, train, folds, sc);
                for (j = 0; j < stats.length; ++j) {
                    of.writeString(stats[j].accuracy + ",");
                    System.out.print("\n\t ENSEMBLE_EQUAL: " + dc.format(stats[j].accuracy) + ",");
                }
                System.out.println("\n******************Combined Best******************");
                ((TransformEnsembles)sc[0]).setBaseClassifier(AbstractClassifier.makeCopy(base));
                ((TransformEnsembles)sc[0]).setWeightType(TransformEnsembles.WeightType.BEST);
                ((TransformEnsembles)sc[0]).rebuildClassifier(false);
                ((TransformEnsembles)sc[0]).findWeights();
                stats = ClassifierTools.evalClassifiers(test, train, folds, sc);
                for (j = 0; j < stats.length; ++j) {
                    of.writeString(stats[j].accuracy + ",");
                    System.out.print("\n\t ENSEMBLE_BEST: " + dc.format(stats[j].accuracy) + ",");
                }
                System.out.println("\n******************Combined Weighted******************");
                ((TransformEnsembles)sc[0]).setBaseClassifier(AbstractClassifier.makeCopy(base));
                ((TransformEnsembles)sc[0]).setWeightType(TransformEnsembles.WeightType.CV);
                ((TransformEnsembles)sc[0]).rebuildClassifier(false);
                ((TransformEnsembles)sc[0]).findWeights();
                stats = ClassifierTools.evalClassifiers(test, train, folds, sc);
                for (j = 0; j < stats.length; ++j) {
                    of.writeString(stats[j].accuracy + ",");
                    System.out.print("\n\t ENSEMBLE_WEIGHT: " + dc.format(stats[j].accuracy) + ",");
                }
                System.out.println("\n******************Combined STEP******************");
                ((TransformEnsembles)sc[0]).setBaseClassifier(AbstractClassifier.makeCopy(base));
                ((TransformEnsembles)sc[0]).setWeightType(TransformEnsembles.WeightType.STEP);
                ((TransformEnsembles)sc[0]).rebuildClassifier(false);
                ((TransformEnsembles)sc[0]).findWeights();
                stats = ClassifierTools.evalClassifiers(test, train, folds, sc);
                for (j = 0; j < stats.length; ++j) {
                    of.writeString(stats[j].accuracy + ",");
                    System.out.print("\n\t ENSEMBLE_WEIGHT: " + dc.format(stats[j].accuracy) + ",");
                }
                String w = ((TransformEnsembles)sc[0]).getWeights();
                String w2 = ((TransformEnsembles)sc[0]).getCV();
                of2.writeLine(DataSets.fileNames[i] + "," + w + "," + w2);
            }
        }
        catch (Exception e) {
            System.out.println("Exception =" + e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void formatRankTable(String str, String dest) {
        int i;
        int j;
        int i2;
        InFile in = new InFile(str + "Acc.csv");
        InFile in2 = new InFile(str + "Rank.csv");
        int lines = in.countLines();
        in = new InFile(str + "Acc.csv");
        String names = in.readLine();
        in2.readLine();
        String[] classifiers = names.split(",");
        int nosClassifiers = classifiers.length - 1;
        System.out.println("FILE PATH =" + str);
        System.out.println("nos problems =" + --lines + " nos classifiers=" + nosClassifiers);
        String[] problems = new String[lines];
        double[][] acc = new double[lines][nosClassifiers];
        double[][] ranks = new double[lines][nosClassifiers];
        for (int i3 = 0; i3 < lines; ++i3) {
            problems[i3] = in.readString();
            System.out.print("Problem =" + problems[i3]);
            in2.readString();
            for (int j2 = 0; j2 < nosClassifiers; ++j2) {
                acc[i3][j2] = in.readDouble();
                ranks[i3][j2] = in2.readDouble();
                System.out.print(" " + classifiers[j2] + " " + acc[i3][j2] + " (" + ranks[i3][j2] + ")");
            }
            System.out.print(" \n");
        }
        OutFile of = new OutFile(dest);
        of.writeLine("\\begin{table*}[!ht]\n  \\scriptsize \n \\begin{tabular}{");
        for (i2 = 0; i2 < nosClassifiers; ++i2) {
            of.writeString("c|");
        }
        of.writeLine("c} \\hline \n Data Set\t&");
        for (i2 = 0; i2 < nosClassifiers - 1; ++i2) {
            of.writeString(classifiers[i2 + 1] + "\t&");
        }
        of.writeLine(classifiers[nosClassifiers] + "\\\\ \\hline");
        DecimalFormat df = new DecimalFormat("##.####");
        for (int i4 = 0; i4 < problems.length; ++i4) {
            of.writeString(problems[i4] + "\t & ");
            for (int j3 = 0; j3 < nosClassifiers; ++j3) {
                if (ranks[i4][j3] < 2.0) {
                    of.writeString("{\\bf ");
                }
                of.writeString(df.format(1.0 - acc[i4][j3]));
                if (ranks[i4][j3] * 10.0 == (double)((int)ranks[i4][j3] * 10)) {
                    of.writeString("(" + (int)ranks[i4][j3] + ")");
                } else {
                    of.writeString("(" + ranks[i4][j3] + ")");
                }
                if (ranks[i4][j3] < 2.0) {
                    of.writeString("}");
                }
                if (j3 == nosClassifiers - 1) {
                    if (i4 < problems.length - 1) {
                        of.writeString("\\\\ \n");
                        continue;
                    }
                    of.writeString("\\\\ \\hline \n");
                    continue;
                }
                of.writeString("\t & ");
            }
        }
        of.writeString("Mean Rank \t & ");
        double[] meanRanks = new double[nosClassifiers];
        double rSS = 0.0;
        for (int i5 = 0; i5 < problems.length; ++i5) {
            for (int j4 = 0; j4 < nosClassifiers; ++j4) {
                int n = j4;
                meanRanks[n] = meanRanks[n] + ranks[i5][j4];
            }
        }
        for (int j5 = 0; j5 < nosClassifiers; ++j5) {
            int n = j5;
            meanRanks[n] = meanRanks[n] / (double)problems.length;
            rSS += meanRanks[j5] * meanRanks[j5];
            if (j5 < nosClassifiers - 1) {
                of.writeString(df.format(meanRanks[j5]) + " \t & ");
                continue;
            }
            of.writeString(df.format(meanRanks[j5]) + " \\\\ \\hline ");
        }
        double n = problems.length;
        double k = nosClassifiers;
        double Q = 12.0 * n / (k * (k + 1.0));
        double F = (n - 1.0) * (Q *= rSS - k * (k + 1.0) * (k + 1.0) / 4.0);
        F /= n * (k - 1.0) - Q;
        double[] zStat = new double[nosClassifiers];
        for (j = 1; j < nosClassifiers; ++j) {
            zStat[j] = (meanRanks[0] - meanRanks[j]) / Math.sqrt(k * (k + 1.0) / (6.0 * n));
        }
        of.writeString("\n &");
        for (j = 0; j < nosClassifiers; ++j) {
            if (j < nosClassifiers - 1) {
                of.writeString(df.format(zStat[j]) + " \t & ");
                continue;
            }
            of.writeString(df.format(zStat[j]) + " \\\\ \\hline ");
        }
        of.writeString("\n");
        of.writeLine("\\end{tabular} \n \\caption{Statistics: Q Stat=" + df.format(Q) + " F Stat=" + df.format(F) + "  CD=     }\n \\label{}\n \\end{table*}");
        OutFile o2 = new OutFile(str + "Error.csv");
        OutFile o3 = new OutFile(str + "Names.csv");
        o3.writeString("{");
        for (i = 1; i < classifiers.length; ++i) {
            o3.writeString("'" + classifiers[i] + "' ");
        }
        o3.writeString("}");
        for (i = 0; i < problems.length; ++i) {
            for (int j6 = 0; j6 < nosClassifiers; ++j6) {
                if (j6 < nosClassifiers - 1) {
                    o2.writeString(df.format(1.0 - acc[i][j6]) + ",");
                    continue;
                }
                o2.writeString(df.format(1.0 - acc[i][j6]) + "\n");
            }
        }
    }

    public static void summariseData(String path) {
        OutFile of = new OutFile(path);
        try {
            for (int i = 0; i < DataSets.fileNames.length; ++i) {
                int j;
                Instances test = ClassifierTools.loadData(DataSets.dropboxPath + DataSets.fileNames[i] + "\\" + DataSets.fileNames[i] + "_TEST");
                Instances train = ClassifierTools.loadData(DataSets.dropboxPath + DataSets.fileNames[i] + "\\" + DataSets.fileNames[i] + "_TRAIN");
                of.writeString(DataSets.fileNames[i] + "," + train.numInstances() + "," + test.numInstances());
                of.writeString("," + (train.numAttributes() - 1) + "," + train.numClasses());
                double[] classDist = new double[train.numClasses()];
                for (j = 0; j < train.numInstances(); ++j) {
                    int n = (int)train.instance(j).classValue();
                    classDist[n] = classDist[n] + 1.0;
                }
                for (j = 0; j < train.numClasses(); ++j) {
                    of.writeString("," + classDist[j] / (double)train.numInstances());
                }
                of.writeString(",,");
                classDist = new double[test.numClasses()];
                for (j = 0; j < test.numInstances(); ++j) {
                    int n = (int)test.instance(j).classValue();
                    classDist[n] = classDist[n] + 1.0;
                }
                for (j = 0; j < test.numClasses(); ++j) {
                    of.writeString("," + classDist[j] / (double)test.numInstances());
                }
                of.writeString("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Bagnall12ensemble.ensembleTransforms("1NN");
    }

    public static void table4_My_Ensembles() {
        OutFile of = new OutFile(resultPath + "NewEnsemblesComparison.csv");
        int seed = 100;
        System.out.println("Ensemble on several transformations");
        try {
            for (int i = 0; i < DataSets.fileNames.length; ++i) {
                Instances test = ClassifierTools.loadData(DataSets.dropboxPath + DataSets.fileNames[i] + "\\" + DataSets.fileNames[i] + "_TEST");
                Instances train = ClassifierTools.loadData(DataSets.dropboxPath + DataSets.fileNames[i] + "\\" + DataSets.fileNames[i] + "_TRAIN");
                of.writeString("\n" + DataSets.fileNames[i] + ",");
                System.out.println(DataSets.fileNames[i] + ",");
                int folds = Bagnall12ensemble.setNosFolds(test, train);
                TransformEnsembles te = new TransformEnsembles();
                double testAccuracy = 0.0;
                if (folds > 1) {
                    Instances full = new Instances(train);
                    for (int j = 0; j < test.numInstances(); ++j) {
                        full.add(test.instance(j));
                    }
                    Random rand = new Random(seed);
                    full.randomize(rand);
                    double[][] preds = ClassifierTools.crossValidation(te, full, folds);
                    testAccuracy = preds[0][0];
                } else {
                    te.buildClassifier(train);
                    testAccuracy = ClassifierTools.accuracy(test, te);
                }
                System.out.println("\t : " + testAccuracy);
                of.writeString(testAccuracy + ",");
            }
        }
        catch (Exception e) {
            System.out.println("Exception = " + e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static boolean tooLarge(String name) {
        return name.equals("FordA") || name.equals("FordB") || name.equals("HandOutlines") || name.equals("ElectricDevices") || name.equals("ARSim") || name.equals("Earthquakes");
    }

    public static Instances sample(Instances data, double prop) {
        if (prop < 0.0 || prop > 1.0) {
            return null;
        }
        Instances newD = new Instances(data);
        newD.randomize(new Random());
        int size = (int)(prop * (double)newD.numInstances());
        for (int i = size + 1; i < data.numInstances(); ++i) {
            newD.delete(size);
        }
        return newD;
    }

    public static int setNosFolds(Instances test, Instances train) {
        int folds = 1;
        if (folds > 100) {
            if (folds > 1000) {
                folds = 1;
            } else if (folds > 500) {
                folds = 10;
            }
        }
        return folds;
    }
}

