/*
 * Decompiled with CFR 0.152.
 */
package development;

import development.DataSets;
import development.MatrixProfileExperiments;
import development.SimulationExperiments;
import fileIO.OutFile;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import vector_classifiers.HESCA;
import vector_classifiers.RotationForestLimitedAttributes;
import weka.classifiers.Classifier;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;

public class HESCADevelopment {
    public static void testReadWrite() {
        Instances train = ClassifierTools.loadData("c:/tsc problems/ItalyPowerDemand/ItalyPowerDemand_TRAIN");
        Instances test = ClassifierTools.loadData("c:/tsc problems/ItalyPowerDemand/ItalyPowerDemand_TEST");
        HESCA h = new HESCA();
        h.setRandSeed(0);
        h.setDebug(true);
        h.setResultsFileLocationParameters(DataSets.resultsPath, "ItalyPowerDemand", 0);
        h.setBuildIndividualsFromResultsFiles(true);
    }

    public static void timingExperimentInTrainSize() throws Exception {
        OutFile out = new OutFile("C:\\Users\\ajb\\Dropbox\\Results\\SimulationExperiments\\HESCATest\\HescaBasicTimingTrainSizeV123.csv");
        HESCA hesca = new HESCA();
        Classifier[] classifierNames = hesca.getClassifiers();
        for (int c = 0; c < classifierNames.length; ++c) {
            out.writeString("," + classifierNames[c].getClass().getName());
        }
        out.writeString(", HESCA\n");
        MatrixProfileExperiments.seriesLength = 100;
        for (int s = 250; s <= 5000; s += 250) {
            MatrixProfileExperiments.casesPerClass = new int[]{s / 2, s / 2};
            MatrixProfileExperiments.trainProp = 0.2;
            Instances d = SimulationExperiments.simulateData("Interval", 0);
            out.writeString("\n" + s + ",");
            System.out.println(" s =" + s + "   ");
            hesca = new HESCA();
            long start = System.nanoTime();
            hesca.buildClassifier(d);
            long end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println(hesca.getClass().getName() + "::" + (double)(end - start) / 1.0E9 + "  ");
            hesca = new HESCA();
            start = System.nanoTime();
            hesca.buildClassifier(d);
            end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println(hesca.getClass().getName() + "::" + (double)(end - start) / 1.0E9 + "  ");
            hesca = new HESCA();
            start = System.nanoTime();
            hesca.buildClassifier(d);
            end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println(hesca.getClass().getName() + "::" + (double)(end - start) / 1.0E9 + "  ");
        }
    }

    public static void timingExperimentInSeriesLength() throws Exception {
        OutFile out = new OutFile("C:\\Users\\ajb\\Dropbox\\Results\\SimulationExperiments\\HESCATest\\HescaBasicTimingSeriesLengthV123.csv");
        HESCA hesca = new HESCA();
        Classifier[] classifierNames = hesca.getClassifiers();
        for (int c = 0; c < classifierNames.length; ++c) {
            out.writeString("," + classifierNames[c].getClass().getName());
        }
        out.writeString(", HESCA\n");
        for (int s = 100; s <= 1000; s += 100) {
            MatrixProfileExperiments.seriesLength = s;
            Instances d = SimulationExperiments.simulateData("Interval", 0);
            out.writeString("\n" + s + ",");
            System.out.println(" s =" + s + "   ");
            hesca = new HESCA();
            long start = System.nanoTime();
            hesca.buildClassifier(d);
            long end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println(hesca.getClass().getName() + "::" + (double)(end - start) / 1.0E9 + "  ");
            hesca = new HESCA();
            start = System.nanoTime();
            hesca.buildClassifier(d);
            end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println(hesca.getClass().getName() + "::" + (double)(end - start) / 1.0E9 + "  ");
            hesca = new HESCA();
            start = System.nanoTime();
            hesca.buildClassifier(d);
            end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println(hesca.getClass().getName() + "::" + (double)(end - start) / 1.0E9 + "  ");
        }
    }

    public static void randomForestTimes() throws Exception {
        OutFile out = new OutFile("C:/Temp/randomForest.csv");
        HESCA hesca = new HESCA();
        out.writeString(", CV,OOB\n");
        for (int s = 100; s <= 1000; s += 100) {
            MatrixProfileExperiments.seriesLength = s;
            Instances d = SimulationExperiments.simulateData("Interval", 0);
            out.writeString("\n" + s + ",");
            System.out.println(" s =" + s + "   ");
            RandomForest rf = new RandomForest();
            rf.setNumTrees(500);
            long start = System.nanoTime();
            rf.buildClassifier(d);
            long end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println(" RandF CV time  =" + (double)(end - start) / 1.0E9);
            rf = new RandomForest();
            rf.setNumTrees(500);
            start = System.nanoTime();
            rf.buildClassifier(d);
            double oob = 1.0 - rf.measureOutOfBagError();
            end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println("Rand F oob time " + (double)(end - start) / 1.0E9 + "  ");
            hesca = new HESCA();
            start = System.nanoTime();
            hesca.buildClassifier(d);
            end = System.nanoTime();
            out.writeString("," + (end - start));
            System.out.println("  hesca time " + (double)(end - start) / 1.0E9 + "  ");
        }
    }

    public static void rotationForestTimesForL() throws Exception {
        OutFile out = new OutFile("C:/Temp/EnhancedRotFTest.csv");
        RotationForest[] rotf = new RotationForest[2];
        RotationForestLimitedAttributes[] rotf2 = new RotationForestLimitedAttributes[5];
        for (int i = 0; i < rotf.length; ++i) {
            rotf[i] = new RotationForest();
            rotf[i].setNumIterations(10 + i * 40);
            rotf2[i] = new RotationForestLimitedAttributes();
            rotf2[i].setNumIterations(10 + i * 40);
        }
        out.writeString(", 10,20,30,40,50\n");
        for (int s = 1000; s <= 3000; s += 200) {
            long end;
            double acc;
            long start;
            MatrixProfileExperiments.seriesLength = s;
            Instances d = SimulationExperiments.simulateData("Interval", 0);
            Instances[] split = InstanceTools.resampleInstances(d, 0L, 0.2);
            out.writeString("\n" + s + ",");
            System.out.println(" s =" + s + "   ");
            for (RotationForest rotationForest : rotf) {
                start = System.nanoTime();
                acc = ClassifierTools.singleTrainTestSplitAccuracy(rotationForest, split[0], split[1]);
                end = System.nanoTime();
                out.writeString("," + (end - start) + "," + acc);
                System.out.println(" RandF time  =" + (double)(end - start) / 1.0E9 + " acc= " + acc);
            }
            out.writeString(",");
            for (RotationForest rotationForest : rotf2) {
                start = System.nanoTime();
                acc = ClassifierTools.singleTrainTestSplitAccuracy(rotationForest, split[0], split[1]);
                end = System.nanoTime();
                out.writeString("," + (end - start) + "," + acc);
                System.out.println(" RotF ENHANCED time  =" + (double)(end - start) / 1.0E9 + " acc= " + acc);
            }
        }
    }

    public static void rotationForestTimesForNosGroups() throws Exception {
        long end;
        double acc;
        long start;
        Instances[] split;
        Instances d;
        int s;
        OutFile out = new OutFile("C:/Temp/rotForestNumGroupsSeriesLength.csv");
        RotationForest[] rotf = new RotationForest[5];
        for (int i = 0; i < rotf.length; ++i) {
            rotf[i] = new RotationForest();
            rotf[i].setNumIterations(10 + i * 10);
        }
        out.writeString(", 10,20,30,40,50\n");
        for (s = 100; s <= 1000; s += 100) {
            MatrixProfileExperiments.seriesLength = s;
            d = SimulationExperiments.simulateData("Interval", 0);
            split = InstanceTools.resampleInstances(d, 0L, 0.5);
            out.writeString("\n" + s + ",");
            System.out.println(" s =" + s + "   ");
            for (RotationForest rf : rotf) {
                start = System.nanoTime();
                acc = ClassifierTools.singleTrainTestSplitAccuracy(rf, split[0], split[1]);
                end = System.nanoTime();
                out.writeString("," + (end - start) + "," + acc);
                System.out.println(" RandF time  =" + (double)(end - start) / 1.0E9 + " acc= " + acc);
            }
            out.writeString("\n");
        }
        out = new OutFile("C:/Temp/rotForestNumTreesNumCases.csv");
        out.writeString(", 10,20,30,40,50\n");
        MatrixProfileExperiments.seriesLength = 100;
        for (s = 250; s <= 2500; s += 250) {
            MatrixProfileExperiments.casesPerClass = new int[]{s / 2, s / 2};
            MatrixProfileExperiments.trainProp = 0.2;
            d = SimulationExperiments.simulateData("Interval", 0);
            split = InstanceTools.resampleInstances(d, 0L, 0.5);
            out.writeString("\n" + s + ",");
            System.out.println(" s =" + s + "   ");
            for (RotationForest rf : rotf) {
                start = System.nanoTime();
                acc = ClassifierTools.singleTrainTestSplitAccuracy(rf, split[0], split[1]);
                end = System.nanoTime();
                out.writeString("," + (end - start) + "," + acc);
                System.out.println(" RandF time  =" + (double)(end - start) / 1.0E9 + " acc= " + acc);
            }
            out.writeString("\n");
        }
    }

    public static void main(String[] args) throws Exception {
        HESCADevelopment.rotationForestTimesForL();
    }
}

