/*
 * Decompiled with CFR 0.152.
 */
package ResultsProcessing;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class ProcessResult {
    File directory;
    String outputPath;

    public ProcessResult(File dir, String output) {
        this.directory = dir;
        this.outputPath = output;
    }

    public void processResults(String removeFromFileName) throws FileNotFoundException, IOException {
        FileWriter out = new FileWriter(this.directory.getParentFile().getAbsoluteFile() + File.separator + this.outputPath);
        for (File file : this.directory.listFiles()) {
            if (!file.getName().contains(removeFromFileName)) continue;
            try {
                Stream<String> str = Files.lines(Paths.get(file.getAbsolutePath(), new String[0]));
                out.write(file.getName().replaceAll(removeFromFileName, ""));
                Iterator it = str.iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    out.write("," + s);
                }
                out.write("\n");
            }
            catch (IOException ex) {
                Logger.getLogger(ProcessResult.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ((Writer)out).close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        ProcessResult pr = new ProcessResult(new File("..\\..\\RandomSearch\\hour"), "hour_random_search.csv");
        pr.processResults("_random_hour.csv");
        pr = new ProcessResult(new File("..\\..\\RandomSearch\\day"), "day_random_search.csv");
        pr.processResults("_random_day.csv");
    }
}

