/*
 * Decompiled with CFR 0.152.
 */
package weka.core.spectral_distance_functions;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.PerformanceStats;

public class LikelihoodRatioDistance
extends EuclideanDistance {
    private static final long serialVersionUID = 1L;

    public LikelihoodRatioDistance() {
    }

    public LikelihoodRatioDistance(Instances data) {
        super(data);
    }

    @Override
    public double distance(Instance first, Instance second) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, null, false);
    }

    @Override
    public double distance(Instance first, Instance second, PerformanceStats stats) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, stats, false);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue, stats, false);
    }

    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats, boolean print) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] s;
        int sClass;
        double[] f;
        int fClass = first.classIndex();
        if (fClass >= 0) {
            f = new double[first.numAttributes() - 1];
            int count = 0;
            for (int i = 0; i < f.length + 1; ++i) {
                if (i == fClass) continue;
                f[count] = first.value(i);
                ++count;
            }
        } else {
            f = first.toDoubleArray();
        }
        if ((sClass = second.classIndex()) >= 0) {
            s = new double[second.numAttributes() - 1];
            int count = 0;
            for (int i = 0; i < s.length; ++i) {
                if (i == sClass) continue;
                s[count] = second.value(i);
                ++count;
            }
        } else {
            s = second.toDoubleArray();
        }
        if (f.length != s.length) {
            System.out.println("Error in distance calculation for Likelihhod ratio, unequal lengths, exiting program!");
            System.exit(0);
        }
        return this.distance(f, s, cutOffValue);
    }

    public double distance(double[] a, double[] b, double cutoff) {
        int i;
        double dist = 0.0;
        double n1 = a[0];
        for (i = 1; i < a.length; ++i) {
            n1 += a[i];
        }
        double n2 = b[0];
        for (i = 1; i < b.length; ++i) {
            n2 += b[i];
        }
        double n = n1 + n2;
        for (i = 0; i < a.length; ++i) {
            if (a[i] > 0.0) {
                dist += a[i] / n1 * Math.log(a[i] / n1 / ((a[i] + b[i]) / n));
            }
            if (b[i] > 0.0) {
                dist += b[i] / n2 * Math.log(b[i] / n2 / ((a[i] + b[i]) / n));
            }
            if (!(dist > cutoff)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return dist;
    }

    @Override
    public String toString() {
        return "Likelihood Ratio";
    }

    @Override
    public String globalInfo() {
        return "Likelihood Ratio";
    }

    @Override
    protected double updateDistance(double currDist, double diff) {
        return 0.0;
    }

    @Override
    public String getRevision() {
        return null;
    }
}

