/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.PerformanceStats;

public class GowerDistance
extends EuclideanDistance {
    private static final long serialVersionUID = 1L;
    double[] ranges;

    private GowerDistance() {
    }

    public GowerDistance(Instances data) {
        super(data);
        this.ranges = this.findRanges(data);
    }

    double[] findRanges(Instances d) {
        int classIndex = d.classIndex();
        double[] r = classIndex > 0 ? new double[d.numAttributes() - 1] : new double[d.numAttributes()];
        int c = 0;
        for (int j = 0; j < d.numAttributes(); ++j) {
            double min;
            if (j == classIndex) continue;
            double max = min = d.instance(0).value(0);
            for (int i = 1; i < d.numInstances(); ++i) {
                double x = d.instance(i).value(j);
                if (x > max) {
                    max = x;
                }
                if (!(x < min)) continue;
                min = x;
            }
            r[c] = max - min;
            ++c;
        }
        return r;
    }

    @Override
    public double distance(Instance first, Instance second) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, null, false);
    }

    @Override
    public double distance(Instance first, Instance second, PerformanceStats stats) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, stats, false);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue, stats, false);
    }

    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats, boolean print) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] f2;
        double[] f1;
        int classIndex = first.classIndex();
        if (classIndex >= 0) {
            f1 = new double[first.numAttributes() - 1];
            f2 = new double[second.numAttributes() - 1];
            int c = 0;
            for (int i = 0; i < first.numAttributes(); ++i) {
                if (i == classIndex) continue;
                f1[c] = first.value(i);
                f2[c] = second.value(i);
                ++c;
            }
        } else {
            f1 = new double[first.numAttributes()];
            f2 = new double[second.numAttributes()];
            for (int i = 0; i < first.numAttributes(); ++i) {
                f1[i] = first.value(i);
                f2[i] = second.value(i);
            }
        }
        return this.distance(f1, f2, cutOffValue);
    }

    public double distance(double[] a, double[] b, double cutoff) {
        if (this.ranges == null) {
            System.out.println("Error in Gower distance, ranges not calculated, exiting but should throw an exception!");
            System.exit(0);
        }
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dist += Math.abs(a[i] - b[i]) / this.ranges[i];
        }
        return dist;
    }
}

