/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializationHelper;
import weka.core.Tag;
import weka.core.Utils;

public class Debug
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 66171861743328020L;
    public static final Level ALL = Level.ALL;
    public static final Level CONFIG = Level.CONFIG;
    public static final Level FINE = Level.FINE;
    public static final Level FINER = Level.FINER;
    public static final Level FINEST = Level.FINEST;
    public static final Level INFO = Level.INFO;
    public static final Level OFF = Level.OFF;
    public static final Level SEVERE = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    protected boolean m_Enabled = true;
    protected Log m_Log;
    protected Clock m_Clock = new Clock();

    public Debug() {
        this(null);
    }

    public Debug(String filename) {
        this(filename, 1000000, 1);
    }

    public Debug(String filename, int size, int numFiles) {
        this.m_Log = Debug.newLog(filename, size, numFiles);
    }

    public static Level stringToLevel(String level) {
        return Log.stringToLevel(level);
    }

    public static Log newLog(String filename, int size, int numFiles) {
        return new Log(filename, size, numFiles);
    }

    public void log(String message) {
        this.log(INFO, message);
    }

    public void log(Level level, String message) {
        this.log(level, "", message);
    }

    public void log(Level level, String sourceclass, String message) {
        this.log(level, sourceclass, "", message);
    }

    public void log(Level level, String sourceclass, String sourcemethod, String message) {
        if (this.getEnabled()) {
            this.m_Log.log(level, sourceclass, sourcemethod, message);
        }
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
    }

    public boolean getEnabled() {
        return this.m_Enabled;
    }

    public static Clock newClock() {
        return new Clock();
    }

    public Clock getClock() {
        return this.m_Clock;
    }

    public void startClock() {
        this.m_Clock.start();
    }

    public void stopClock(String message) {
        this.log(message + ": " + this.m_Clock);
    }

    public static java.util.Random newRandom() {
        return new Random(true);
    }

    public static java.util.Random newRandom(int seed) {
        return new Random(seed, true);
    }

    public static Timestamp newTimestamp() {
        return new Timestamp();
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getHomeDir() {
        return System.getProperty("user.home");
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static boolean writeToFile(String filename, Object obj) {
        return Debug.writeToFile(filename, obj, true);
    }

    public static boolean writeToFile(String filename, String message) {
        return Debug.writeToFile(filename, message, true);
    }

    public static boolean writeToFile(String filename, Object obj, boolean append) {
        return Debug.writeToFile(filename, obj.toString(), append);
    }

    public static boolean writeToFile(String filename, String message, boolean append) {
        boolean result;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename, append));
            writer.write(message);
            writer.newLine();
            writer.flush();
            writer.close();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean saveToFile(String filename, Object o) {
        boolean result;
        if (SerializationHelper.isSerializable(o.getClass())) {
            try {
                SerializationHelper.write(filename, o);
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static Object loadFromFile(String filename) {
        Object result;
        try {
            result = SerializationHelper.read(filename);
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static class DBO
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -5245628124742606784L;
        public boolean m_verboseOn = false;
        public Range m_outputTypes = new Range();

        public void setVerboseOn() {
            this.m_verboseOn = true;
        }

        public void initializeRanges(int upper) {
            this.m_outputTypes.setUpper(upper);
        }

        public boolean outputTypeSet(int num) {
            return this.m_outputTypes.isInRange(num);
        }

        public boolean dl(int num) {
            return this.outputTypeSet(num);
        }

        public void setOutputTypes(String list) {
            if (list.length() > 0) {
                this.m_verboseOn = true;
                this.m_outputTypes.setRanges(list);
                this.m_outputTypes.setUpper(30);
            }
        }

        public String getOutputTypes() {
            return this.m_outputTypes.getRanges();
        }

        public void dpln(String text) {
            if (this.m_verboseOn) {
                System.out.println(text);
            }
        }

        public void dpln(int debugType, String text) {
            if (this.outputTypeSet(debugType)) {
                System.out.println(text);
            }
        }

        public void dp(String text) {
            if (this.m_verboseOn) {
                System.out.print(text);
            }
        }

        public void dp(int debugType, String text) {
            if (this.outputTypeSet(debugType)) {
                System.out.print(text);
            }
        }

        public static void pln(String text) {
            System.out.println(text);
        }

        public static void p(String text) {
            System.out.print(text);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    public static class Random
    extends java.util.Random
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 1256846887618333956L;
        protected boolean m_Debug = false;
        protected long m_ID;
        protected static long m_CurrentID;
        protected Log m_Log = null;

        public Random() {
            this(false);
        }

        public Random(long seed) {
            this(seed, false);
        }

        public Random(boolean debug) {
            this.setDebug(debug);
            this.m_ID = Random.nextID();
            if (this.getDebug()) {
                this.printStackTrace();
            }
        }

        public Random(long seed, boolean debug) {
            super(seed);
            this.setDebug(debug);
            this.m_ID = Random.nextID();
            if (this.getDebug()) {
                this.printStackTrace();
            }
        }

        public void setDebug(boolean value) {
            this.m_Debug = value;
        }

        public boolean getDebug() {
            return this.m_Debug;
        }

        public void setLog(Log value) {
            this.m_Log = value;
        }

        public Log getLog() {
            return this.m_Log;
        }

        protected static long nextID() {
            return ++m_CurrentID;
        }

        public long getID() {
            return this.m_ID;
        }

        protected void println(String msg) {
            if (this.getDebug()) {
                if (this.getLog() != null) {
                    this.getLog().log(Level.INFO, this.m_ID + ": " + msg);
                } else {
                    System.out.println(this.m_ID + ": " + msg);
                }
            }
        }

        public void printStackTrace() {
            StringWriter writer = new StringWriter();
            Throwable t = new Throwable();
            t.fillInStackTrace();
            t.printStackTrace(new PrintWriter(writer));
            this.println(writer.toString());
        }

        @Override
        public boolean nextBoolean() {
            boolean result = super.nextBoolean();
            this.println("nextBoolean=" + result);
            return result;
        }

        @Override
        public void nextBytes(byte[] bytes) {
            super.nextBytes(bytes);
            this.println("nextBytes=" + Utils.arrayToString(bytes));
        }

        @Override
        public double nextDouble() {
            double result = super.nextDouble();
            this.println("nextDouble=" + result);
            return result;
        }

        @Override
        public float nextFloat() {
            float result = super.nextFloat();
            this.println("nextFloat=" + result);
            return result;
        }

        @Override
        public double nextGaussian() {
            double result = super.nextGaussian();
            this.println("nextGaussian=" + result);
            return result;
        }

        @Override
        public int nextInt() {
            int result = super.nextInt();
            this.println("nextInt=" + result);
            return result;
        }

        @Override
        public int nextInt(int n) {
            int result = super.nextInt(n);
            this.println("nextInt(" + n + ")=" + result);
            return result;
        }

        @Override
        public long nextLong() {
            long result = super.nextLong();
            this.println("nextLong=" + result);
            return result;
        }

        @Override
        public void setSeed(long seed) {
            super.setSeed(seed);
            this.println("setSeed(" + seed + ")");
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.getID();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    public static class Log
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 1458435732111675823L;
        protected transient Logger m_Logger = null;
        protected String m_Filename = null;
        protected int m_Size;
        protected int m_NumFiles;
        protected boolean m_LoggerInitFailed = false;

        public Log() {
            this(null);
        }

        public Log(String filename) {
            this(filename, 1000000, 1);
        }

        public Log(String filename, int size, int numFiles) {
            this.m_Filename = filename;
            this.m_Size = size;
            this.m_NumFiles = numFiles;
        }

        protected Logger getLogger() {
            if (this.m_Logger == null && !this.m_LoggerInitFailed && this.m_Filename != null) {
                this.m_Logger = Logger.getLogger(this.m_Filename);
                FileHandler fh = null;
                try {
                    fh = new FileHandler(this.m_Filename, this.m_Size, this.m_NumFiles);
                    fh.setFormatter(new SimpleFormatter());
                    this.m_Logger.addHandler(fh);
                    this.m_LoggerInitFailed = false;
                }
                catch (Exception e) {
                    System.out.println("Cannot init fileHandler for logger:" + e.toString());
                    this.m_Logger = null;
                    this.m_LoggerInitFailed = true;
                }
            }
            return this.m_Logger;
        }

        public static Level stringToLevel(String level) {
            Level result = level.equalsIgnoreCase("ALL") ? ALL : (level.equalsIgnoreCase("CONFIG") ? CONFIG : (level.equalsIgnoreCase("FINE") ? FINE : (level.equalsIgnoreCase("FINER") ? FINER : (level.equalsIgnoreCase("FINEST") ? FINEST : (level.equalsIgnoreCase("INFO") ? INFO : (level.equalsIgnoreCase("OFF") ? OFF : (level.equalsIgnoreCase("SEVERE") ? SEVERE : (level.equalsIgnoreCase("WARNING") ? WARNING : ALL))))))));
            return result;
        }

        public String getFilename() {
            return this.m_Filename;
        }

        public int getSize() {
            return this.m_Size;
        }

        public int getNumFiles() {
            return this.m_NumFiles;
        }

        public void log(Level level, String message) {
            this.log(level, "", message);
        }

        public void log(Level level, String sourceclass, String message) {
            this.log(level, sourceclass, "", message);
        }

        public void log(Level level, String sourceclass, String sourcemethod, String message) {
            Logger logger = this.getLogger();
            if (logger != null) {
                logger.logp(level, sourceclass, sourcemethod, message);
            } else {
                System.out.println(message);
            }
        }

        public void logSystemInfo() {
        }

        public String toString() {
            String result = "Filename: " + this.getFilename() + ", " + "Size: " + this.getSize() + ", " + "# Files: " + this.getNumFiles();
            return result;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    public static class SimpleLog
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -2671928223819510830L;
        protected String m_Filename = null;

        public SimpleLog() {
            this(null);
        }

        public SimpleLog(String filename) {
            this(filename, true);
        }

        public SimpleLog(String filename, boolean append) {
            this.m_Filename = filename;
            Debug.writeToFile(this.m_Filename, "--> Log started", append);
        }

        public String getFilename() {
            return this.m_Filename;
        }

        public void log(String message) {
            String log = new Timestamp() + " " + message;
            if (this.getFilename() != null) {
                Debug.writeToFile(this.getFilename(), log);
            }
            System.out.println(log);
        }

        public void logSystemInfo() {
        }

        public String toString() {
            String result = "Filename: " + this.getFilename();
            return result;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    public static class Timestamp
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -6099868388466922753L;
        public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
        protected Date m_Stamp;
        protected String m_Format;
        protected SimpleDateFormat m_Formatter;

        public Timestamp() {
            this(DEFAULT_FORMAT);
        }

        public Timestamp(String format) {
            this(new Date(), format);
        }

        public Timestamp(Date stamp) {
            this(stamp, DEFAULT_FORMAT);
        }

        public Timestamp(Date stamp, String format) {
            this.m_Stamp = stamp;
            this.setFormat(format);
        }

        public void setFormat(String value) {
            try {
                this.m_Formatter = new SimpleDateFormat(value);
                this.m_Format = value;
            }
            catch (Exception e) {
                this.m_Formatter = new SimpleDateFormat(DEFAULT_FORMAT);
                this.m_Format = DEFAULT_FORMAT;
            }
        }

        public String getFormat() {
            return this.m_Format;
        }

        public Date getStamp() {
            return this.m_Stamp;
        }

        public String toString() {
            return this.m_Formatter.format(this.getStamp());
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }

    public static class Clock
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 4622161807307942201L;
        public static final int FORMAT_MILLISECONDS = 0;
        public static final int FORMAT_SECONDS = 1;
        public static final int FORMAT_HHMMSS = 2;
        public static final Tag[] TAGS_FORMAT = new Tag[]{new Tag(0, "milli-seconds"), new Tag(1, "seconds"), new Tag(2, "hh:mm:ss")};
        public int m_OutputFormat = 1;
        protected long m_Start = 0L;
        protected long m_Stop = 0L;
        protected boolean m_Running = false;
        protected long m_ThreadID;
        protected boolean m_CanMeasureCpuTime;
        protected boolean m_UseCpuTime = true;
        protected transient ThreadMXBean m_ThreadMonitor;

        public Clock() {
            this(true);
        }

        public Clock(int format) {
            this(true, format);
        }

        public Clock(boolean start) {
            this(start, 1);
        }

        public Clock(boolean start, int format) {
            this.setOutputFormat(format);
            if (start) {
                this.start();
            }
        }

        protected void init() {
            this.m_ThreadMonitor = null;
            this.m_ThreadMonitor = this.getThreadMonitor();
            this.m_CanMeasureCpuTime = this.m_ThreadMonitor.isThreadCpuTimeSupported();
        }

        public boolean isCpuTime() {
            return this.m_UseCpuTime && this.m_CanMeasureCpuTime;
        }

        public void setUseCpuTime(boolean value) {
            this.m_UseCpuTime = value;
            if (this.m_Running) {
                this.stop();
                this.start();
            }
        }

        public boolean getUseCpuTime() {
            return this.m_UseCpuTime;
        }

        protected ThreadMXBean getThreadMonitor() {
            if (this.m_ThreadMonitor == null) {
                this.m_ThreadMonitor = ManagementFactory.getThreadMXBean();
                if (this.m_CanMeasureCpuTime && !this.m_ThreadMonitor.isThreadCpuTimeEnabled()) {
                    this.m_ThreadMonitor.setThreadCpuTimeEnabled(true);
                }
                this.m_ThreadID = Thread.currentThread().getId();
            }
            return this.m_ThreadMonitor;
        }

        protected long getCurrentTime() {
            long result = this.isCpuTime() ? this.getThreadMonitor().getThreadUserTime(this.m_ThreadID) / 1000000L : System.currentTimeMillis();
            return result;
        }

        public void start() {
            this.init();
            this.m_Stop = this.m_Start = this.getCurrentTime();
            this.m_Running = true;
        }

        public void stop() {
            this.m_Stop = this.getCurrentTime();
            this.m_Running = false;
        }

        public long getStart() {
            return this.m_Start;
        }

        public long getStop() {
            long result = this.isRunning() ? this.getCurrentTime() : this.m_Stop;
            return result;
        }

        public boolean isRunning() {
            return this.m_Running;
        }

        public void setOutputFormat(int value) {
            if (value == 0) {
                this.m_OutputFormat = value;
            } else if (value == 1) {
                this.m_OutputFormat = value;
            } else if (value == 2) {
                this.m_OutputFormat = value;
            } else {
                System.out.println("Format '" + value + "' is not recognized!");
            }
        }

        public int getOutputFormat() {
            return this.m_OutputFormat;
        }

        public String toString() {
            String result = "";
            long elapsed = this.getStop() - this.getStart();
            switch (this.getOutputFormat()) {
                case 2: {
                    long hours = elapsed / 3600000L;
                    long mins = (elapsed %= 3600000L) / 60000L;
                    long secs = (elapsed %= 60000L) / 1000L;
                    long msecs = elapsed % 1000L;
                    if (hours > 0L) {
                        result = result + "" + hours + ":";
                    }
                    result = mins < 10L ? result + "0" + mins + ":" : result + "" + mins + ":";
                    result = secs < 10L ? result + "0" + secs + "." : result + "" + secs + ".";
                    result = result + Utils.doubleToString((double)msecs / 1000.0, 3).replaceAll(".*\\.", "");
                    break;
                }
                case 1: {
                    result = Utils.doubleToString((double)elapsed / 1000.0, 3) + "s";
                    break;
                }
                case 0: {
                    result = "" + elapsed + "ms";
                    break;
                }
                default: {
                    result = "<unknown time format>";
                }
            }
            return result;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 8034 $");
        }
    }
}

