/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.shapelet_trees;

import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.TreeMap;
import java.util.TreeSet;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import weka.classifiers.AbstractClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class ShapeletTreeClassifier
extends AbstractClassifier {
    private ShapeletNode root = new ShapeletNode();
    private String logFileName;
    private int minLength;
    private int maxLength;

    public ShapeletTreeClassifier(String logFileName) throws Exception {
        this.logFileName = logFileName;
        this.maxLength = 0;
        this.minLength = 0;
        FileWriter fw = new FileWriter(logFileName);
        fw.close();
    }

    public void setShapeletMinMaxLength(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.minLength < 1 || this.maxLength < 1) {
            throw new Exception("Shapelet minimum or maximum length is incorrectly specified!");
        }
        this.root.initialiseNode(data, this.minLength, this.maxLength, 0);
    }

    @Override
    public double classifyInstance(Instance instance) {
        return this.root.classifyInstance(instance);
    }

    private Shapelet getRootShapelet() {
        return this.root.shapelet;
    }

    public double timingForSingleShapelet(Instances data, int minShapeletLength, int maxShapeletLength) {
        long startTime = System.nanoTime();
        this.findBestShapelet(1, data, minShapeletLength, maxShapeletLength);
        long finishTime = System.nanoTime();
        return (double)(finishTime - startTime) / 1.0E9;
    }

    private Shapelet findBestShapelet(int numShapelets, Instances data, int minShapeletLength, int maxShapeletLength) {
        ArrayList kShapelets = new ArrayList();
        ArrayList seriesShapelets = new ArrayList();
        Shapelet bestShapelet = null;
        TreeMap<Double, Integer> classDistributions = ShapeletTreeClassifier.getClassDistributions(data);
        for (int i = 0; i < data.numInstances(); ++i) {
            double[] wholeCandidate = data.instance(i).toDoubleArray();
            seriesShapelets = new ArrayList();
            for (int length = minShapeletLength; length <= maxShapeletLength; ++length) {
                for (int start = 0; start <= wholeCandidate.length - length - 1; ++start) {
                    double[] candidate = new double[length];
                    for (int m = start; m < start + length; ++m) {
                        candidate[m - start] = wholeCandidate[m];
                    }
                    candidate = ShapeletTreeClassifier.zNorm(candidate, false);
                    Shapelet candidateShapelet = ShapeletTreeClassifier.checkCandidate(candidate, data, i, start, classDistributions);
                    if (bestShapelet != null && candidateShapelet.compareTo(bestShapelet) >= 0) continue;
                    bestShapelet = candidateShapelet;
                }
            }
        }
        return bestShapelet;
    }

    private static ArrayList<Shapelet> removeSelfSimilar(ArrayList<Shapelet> shapelets) {
        int i;
        ArrayList<Shapelet> outputShapelets = new ArrayList<Shapelet>();
        boolean[] selfSimilar = new boolean[shapelets.size()];
        for (i = 0; i < shapelets.size(); ++i) {
            selfSimilar[i] = false;
        }
        for (i = 0; i < shapelets.size(); ++i) {
            if (selfSimilar[i]) continue;
            outputShapelets.add(shapelets.get(i));
            for (int j = i + 1; j < shapelets.size(); ++j) {
                if (selfSimilar[j] || !ShapeletTreeClassifier.selfSimilarity(shapelets.get(i), shapelets.get(j))) continue;
                selfSimilar[j] = true;
            }
        }
        return outputShapelets;
    }

    private ArrayList<Shapelet> combine(int k, ArrayList<Shapelet> kBestSoFar, ArrayList<Shapelet> timeSeriesShapelets) {
        int i;
        ArrayList<Shapelet> newBestSoFar = new ArrayList<Shapelet>();
        for (i = 0; i < timeSeriesShapelets.size(); ++i) {
            kBestSoFar.add(timeSeriesShapelets.get(i));
        }
        Collections.sort(kBestSoFar);
        if (kBestSoFar.size() < k) {
            return kBestSoFar;
        }
        for (i = 0; i < k; ++i) {
            newBestSoFar.add(kBestSoFar.get(i));
        }
        return newBestSoFar;
    }

    private static TreeMap<Double, Integer> getClassDistributions(Instances data) {
        TreeMap<Double, Integer> classDistribution = new TreeMap<Double, Integer>();
        for (int i = 0; i < data.numInstances(); ++i) {
            double classValue = data.instance(i).classValue();
            boolean classExists = false;
            for (Double d : classDistribution.keySet()) {
                if (d != classValue) continue;
                int temp = classDistribution.get(d);
                classDistribution.put(classValue, ++temp);
                classExists = true;
            }
            if (classExists) continue;
            classDistribution.put(classValue, 1);
        }
        return classDistribution;
    }

    private static Shapelet checkCandidate(double[] candidate, Instances data, int seriesId, int startPos, TreeMap classDistribution) {
        ArrayList<OrderLineObj> orderline = new ArrayList<OrderLineObj>();
        for (int i = 0; i < data.numInstances(); ++i) {
            double distance = ShapeletTreeClassifier.subsequenceDistance(candidate, data.instance(i));
            double classVal = data.instance(i).classValue();
            boolean added = false;
            if (orderline.isEmpty()) {
                orderline.add(new OrderLineObj(distance, classVal));
                added = true;
            } else {
                for (int j = 0; j < orderline.size(); ++j) {
                    if (added || !(((OrderLineObj)orderline.get(j)).distance > distance)) continue;
                    orderline.add(j, new OrderLineObj(distance, classVal));
                    added = true;
                }
            }
            if (added) continue;
            orderline.add(new OrderLineObj(distance, classVal));
        }
        Shapelet shapelet = new Shapelet(candidate, seriesId, startPos);
        shapelet.calcInfoGainAndThreshold(orderline, classDistribution);
        return shapelet;
    }

    private static double entropy(TreeMap<Double, Integer> classDistributions) {
        if (classDistributions.size() == 1) {
            return 0.0;
        }
        int total = 0;
        for (Double d : classDistributions.keySet()) {
            total += classDistributions.get(d).intValue();
        }
        ArrayList<Double> entropyParts = new ArrayList<Double>();
        for (Double d : classDistributions.keySet()) {
            double thisPart = (double)classDistributions.get(d).intValue() / (double)total;
            double toAdd = -thisPart * Math.log10(thisPart) / Math.log10(2.0);
            if (Double.isNaN(toAdd)) {
                toAdd = 0.0;
            }
            entropyParts.add(toAdd);
        }
        double d = 0.0;
        for (int i = 0; i < entropyParts.size(); ++i) {
            d += ((Double)entropyParts.get(i)).doubleValue();
        }
        return d;
    }

    public static double subsequenceDistance(double[] candidate, Instance timeSeriesIns) {
        double[] timeSeries = timeSeriesIns.toDoubleArray();
        return ShapeletTreeClassifier.subsequenceDistance(candidate, timeSeries);
    }

    public static double subsequenceDistance(double[] candidate, double[] timeSeries) {
        double bestSum = Double.MAX_VALUE;
        double sum = 0.0;
        for (int i = 0; i <= timeSeries.length - candidate.length - 1; ++i) {
            int j;
            sum = 0.0;
            double[] subseq = new double[candidate.length];
            for (j = i; j < i + candidate.length; ++j) {
                subseq[j - i] = timeSeries[j];
            }
            subseq = ShapeletTreeClassifier.zNorm(subseq, false);
            for (j = 0; j < candidate.length; ++j) {
                sum += (candidate[j] - subseq[j]) * (candidate[j] - subseq[j]);
            }
            if (!(sum < bestSum)) continue;
            bestSum = sum;
        }
        return 1.0 / (double)candidate.length * bestSum;
    }

    public static double subsequenceDistanceSwitch(double[] candidate, double[] timeSeries) {
        if (timeSeries.length > candidate.length) {
            double[] temp = candidate;
            candidate = timeSeries;
            timeSeries = temp;
        }
        double bestSum = Double.MAX_VALUE;
        double sum = 0.0;
        for (int i = 0; i <= timeSeries.length - candidate.length - 1; ++i) {
            int j;
            sum = 0.0;
            double[] subseq = new double[candidate.length];
            for (j = i; j < i + candidate.length; ++j) {
                subseq[j - i] = timeSeries[j];
            }
            subseq = ShapeletTreeClassifier.zNorm(subseq, false);
            for (j = 0; j < candidate.length; ++j) {
                sum += (candidate[j] - subseq[j]) * (candidate[j] - subseq[j]);
            }
            if (!(sum < bestSum)) continue;
            bestSum = sum;
        }
        return 1.0 / (double)candidate.length * bestSum;
    }

    public static double[] zNorm(double[] input, boolean classValOn) {
        double classValPenalty = 0.0;
        if (classValOn) {
            classValPenalty = 1.0;
        }
        double[] output = new double[input.length];
        double seriesTotal = 0.0;
        int i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            seriesTotal += input[i];
            ++i;
        }
        double mean = seriesTotal / ((double)input.length - classValPenalty);
        double stdv = 0.0;
        i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            stdv += (input[i] - mean) * (input[i] - mean);
            ++i;
        }
        stdv = stdv / (double)input.length - classValPenalty;
        stdv = Math.sqrt(stdv);
        i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            output[i] = (input[i] - mean) / stdv;
            ++i;
        }
        if (classValOn) {
            output[output.length - 1] = input[input.length - 1];
        }
        return output;
    }

    public static Instances loadData(String fileName) {
        Instances data = null;
        try {
            FileReader r = new FileReader(fileName);
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method loadData");
        }
        return data;
    }

    private static boolean selfSimilarity(int seriesId, int startPos, int length, Shapelet[] selectedShapelets) {
        boolean selfSimilarity = false;
        for (Shapelet shapelet : selectedShapelets) {
            if (shapelet == null || seriesId != shapelet.seriesId) continue;
            if (startPos >= shapelet.startPos && startPos <= shapelet.startPos + shapelet.content.length) {
                selfSimilarity = true;
            }
            if (shapelet.startPos < startPos || shapelet.startPos > startPos + length) continue;
            selfSimilarity = true;
        }
        return selfSimilarity;
    }

    private static boolean selfSimilarity(Shapelet candidate, TreeSet<Shapelet> setOfShapelets) {
        boolean selfSimilarity = false;
        for (Shapelet shapelet : setOfShapelets) {
            if (shapelet == null || candidate.seriesId != shapelet.seriesId) continue;
            if (candidate.startPos >= shapelet.startPos && candidate.startPos <= shapelet.startPos + shapelet.content.length) {
                selfSimilarity = true;
            }
            if (shapelet.startPos < candidate.startPos || shapelet.startPos > candidate.startPos + candidate.content.length) continue;
            selfSimilarity = true;
        }
        return selfSimilarity;
    }

    private static boolean selfSimilarity(Shapelet shapelet, Shapelet candidate) {
        if (candidate.seriesId == shapelet.seriesId) {
            if (candidate.startPos >= shapelet.startPos && candidate.startPos < shapelet.startPos + shapelet.content.length) {
                return true;
            }
            if (shapelet.startPos >= candidate.startPos && shapelet.startPos < candidate.startPos + candidate.content.length) {
                return true;
            }
        }
        return false;
    }

    public static String getTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        return calendar.get(5) + "/" + calendar.get(2) + "/" + calendar.get(1) + " - " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + " AM";
    }

    public static void staticShapelet(ArrayList<double[]> inputShapeletArrays) throws Exception {
        ArrayList<Shapelet> shapelets = new ArrayList<Shapelet>();
        for (int i = 0; i < inputShapeletArrays.size(); ++i) {
            Shapelet temp = new Shapelet(inputShapeletArrays.get(i));
            shapelets.add(temp);
        }
        for (int k = 1; k < 29; ++k) {
            ShapeletTransform sf = new ShapeletTransform();
            ShapeletPam sp = new ShapeletPam(shapelets, k);
            sp.clusterShapelets(k);
            double avgSil = sp.calculateAvgSil();
            System.out.println("K:" + k + ": " + avgSil);
        }
    }

    private static class ShapeletPam {
        private ArrayList<ShapeletObj> shapelets = new ArrayList();
        private int k;
        private int[] medoids;
        private ArrayList<ArrayList<ShapeletObj>> clusters;

        private ShapeletPam(ArrayList<Shapelet> inputShapelets, int k) {
            ArrayList<Shapelet> temp = inputShapelets;
            Collections.shuffle(temp);
            int shapeletId = 0;
            for (Shapelet s : temp) {
                ShapeletObj shapeObj = new ShapeletObj(shapeletId++, s);
                this.shapelets.add(shapeObj);
            }
            this.k = k;
            this.medoids = new int[k];
        }

        private void clusterShapelets(int k) {
            Shapelet thisMedoid;
            Collections.shuffle(this.shapelets);
            this.medoids = new int[k];
            for (int i = 0; i < k; ++i) {
                this.medoids[i] = i;
                this.shapelets.get(i).clusterId = i;
            }
            for (int i = k; i < this.shapelets.size(); ++i) {
                int clusterId = -1;
                double minDist = Double.MAX_VALUE;
                Shapelet thisShapelet = this.shapelets.get(i).shapelet;
                for (int j = 0; j < k; ++j) {
                    thisMedoid = this.shapelets.get(j).shapelet;
                    double dist = thisShapelet.content.length < thisMedoid.content.length ? ShapeletTreeClassifier.subsequenceDistance(thisShapelet.content, thisMedoid.content) : ShapeletTreeClassifier.subsequenceDistance(thisMedoid.content, thisShapelet.content);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    this.shapelets.get(i).clusterId = j;
                }
            }
            boolean finished = false;
            while (!finished) {
                boolean anyMedoidChanged = false;
                for (int clusterNum = 0; clusterNum < k; ++clusterNum) {
                    int currentMedoidId = this.medoids[clusterNum];
                    int bestFoundId = this.medoids[clusterNum];
                    double bestDistance = Double.MAX_VALUE;
                    for (int i = 0; i < this.shapelets.size(); ++i) {
                        if (this.shapelets.get(i).clusterId != clusterNum) continue;
                        ShapeletObj candidateMedoid = this.shapelets.get(i);
                        double clusterDistance = 0.0;
                        for (int j = 0; j < this.shapelets.size(); ++j) {
                            if (this.shapelets.get(i).clusterId != clusterNum || i == j) continue;
                            Shapelet thisComparison = this.shapelets.get(j).shapelet;
                            if (candidateMedoid.shapelet.content.length < thisComparison.content.length) {
                                clusterDistance += ShapeletTreeClassifier.subsequenceDistance(candidateMedoid.shapelet.content, thisComparison.content);
                                continue;
                            }
                            clusterDistance += ShapeletTreeClassifier.subsequenceDistance(thisComparison.content, candidateMedoid.shapelet.content);
                        }
                        if (!(clusterDistance < bestDistance)) continue;
                        bestDistance = clusterDistance;
                        bestFoundId = i;
                    }
                    if (bestFoundId == currentMedoidId) continue;
                    anyMedoidChanged = true;
                    this.medoids[clusterNum] = bestFoundId;
                }
                if (!anyMedoidChanged) {
                    finished = true;
                    continue;
                }
                for (int i = 0; i < this.shapelets.size(); ++i) {
                    int clusterId = -1;
                    double minDist = Double.MAX_VALUE;
                    Shapelet thisShapelet = this.shapelets.get(i).shapelet;
                    for (int j = 0; j < k; ++j) {
                        thisMedoid = this.shapelets.get(this.medoids[j]).shapelet;
                        double dist = thisShapelet.content.length < thisMedoid.content.length ? ShapeletTreeClassifier.subsequenceDistance(thisShapelet.content, thisMedoid.content) : ShapeletTreeClassifier.subsequenceDistance(thisMedoid.content, thisShapelet.content);
                        if (!(dist < minDist)) continue;
                        minDist = dist;
                        this.shapelets.get(i).clusterId = k;
                    }
                }
            }
            this.clusters = new ArrayList();
            for (int i = 0; i < k; ++i) {
                this.clusters.add(new ArrayList());
                for (int j = 0; j < this.shapelets.size(); ++j) {
                    if (this.shapelets.get(j).clusterId != k) continue;
                    this.clusters.get(i).add(this.shapelets.get(j));
                }
            }
        }

        private double calculateAvgSil() throws Exception {
            if (this.clusters == null) {
                throw new Exception("Clusters not initialised yet");
            }
            double totalSilVal = 0.0;
            for (int i = 0; i < this.k; ++i) {
                for (int j = 0; j < this.clusters.get(i).size(); ++j) {
                    double ownClusterDist = 0.0;
                    double bestOtherClusterDist = Double.MAX_VALUE;
                    double currentOtherClusterDist = 0.0;
                    double[] thisShapelet = this.clusters.get(i).get(j).shapelet.content;
                    for (int m = 0; m < this.clusters.get(i).size(); ++m) {
                        if (m == j) continue;
                        if (thisShapelet.length < this.clusters.get(i).get(m).shapelet.content.length) {
                            ownClusterDist += ShapeletTreeClassifier.subsequenceDistance(thisShapelet, this.clusters.get(i).get(m).shapelet.content);
                            continue;
                        }
                        ownClusterDist += ShapeletTreeClassifier.subsequenceDistance(this.clusters.get(i).get(m).shapelet.content, thisShapelet);
                    }
                    ownClusterDist /= (double)this.clusters.get(i).size();
                    for (int cluster = 0; cluster < this.k; ++cluster) {
                        currentOtherClusterDist = 0.0;
                        for (int m = 0; m < this.clusters.get(cluster).size(); ++m) {
                            currentOtherClusterDist += ShapeletTreeClassifier.subsequenceDistanceSwitch(thisShapelet, this.clusters.get(cluster).get(m).shapelet.content);
                        }
                        if (!(bestOtherClusterDist > (currentOtherClusterDist /= (double)this.clusters.get(cluster).size()))) continue;
                        bestOtherClusterDist = currentOtherClusterDist;
                    }
                    double silVal = bestOtherClusterDist - ownClusterDist;
                    double div = ownClusterDist;
                    if (bestOtherClusterDist > ownClusterDist) {
                        div = bestOtherClusterDist;
                    }
                    totalSilVal += (silVal /= div);
                }
            }
            return totalSilVal /= (double)this.shapelets.size();
        }
    }

    private static class ShapeletObj {
        private Shapelet shapelet;
        private int clusterId;
        private int shapeletId;

        private ShapeletObj(int shapeletId, Shapelet shapelet) {
            this.shapeletId = shapeletId;
            this.shapelet = shapelet;
            this.clusterId = -1;
        }
    }

    private static class OrderLineObj {
        private double distance;
        private double classVal;

        private OrderLineObj(double distance, double classVal) {
            this.distance = distance;
            this.classVal = classVal;
        }
    }

    private static class Shapelet
    implements Comparable<Shapelet> {
        private double[] content;
        private int seriesId;
        private int startPos;
        private double splitThreshold;
        private double informationGain;
        private double separationGap;

        private Shapelet(double[] content, int seriesId, int startPos) {
            this.content = content;
            this.seriesId = seriesId;
            this.startPos = startPos;
        }

        private Shapelet(double[] content, int seriesId, int startPos, double splitThreshold, double gain, double gap) {
            this.content = content;
            this.seriesId = seriesId;
            this.startPos = startPos;
            this.splitThreshold = splitThreshold;
            this.informationGain = gain;
            this.separationGap = gap;
        }

        private Shapelet(double[] content) {
            this.content = content;
        }

        private void calcInfoGainAndThreshold(ArrayList<OrderLineObj> orderline, TreeMap<Double, Integer> classDistribution) {
            double lastDist = orderline.get(0).distance;
            double thisDist = -1.0;
            double bsfGain = -1.0;
            double threshold = -1.0;
            for (int i = 1; i < orderline.size(); ++i) {
                thisDist = orderline.get(i).distance;
                if (i == 1 || thisDist != lastDist) {
                    double entropyGreater;
                    double greaterFrac;
                    double entropyLess;
                    double lessFrac;
                    int storedTotal;
                    double thisClassVal;
                    int j;
                    TreeMap<Double, Integer> lessClasses = new TreeMap<Double, Integer>();
                    TreeMap<Double, Integer> greaterClasses = new TreeMap<Double, Integer>();
                    for (double j2 : classDistribution.keySet()) {
                        lessClasses.put(j2, 0);
                        greaterClasses.put(j2, 0);
                    }
                    int sumOfLessClasses = 0;
                    int sumOfGreaterClasses = 0;
                    for (j = 0; j < i; ++j) {
                        thisClassVal = orderline.get(j).classVal;
                        storedTotal = (Integer)lessClasses.get(thisClassVal);
                        lessClasses.put(thisClassVal, ++storedTotal);
                        ++sumOfLessClasses;
                    }
                    for (j = i; j < orderline.size(); ++j) {
                        thisClassVal = orderline.get(j).classVal;
                        storedTotal = (Integer)greaterClasses.get(thisClassVal);
                        greaterClasses.put(thisClassVal, ++storedTotal);
                        ++sumOfGreaterClasses;
                    }
                    int sumOfAllClasses = sumOfLessClasses + sumOfGreaterClasses;
                    double parentEntropy = ShapeletTreeClassifier.entropy(classDistribution);
                    double gain = parentEntropy - (lessFrac = (double)sumOfLessClasses / (double)sumOfAllClasses) * (entropyLess = ShapeletTreeClassifier.entropy(lessClasses)) - (greaterFrac = (double)sumOfGreaterClasses / (double)sumOfAllClasses) * (entropyGreater = ShapeletTreeClassifier.entropy(greaterClasses));
                    if (gain > bsfGain) {
                        bsfGain = gain;
                        threshold = (thisDist - lastDist) / 2.0 + lastDist;
                    }
                }
                lastDist = thisDist;
            }
            if (bsfGain >= 0.0) {
                this.informationGain = bsfGain;
                this.splitThreshold = threshold;
                this.separationGap = this.calculateSeparationGap(orderline, threshold);
            }
        }

        private double calculateSeparationGap(ArrayList<OrderLineObj> orderline, double distanceThreshold) {
            double sumLeft = 0.0;
            double leftSize = 0.0;
            double sumRight = 0.0;
            double rightSize = 0.0;
            for (int i = 0; i < orderline.size(); ++i) {
                if (orderline.get(i).distance < distanceThreshold) {
                    sumLeft += orderline.get(i).distance;
                    leftSize += 1.0;
                    continue;
                }
                sumRight += orderline.get(i).distance;
                rightSize += 1.0;
            }
            double thisSeparationGap = 1.0 / rightSize * sumRight - 1.0 / leftSize * sumLeft;
            if (rightSize == 0.0 || leftSize == 0.0) {
                return -1.0;
            }
            return thisSeparationGap;
        }

        public double getGain() {
            return this.informationGain;
        }

        public double getGap() {
            return this.separationGap;
        }

        public int getLength() {
            return this.content.length;
        }

        @Override
        public int compareTo(Shapelet shapelet) {
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (this.informationGain != shapelet.getGain()) {
                if (this.informationGain > shapelet.getGain()) {
                    return -1;
                }
                return 1;
            }
            if (this.separationGap != shapelet.getGap()) {
                if (this.separationGap > shapelet.getGap()) {
                    return -1;
                }
                return 1;
            }
            if (this.content.length != shapelet.getLength()) {
                if (this.content.length < shapelet.getLength()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private class ShapeletNode {
        private ShapeletNode leftNode = null;
        private ShapeletNode rightNode = null;
        private double classDecision = -1.0;
        private Shapelet shapelet;

        public void initialiseNode(Instances data, int minShapeletLength, int maxShapeletLength, int level) throws Exception {
            FileWriter fw = new FileWriter(ShapeletTreeClassifier.this.logFileName, true);
            fw.append("level:" + level + ", numInstances:" + data.numInstances() + "\n");
            fw.close();
            double firstClassValue = data.instance(0).classValue();
            boolean oneClass = true;
            for (int i = 1; i < data.numInstances(); ++i) {
                if (data.instance(i).classValue() == firstClassValue) continue;
                oneClass = false;
                break;
            }
            if (oneClass) {
                this.classDecision = firstClassValue;
                fw = new FileWriter(ShapeletTreeClassifier.this.logFileName, true);
                fw.append("class decision here: " + firstClassValue + "\n");
                fw.close();
            } else {
                try {
                    this.shapelet = ShapeletTreeClassifier.this.findBestShapelet(1, data, minShapeletLength, maxShapeletLength);
                    ArrayList<Instance> splitLeft = new ArrayList<Instance>();
                    ArrayList<Instance> splitRight = new ArrayList<Instance>();
                    for (int i = 0; i < data.numInstances(); ++i) {
                        double dist = ShapeletTreeClassifier.subsequenceDistance(this.shapelet.content, data.instance(i).toDoubleArray());
                        if (dist < this.shapelet.splitThreshold) {
                            splitLeft.add(data.instance(i));
                            continue;
                        }
                        splitRight.add(data.instance(i));
                    }
                    fw = new FileWriter(ShapeletTreeClassifier.this.logFileName, true);
                    fw.append("seriesId, startPos, length, infoGain, splitThresh\n");
                    fw.append(this.shapelet.seriesId + "," + this.shapelet.startPos + "," + this.shapelet.content.length + "," + this.shapelet.informationGain + "," + this.shapelet.splitThreshold + "\n");
                    for (int j = 0; j < this.shapelet.content.length; ++j) {
                        fw.append(this.shapelet.content[j] + ",");
                    }
                    fw.append("\n");
                    fw.close();
                    this.leftNode = new ShapeletNode();
                    this.rightNode = new ShapeletNode();
                    Instances leftInstances = new Instances(data, splitLeft.size());
                    for (int i = 0; i < splitLeft.size(); ++i) {
                        leftInstances.add((Instance)splitLeft.get(i));
                    }
                    Instances rightInstances = new Instances(data, splitRight.size());
                    for (int i = 0; i < splitRight.size(); ++i) {
                        rightInstances.add((Instance)splitRight.get(i));
                    }
                    fw = new FileWriter(ShapeletTreeClassifier.this.logFileName, true);
                    fw.append("left size under level " + level + ": " + leftInstances.numInstances() + "\n");
                    fw.close();
                    this.leftNode.initialiseNode(leftInstances, minShapeletLength, maxShapeletLength, level + 1);
                    fw = new FileWriter(ShapeletTreeClassifier.this.logFileName, true);
                    fw.append("right size under level " + level + ": " + rightInstances.numInstances() + "\n");
                    fw.close();
                    this.rightNode.initialiseNode(rightInstances, minShapeletLength, maxShapeletLength, level + 1);
                }
                catch (Exception e) {
                    System.out.println("Problem initialising tree node: " + e);
                    e.printStackTrace();
                }
            }
        }

        public double classifyInstance(Instance instance) {
            if (this.leftNode == null) {
                return this.classDecision;
            }
            double distance = ShapeletTreeClassifier.subsequenceDistance(this.shapelet.content, instance);
            if (distance < this.shapelet.splitThreshold) {
                return this.leftNode.classifyInstance(instance);
            }
            return this.rightNode.classifyInstance(instance);
        }
    }
}

