/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.ht;

import java.util.LinkedHashMap;
import java.util.Map;
import weka.classifiers.trees.ht.HNode;
import weka.classifiers.trees.ht.LeafNode;
import weka.classifiers.trees.ht.Split;
import weka.classifiers.trees.ht.WeightMass;
import weka.core.Instance;

public class SplitNode
extends HNode {
    private static final long serialVersionUID = 1558033628618451073L;
    protected Split m_split;
    protected Map<String, HNode> m_children = new LinkedHashMap<String, HNode>();

    public SplitNode(Map<String, WeightMass> classDistrib, Split split) {
        super(classDistrib);
        this.m_split = split;
    }

    public String branchForInstance(Instance inst) {
        return this.m_split.branchForInstance(inst);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public int numChildred() {
        return this.m_children.size();
    }

    public void setChild(String branch, HNode child) {
        this.m_children.put(branch, child);
    }

    @Override
    public LeafNode leafForInstance(Instance inst, SplitNode parent, String parentBranch) {
        String branch = this.branchForInstance(inst);
        if (branch != null) {
            HNode child = this.m_children.get(branch);
            if (child != null) {
                return child.leafForInstance(inst, this, branch);
            }
            return new LeafNode(null, this, branch);
        }
        return new LeafNode(this, parent, parentBranch);
    }

    @Override
    public void updateNode(Instance inst) {
    }

    @Override
    protected int dumpTree(int depth, int leafCount, StringBuffer buff) {
        boolean first = true;
        for (Map.Entry<String, HNode> e : this.m_children.entrySet()) {
            HNode child = e.getValue();
            String branch = e.getKey();
            if (child == null) continue;
            buff.append("\n");
            for (int i = 0; i < depth; ++i) {
                buff.append("|   ");
            }
            buff.append(this.m_split.conditionForBranch(branch).trim());
            buff.append(": ");
            leafCount = child.dumpTree(depth + 1, leafCount, buff);
        }
        return leafCount;
    }

    @Override
    public int installNodeNums(int nodeNum) {
        nodeNum = super.installNodeNums(nodeNum);
        for (Map.Entry<String, HNode> e : this.m_children.entrySet()) {
            HNode child = e.getValue();
            if (child == null) continue;
            nodeNum = child.installNodeNums(nodeNum);
        }
        return nodeNum;
    }

    @Override
    public void graphTree(StringBuffer buff) {
        HNode child;
        boolean first = true;
        for (Map.Entry<String, HNode> e : this.m_children.entrySet()) {
            child = e.getValue();
            String branch = e.getKey();
            if (child == null) continue;
            String conditionForBranch = this.m_split.conditionForBranch(branch);
            if (first) {
                String testAttName = null;
                testAttName = conditionForBranch.indexOf("<=") < 0 ? conditionForBranch.substring(0, conditionForBranch.indexOf("=")).trim() : conditionForBranch.substring(0, conditionForBranch.indexOf("<")).trim();
                first = false;
                buff.append("N" + this.m_nodeNum + " [label=\"" + testAttName + "\"]\n");
            }
            int startIndex = 0;
            startIndex = conditionForBranch.indexOf("<=") > 0 ? conditionForBranch.indexOf("<") - 1 : (conditionForBranch.indexOf("=") > 0 ? conditionForBranch.indexOf("=") - 1 : conditionForBranch.indexOf(">") - 1);
            conditionForBranch = conditionForBranch.substring(startIndex, conditionForBranch.length()).trim();
            buff.append("N" + this.m_nodeNum + "->" + "N" + child.m_nodeNum + "[label=\"" + conditionForBranch + "\"]\n").append("\n");
        }
        for (Map.Entry<String, HNode> e : this.m_children.entrySet()) {
            child = e.getValue();
            if (child == null) continue;
            child.graphTree(buff);
        }
    }

    @Override
    protected void printLeafModels(StringBuffer buff) {
        for (Map.Entry<String, HNode> e : this.m_children.entrySet()) {
            HNode child = e.getValue();
            if (child == null) continue;
            child.printLeafModels(buff);
        }
    }
}

