/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.sortinghandler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import weka.classifiers.rules.sortinghandler.Comparator;
import weka.classifiers.rules.sortinghandler.FileSort;
import weka.classifiers.rules.sortinghandler.QuicksortVector;
import weka.classifiers.rules.sortinghandler.Record;
import weka.classifiers.rules.sortinghandler.RecordCopyFile;
import weka.classifiers.rules.sortinghandler.RecordInformation;
import weka.classifiers.rules.sortinghandler.RecordReader;
import weka.classifiers.rules.sortinghandler.RecordWriter;

public final class PolyphaseMergeSort
implements FileSort {
    @Override
    public final void sort(String fileName, RecordInformation r) throws FileNotFoundException, IOException {
        PolyphaseMergeSort.execute(fileName, 20, 2, r);
    }

    public final void sort(String fileName, int blockSize, int numberOfFiles, RecordInformation r) throws FileNotFoundException, IOException {
        PolyphaseMergeSort.execute(fileName, blockSize, numberOfFiles, r);
    }

    public static void execute(String fileName, RecordInformation r) throws FileNotFoundException, IOException {
        PolyphaseMergeSort.execute(fileName, 20, 2, r);
    }

    public static void execute(String fileName, int approximateBlockSize, int numberOfFiles, RecordInformation rInfo) throws FileNotFoundException, IOException {
        int i;
        ++numberOfFiles;
        numberOfFiles = 3;
        File file = new File(fileName);
        File[] temp = new File[numberOfFiles];
        for (int i2 = 0; i2 < numberOfFiles; ++i2) {
            temp[i2] = new File("tmp_" + i2);
        }
        int indexOfNumberOfBlocks = 1;
        int initialBlockSize = 1;
        int numberOfRecords = RecordCopyFile.execute(file, temp[0], rInfo);
        int[] F = new int[numberOfRecords];
        for (i = 0; i < numberOfFiles; ++i) {
            F[i] = 1;
        }
        for (i = numberOfFiles; i < numberOfRecords; ++i) {
            F[i] = 0;
            for (int j = i - 1; j > i - numberOfFiles; --j) {
                int n = i;
                F[n] = F[n] + F[j];
            }
            initialBlockSize = numberOfRecords / F[i];
            if (initialBlockSize >= approximateBlockSize) continue;
            indexOfNumberOfBlocks = i - 1;
            break;
        }
        while (++initialBlockSize * F[indexOfNumberOfBlocks] <= numberOfRecords) {
        }
        int[] blockSizes = new int[numberOfFiles];
        int[] blockCounts = new int[numberOfFiles];
        blockSizes[0] = 0;
        blockCounts[0] = 0;
        int i3 = 1;
        int j = indexOfNumberOfBlocks - 1;
        while (i3 < numberOfFiles) {
            blockSizes[i3] = initialBlockSize;
            blockCounts[i3] = F[j];
            ++i3;
            --j;
        }
        PolyphaseMergeSort.distributeSortedBlocks(temp, 0, initialBlockSize, blockCounts, rInfo);
        RecordReader[] readers = new RecordReader[numberOfFiles];
        for (int i4 = 0; i4 < numberOfFiles; ++i4) {
            readers[i4] = rInfo.newRecordReader(temp[i4]);
        }
        while (true) {
            int i5;
            int toIndex = -1;
            int numberOfNonEmptyFiles = 0;
            int indexOfNonEmptyFile = -1;
            for (i5 = 0; i5 < numberOfFiles; ++i5) {
                if (blockCounts[i5] == 0) {
                    toIndex = i5;
                    continue;
                }
                indexOfNonEmptyFile = i5;
                ++numberOfNonEmptyFiles;
            }
            if (numberOfNonEmptyFiles <= 1) {
                for (i5 = 0; i5 < numberOfFiles; ++i5) {
                    readers[i5].close();
                }
                RecordCopyFile.execute(temp[indexOfNonEmptyFile], file, rInfo);
                for (i5 = 0; i5 < numberOfFiles; ++i5) {
                    temp[i5].delete();
                }
                break;
            }
            readers[toIndex].close();
            RecordWriter writer = rInfo.newRecordWriter(temp[toIndex]);
            PolyphaseMergeSort.merge(readers, writer, toIndex, blockSizes, blockCounts, rInfo);
            writer.close();
            readers[toIndex] = rInfo.newRecordReader(temp[toIndex]);
        }
    }

    private static void distributeSortedBlocks(File[] files, int fromIndex, int blockSize, int[] blockCounts, RecordInformation rInfo) throws FileNotFoundException, IOException {
        int i;
        RecordReader reader = rInfo.newRecordReader(files[fromIndex]);
        RecordWriter[] writers = new RecordWriter[files.length];
        for (i = 0; i < files.length; ++i) {
            writers[i] = i == fromIndex ? null : rInfo.newRecordWriter(files[i]);
        }
        for (i = 0; i < writers.length; ++i) {
            if (i == fromIndex) continue;
            for (int j = 0; j < blockCounts[i]; ++j) {
                Record r;
                int k;
                Vector<Record> v = new Vector<Record>();
                for (k = 0; k < blockSize && (r = reader.readRecord()) != null; ++k) {
                    v.addElement(r);
                }
                QuicksortVector.execute(v, rInfo.getComparator());
                for (k = 0; k < v.size(); ++k) {
                    writers[i].writeRecord((Record)v.elementAt(k));
                }
            }
        }
        for (i = 0; i < writers.length; ++i) {
            if (i == fromIndex) continue;
            writers[i].close();
        }
        reader.close();
    }

    private static void merge(RecordReader[] readers, RecordWriter writer, int toIndex, int[] blockSizes, int[] blockCounts, RecordInformation rInfo) throws FileNotFoundException, IOException {
        int i;
        Record[] items = new Record[readers.length];
        int[] counts = new int[readers.length];
        int numberOfBlocksMerged = 0;
        block0: while (true) {
            int i2;
            boolean allDone = false;
            for (i2 = 0; i2 < readers.length; ++i2) {
                counts[i2] = 0;
                if (i2 == toIndex) {
                    items[i2] = null;
                    continue;
                }
                readers[i2].mark(64);
                items[i2] = readers[i2].readRecord();
                if (items[i2] == null) {
                    for (int j = 0; j < i2; ++j) {
                        if (j == toIndex) continue;
                        readers[j].reset();
                    }
                    allDone = true;
                    break;
                }
                counts[i2] = 1;
            }
            if (allDone) break;
            ++numberOfBlocksMerged;
            while (true) {
                if ((i2 = PolyphaseMergeSort.findAppropriate(items, toIndex, rInfo.getComparator())) < 0) continue block0;
                writer.writeRecord(items[i2]);
                if (counts[i2] < blockSizes[i2]) {
                    items[i2] = readers[i2].readRecord();
                    if (items[i2] == null) continue;
                    int n = i2;
                    counts[n] = counts[n] + 1;
                    continue;
                }
                items[i2] = null;
            }
            break;
        }
        blockSizes[toIndex] = 0;
        for (i = 0; i < readers.length; ++i) {
            if (i == toIndex) continue;
            int n = toIndex;
            blockSizes[n] = blockSizes[n] + blockSizes[i];
        }
        i = 0;
        while (i < readers.length) {
            int n = i++;
            blockCounts[n] = blockCounts[n] - numberOfBlocksMerged;
        }
        blockCounts[toIndex] = numberOfBlocksMerged;
    }

    private static int findAppropriate(Record[] items, int toIndex, Comparator c) {
        int index = -1;
        for (int i = 0; i < items.length; ++i) {
            if (i == toIndex || items[i] == null) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            Record value = items[index];
            for (int i = index + 1; i < items.length; ++i) {
                if (i == toIndex || items[i] == null || !c.relation(items[i], value)) continue;
                index = i;
                value = items[i];
            }
        }
        return index;
    }
}

