/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.sortinghandler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import weka.classifiers.rules.sortinghandler.Comparator;
import weka.classifiers.rules.sortinghandler.FileSort;
import weka.classifiers.rules.sortinghandler.QuicksortVector;
import weka.classifiers.rules.sortinghandler.Record;
import weka.classifiers.rules.sortinghandler.RecordCopyFile;
import weka.classifiers.rules.sortinghandler.RecordInformation;
import weka.classifiers.rules.sortinghandler.RecordReader;
import weka.classifiers.rules.sortinghandler.RecordWriter;

public final class BalancedMergeSort
implements FileSort {
    @Override
    public final void sort(String fileName, RecordInformation r) throws FileNotFoundException, IOException {
        BalancedMergeSort.execute(fileName, 20, 2, r);
    }

    public final void sort(String fileName, int blockSize, int numberOfFiles, RecordInformation r) throws FileNotFoundException, IOException {
        BalancedMergeSort.execute(fileName, blockSize, numberOfFiles, r);
    }

    public static void execute(String fileName, RecordInformation r) throws FileNotFoundException, IOException {
        BalancedMergeSort.execute(fileName, 20, 2, r);
    }

    public static void execute(String fileName, int blockSize, int numberOfFiles, RecordInformation rInfo) throws FileNotFoundException, IOException {
        File file = new File(fileName);
        File[] f_A = new File[numberOfFiles];
        File[] f_B = new File[numberOfFiles];
        for (int i = 0; i < numberOfFiles; ++i) {
            f_A[i] = new File("tmp_A_" + i);
            f_B[i] = new File("tmp_B_" + i);
        }
        BalancedMergeSort.distributeSortedBlocks(file, f_A, blockSize, rInfo);
        File[] from = f_A;
        File[] to = f_B;
        boolean B_isFinal = true;
        int i = 0;
        while (BalancedMergeSort.merge(from, to, (int)Math.pow(2.0, i) * blockSize, rInfo)) {
            File[] temp = from;
            from = to;
            to = temp;
            B_isFinal = !B_isFinal;
            ++i;
        }
        File fileToCopy = B_isFinal ? f_B[0] : f_A[0];
        RecordCopyFile.execute(fileToCopy, file, rInfo);
        for (int i2 = 0; i2 < numberOfFiles; ++i2) {
            f_A[i2].delete();
            f_B[i2].delete();
        }
    }

    private static void distributeSortedBlocks(File from, File[] to, int blockSize, RecordInformation rInfo) throws FileNotFoundException, IOException {
        int i;
        RecordReader reader = rInfo.newRecordReader(from);
        RecordWriter[] writers = new RecordWriter[to.length];
        for (int i2 = 0; i2 < to.length; ++i2) {
            writers[i2] = rInfo.newRecordWriter(to[i2]);
        }
        boolean allDone = false;
        while (!allDone) {
            for (i = 0; !allDone && i < writers.length; ++i) {
                int j;
                Vector<Record> v = new Vector<Record>();
                for (j = 0; j < blockSize; ++j) {
                    Record r = reader.readRecord();
                    if (r == null) {
                        allDone = true;
                        break;
                    }
                    v.addElement(r);
                }
                QuicksortVector.execute(v, rInfo.getComparator());
                for (j = 0; j < v.size(); ++j) {
                    writers[i].writeRecord((Record)v.elementAt(j));
                }
            }
        }
        for (i = 0; i < writers.length; ++i) {
            writers[i].close();
        }
        reader.close();
    }

    private static boolean merge(File[] from, File[] to, int currentBlockSize, RecordInformation rInfo) throws FileNotFoundException, IOException {
        int i;
        RecordReader[] readers = new RecordReader[from.length];
        for (int i2 = 0; i2 < readers.length; ++i2) {
            readers[i2] = rInfo.newRecordReader(from[i2]);
        }
        RecordWriter[] writers = new RecordWriter[to.length];
        for (int i3 = 0; i3 < writers.length; ++i3) {
            writers[i3] = rInfo.newRecordWriter(to[i3]);
        }
        boolean returnValue = false;
        boolean allDone = false;
        Record[] items = new Record[readers.length];
        int[] counts = new int[readers.length];
        block2: while (!allDone) {
            for (i = 0; i < writers.length; ++i) {
                int index;
                allDone = true;
                for (int j = 0; j < readers.length; ++j) {
                    counts[j] = 0;
                    items[j] = readers[j].readRecord();
                    if (items[j] == null) continue;
                    counts[j] = 1;
                    allDone = false;
                }
                if (allDone) continue block2;
                while ((index = BalancedMergeSort.findAppropriate(items, rInfo.getComparator())) >= 0) {
                    writers[i].writeRecord(items[index]);
                    if (i > 0) {
                        returnValue = true;
                    }
                    if (counts[index] < currentBlockSize) {
                        items[index] = readers[index].readRecord();
                        if (items[index] == null) continue;
                        int n = index;
                        counts[n] = counts[n] + 1;
                        continue;
                    }
                    items[index] = null;
                }
            }
        }
        for (i = 0; i < writers.length; ++i) {
            writers[i].close();
        }
        for (i = 0; i < readers.length; ++i) {
            readers[i].close();
        }
        return returnValue;
    }

    private static int findAppropriate(Record[] items, Comparator c) {
        int index = -1;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            Record value = items[index];
            for (int i = index + 1; i < items.length; ++i) {
                if (items[i] == null || !c.relation(items[i], value)) continue;
                index = i;
                value = items[i];
            }
        }
        return index;
    }
}

