/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.ruleshandler;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import weka.classifiers.rules.ruleshandler.CChildPtr;
import weka.classifiers.rules.ruleshandler.CFpNode;
import weka.classifiers.rules.ruleshandler.CFptree;
import weka.classifiers.rules.ruleshandler.CFrequentDistinct;
import weka.classifiers.rules.ruleshandler.CFrequentItem;
import weka.classifiers.rules.ruleshandler.CHeaderTable;
import weka.classifiers.rules.ruleshandler.CItem;
import weka.classifiers.rules.ruleshandler.CItemCorpo;
import weka.classifiers.rules.ruleshandler.CItemEntry;
import weka.classifiers.rules.ruleshandler.CItemEq;
import weka.classifiers.rules.ruleshandler.CMacroItem;
import weka.classifiers.rules.ruleshandler.CMain;

public class CClasse {
    double[] macroRegoleClassi;
    double[] regoleClassi;
    static int MAX_CLASSES = 30;
    static int MAX_ITEM = 100000;
    static int RULE_MAX_LENGHT = 1300;
    static int CODA_MAX_LEN = 1300;
    int classeDesiderata;
    int maxNumItem;
    double tidSet;
    double regoleTotali;
    double genTotali;
    double maxNodi;
    double maxRec;
    double totRec;
    double maxDepth;
    double macroRegoleTotali;
    static int CONDITION_MAX_LEN = 3000;
    LinkedList<CFpNode> nodi;
    CFrequentItem node_pattern_base;
    double noditree;
    double create_node;
    StringBuffer s = new StringBuffer();

    public CClasse() {
        this.macroRegoleClassi = new double[MAX_CLASSES];
        this.regoleClassi = new double[MAX_CLASSES];
        this.nodi = new LinkedList();
    }

    public void estraiPerClasse(int len, String[] arg, int classeAttuale) {
        CFptree fp;
        CHeaderTable htab;
        CItem[] tmptab;
        int h;
        CFrequentDistinct frequentcounter = new CFrequentDistinct(0);
        CFrequentDistinct distinctcounter = new CFrequentDistinct(0);
        CMacroItem[] condition = new CMacroItem[CONDITION_MAX_LEN];
        CMacroItem[] coda = new CMacroItem[CODA_MAX_LEN];
        PrintWriter piw = null;
        this.classeDesiderata = classeAttuale;
        this.regoleTotali = 0.0;
        this.genTotali = 0.0;
        this.macroRegoleTotali = 0.0;
        this.maxNodi = 0.0;
        this.maxRec = 0.0;
        this.totRec = 0.0;
        this.maxDepth = 0.0;
        for (h = 0; h < CODA_MAX_LEN; ++h) {
            coda[h] = new CMacroItem();
        }
        for (h = 0; h < CONDITION_MAX_LEN; ++h) {
            condition[h] = new CMacroItem();
        }
        int supp_thres = (int)CMain.supp_threshold * CMain.suppClasses[this.classeDesiderata] / 100;
        if (supp_thres < 1) {
            supp_thres = 1;
        }
        if ((tmptab = this.supportCounting(arg[0], supp_thres, frequentcounter, distinctcounter)) == null) {
            System.out.println("Not create temp table\n");
            System.exit(3);
        }
        if ((htab = this.firstHeaderTableCreate(tmptab, supp_thres, frequentcounter)) == null) {
            System.out.println("Not create htable\n");
            System.exit(4);
        }
        if ((fp = this.firstFpTreeCreate(arg[0], htab, distinctcounter.freqdistinct)) == null) {
            System.out.println("Not create fp tree");
            System.exit(5);
        }
        String nomeFileUscita = new String(arg[4] + "c" + this.classeDesiderata + arg[3]);
        try {
            piw = new PrintWriter(new BufferedWriter(new FileWriter(nomeFileUscita)));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
        this.fpMine(htab, fp, condition, 1, supp_thres, piw, coda, 0, supp_thres, 0.0);
        this.macroRegoleClassi[classeAttuale] = this.macroRegoleTotali;
        this.regoleClassi[classeAttuale] = this.regoleTotali;
    }

    /*
     * Unable to fully structure code
     */
    public CItem[] supportCounting(String fileName, int threshold, CFrequentDistinct frequentcounter, CFrequentDistinct distinctcounter) {
        tmptab = new CItem[CClasse.MAX_ITEM];
        for (z = 0; z < CClasse.MAX_ITEM; ++z) {
            tmptab[z] = new CItem(CClasse.MAX_CLASSES);
        }
        n = 0;
        try {
            fis = new FileInputStream(fileName);
            di = new DataInputStream(fis);
            this.maxNumItem = 0;
            while (true) {
                for (h = 0; h < 3; ++h) {
                    bf = ByteBuffer.allocate(4);
                    for (k = 0; k < 4; ++k) {
                        b = di.readByte();
                        bf.order(ByteOrder.LITTLE_ENDIAN);
                        bf.put(b);
                    }
                    n = bf.getInt(0);
                }
                t = new int[n];
                for (f = 0; f < n; ++f) {
                    buf = ByteBuffer.allocate(4);
                    for (g = 0; g < 4; ++g) {
                        b = di.readByte();
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        buf.put(b);
                    }
                    t[f] = buf.getInt(0);
                }
                k = 0;
                while (true) {
                    if (k >= n - 1) ** continue;
                    if (tmptab[t[k] - 1].supp == 0) {
                        distinctcounter.add(1);
                        if (t[k] > this.maxNumItem) {
                            this.maxNumItem = t[k];
                        }
                    }
                    ++tmptab[t[k] - 1].supp;
                    v0 = t[n - 1] - CMain.idBaseClasse;
                    tmptab[t[k] - 1].suppClass[v0] = tmptab[t[k] - 1].suppClass[v0] + 1;
                    if (t[n - 1] - CMain.idBaseClasse == this.classeDesiderata && tmptab[t[k] - 1].suppClass[this.classeDesiderata] == threshold) {
                        frequentcounter.add(1);
                    }
                    ++k;
                }
                break;
            }
        }
        catch (EOFException eofx) {
            ++this.maxNumItem;
            return tmptab;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CHeaderTable firstHeaderTableCreate(CItem[] tmptab, int supp_thres, CFrequentDistinct frequentcounter) {
        CHeaderTable htab = new CHeaderTable(frequentcounter.freqdistinct);
        htab.frequentCount = frequentcounter.freqdistinct;
        int j = 0;
        for (int i = 0; i < this.maxNumItem; ++i) {
            if (tmptab[i].suppClass[this.classeDesiderata] < supp_thres) continue;
            CFrequentItem cfi = new CFrequentItem(MAX_CLASSES);
            cfi.itemId = i + 1;
            cfi.supp = tmptab[i].supp;
            for (int h = 0; h < MAX_CLASSES; ++h) {
                cfi.suppClass[h] = tmptab[i].suppClass[h];
            }
            htab.frequentArray[j] = cfi;
            ++j;
        }
        if (frequentcounter.freqdistinct > 0) {
            htab.quicksort(0, frequentcounter.freqdistinct - 1);
        }
        return htab;
    }

    /*
     * Unable to fully structure code
     */
    public CFptree firstFpTreeCreate(String file, CHeaderTable htab, int distinctcounter) {
        fpt = new CFptree(CClasse.MAX_CLASSES);
        n = 0;
        try {
            fis = new FileInputStream(file);
            di = new DataInputStream(fis);
            present_item = new int[distinctcounter];
            while (true) {
                for (h = 0; h < 3; ++h) {
                    bf = ByteBuffer.allocate(4);
                    for (k = 0; k < 4; ++k) {
                        b = di.readByte();
                        bf.order(ByteOrder.LITTLE_ENDIAN);
                        bf.put(b);
                    }
                    n = bf.getInt(0);
                }
                for (a = 0; a < distinctcounter - 1; ++a) {
                    present_item[a] = 0;
                }
                for (u = 0; u < n - 1; ++u) {
                    buf = ByteBuffer.allocate(4);
                    for (g = 0; g < 4; ++g) {
                        b = di.readByte();
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        buf.put(b);
                    }
                    itemid = buf.getInt(0);
                    present_item[itemid - 1] = 1;
                }
                buf2 = ByteBuffer.allocate(4);
                for (g = 0; g < 4; ++g) {
                    b = di.readByte();
                    buf2.order(ByteOrder.LITTLE_ENDIAN);
                    buf2.put(b);
                }
                itemClasse = buf2.getInt(0);
                if ((itemClasse -= CMain.idBaseClasse) < 0) {
                    System.out.println("Classe errata " + itemClasse);
                    System.exit(1);
                }
                parent = fpt.root;
                i = htab.frequentCount - 1;
                while (true) {
                    if (i < 0) ** continue;
                    if (present_item[htab.frequentArray[i].itemId - 1] == 1) {
                        present_item[htab.frequentArray[i].itemId - 1] = 0;
                        current = this.firstInsertNode(parent, htab.frequentArray[i], itemClasse, i);
                        if (current == null) {
                            return null;
                        }
                        parent = current;
                    }
                    --i;
                }
                break;
            }
        }
        catch (EOFException eofx) {
            return fpt;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CFpNode firstInsertNode(CFpNode parent, CFrequentItem htab_entry, int item_classe, int index) {
        boolean found = false;
        CChildPtr curr_elem = parent.children;
        CChildPtr prev_elem = parent.children;
        while (curr_elem != null && !found) {
            if (curr_elem.child.itemId == htab_entry.itemId) {
                found = true;
                continue;
            }
            prev_elem = curr_elem;
            curr_elem = curr_elem.next;
        }
        if (found) {
            ++curr_elem.child.local_supp;
            int n = item_classe;
            curr_elem.child.local_suppClass[n] = curr_elem.child.local_suppClass[n] + 1;
            parent = curr_elem.child;
        } else {
            CChildPtr tmp_elem = new CChildPtr(MAX_CLASSES);
            CFpNode tmp_child = tmp_elem.child;
            tmp_child.itemId = htab_entry.itemId;
            tmp_child.parent = parent;
            tmp_child.local_supp = 1;
            for (int x = 0; x < MAX_CLASSES; ++x) {
                tmp_child.local_suppClass[x] = 0;
            }
            tmp_child.local_suppClass[item_classe] = 1;
            tmp_child.next = htab_entry.head;
            if (prev_elem == null) {
                parent.children = tmp_elem;
            } else {
                prev_elem.next = tmp_elem;
            }
            htab_entry.head = tmp_child;
            htab_entry.incCounter(1);
            parent = tmp_child;
        }
        return parent;
    }

    public void fpMine(CHeaderTable htab, CFptree fptree, CMacroItem[] condition, int minedepth, int supp_thres, PrintWriter nomeFileUscita, CMacroItem[] coda, int dimcoda, int supp_cond, double noditotali) {
        CItemEntry tmptab = new CItemEntry(MAX_CLASSES);
        CItemEntry new_entry = new CItemEntry(MAX_CLASSES);
        CItemEntry prev_entry = new CItemEntry(MAX_CLASSES);
        CItemEntry curr_entry = new CItemEntry(MAX_CLASSES);
        this.totRec += 1.0;
        int frequent_count = 0;
        int t = 0;
        if (minedepth > 1) {
            dimcoda = this.accresciCoda(coda, dimcoda, htab, supp_cond);
        }
        if (fptree.branches == 1) {
            this.combineItem(htab, condition, minedepth, htab.frequentCount, nomeFileUscita, supp_thres, coda, dimcoda);
        } else {
            CFrequentItem[] freq_array = htab.frequentArray;
            for (int i = 0; i < htab.frequentCount; ++i) {
                if (freq_array[i].accorpato != 0) continue;
                if (freq_array[i].nodeLinkCounter == 0) {
                    System.err.println("Errore: freq_array[" + i + "].nodeLinkCounter \u00e8 zero!!");
                    return;
                }
                int sitem = 1;
                condition[minedepth - 1] = new CMacroItem();
                condition[minedepth - 1].vettItemId[0] = freq_array[i].itemId;
                Iterator it = freq_array[i].itemAccorpati.iterator();
                while (it.hasNext()) {
                    int tmp;
                    condition[minedepth - 1].vettItemId[sitem] = tmp = ((Integer)it.next()).intValue();
                    ++sitem;
                }
                condition[minedepth - 1].numItem = sitem;
                frequent_count = 0;
                tmptab = null;
                CHeaderTable new_htab = null;
                CFptree new_fptree = null;
                CFpNode nodelink = freq_array[i].head;
                for (int q = 0; q < freq_array[i].nodeLinkCounter; ++q) {
                    CFpNode node = nodelink.parent;
                    while (node.parent != null) {
                        for (t = i + 1; t < htab.frequentCount && freq_array[t].itemId != node.itemId; ++t) {
                        }
                        if (t < htab.frequentCount && freq_array[t].accorpato == 0) {
                            curr_entry = tmptab;
                            prev_entry = tmptab;
                            boolean found = false;
                            while (curr_entry != null && !found) {
                                if (curr_entry.itemId == node.itemId) {
                                    found = true;
                                    int oldsup = curr_entry.suppClass[this.classeDesiderata];
                                    curr_entry.supp += nodelink.local_supp;
                                    for (int u = 0; u < MAX_CLASSES; ++u) {
                                        int n = u;
                                        curr_entry.suppClass[n] = curr_entry.suppClass[n] + nodelink.local_suppClass[u];
                                    }
                                    if (oldsup >= supp_thres || curr_entry.suppClass[this.classeDesiderata] < supp_thres) continue;
                                    ++frequent_count;
                                    continue;
                                }
                                prev_entry = curr_entry;
                                curr_entry = curr_entry.next;
                            }
                            if (!found) {
                                new_entry = new CItemEntry(MAX_CLASSES);
                                new_entry.itemId = node.itemId;
                                new_entry.supp = nodelink.local_supp;
                                for (int g = 0; g < MAX_CLASSES; ++g) {
                                    new_entry.suppClass[g] = nodelink.local_suppClass[g];
                                }
                                if (new_entry.suppClass[this.classeDesiderata] >= supp_thres) {
                                    ++frequent_count;
                                }
                                if (prev_entry == null) {
                                    tmptab = new_entry;
                                } else {
                                    prev_entry.next = new_entry;
                                }
                            }
                        }
                        node = node.parent;
                    }
                    nodelink = nodelink.next;
                }
                if (frequent_count == 0) {
                    this.storeItemset(condition, minedepth, null, 0, freq_array[i], 0, 0, null, nomeFileUscita, supp_thres, coda, dimcoda);
                    continue;
                }
                new_htab = this.headerTableCreate(tmptab, supp_thres, frequent_count);
                if (new_htab == null) {
                    System.exit(1);
                }
                for (int w = 0; w < new_htab.frequentCount; ++w) {
                    int hti = 0;
                    while (freq_array[hti].itemId != new_htab.frequentArray[w].itemId) {
                        ++hti;
                    }
                    Iterator iter = freq_array[hti].itemAccorpati.iterator();
                    while (iter.hasNext()) {
                        new_htab.frequentArray[w].itemAccorpati.addFirst((Integer)iter.next());
                    }
                }
                int newdimcoda = dimcoda;
                newdimcoda = this.accresciCodaperCondition(coda, newdimcoda, new_htab, freq_array[i].supp);
                this.storeItemset(condition, minedepth, null, 0, freq_array[i], 0, 0, null, nomeFileUscita, supp_thres, coda, newdimcoda);
                this.node_pattern_base = freq_array[i];
                new_fptree = this.fptCreate(new_htab);
                if (new_fptree == null) {
                    System.exit(1);
                }
                freq_array[i] = this.node_pattern_base;
                if ((noditotali += this.noditree) > this.maxNodi) {
                    this.maxNodi = noditotali;
                    this.maxRec = minedepth;
                }
                this.fpMine(new_htab, new_fptree, condition, minedepth + 1, supp_thres, nomeFileUscita, coda, dimcoda, freq_array[i].supp, noditotali);
            }
        }
    }

    public int accresciCoda(CMacroItem[] coda, int dimcoda, CHeaderTable htab, int supp_cond) {
        int ht;
        CFrequentItem[] freq_array = htab.frequentArray;
        for (ht = 0; ht < htab.frequentCount; ++ht) {
            if (freq_array[ht].supp != supp_cond) continue;
            freq_array[ht].accorpato = 1;
            int sitem = 1;
            coda[dimcoda].vettItemId[0] = freq_array[ht].itemId;
            Iterator it = freq_array[ht].itemAccorpati.iterator();
            while (it.hasNext()) {
                coda[dimcoda].vettItemId[sitem] = (Integer)it.next();
                ++sitem;
            }
            coda[dimcoda].numItem = sitem;
            ++dimcoda;
        }
        int newfreqcounter = 0;
        for (ht = 0; ht < htab.frequentCount; ++ht) {
            if (freq_array[ht].accorpato != 0) continue;
            freq_array[newfreqcounter] = freq_array[ht];
            ++newfreqcounter;
        }
        htab.setFrequent(newfreqcounter);
        return dimcoda;
    }

    public void creaMacroItem(CHeaderTable htab, CFptree fptree) {
        int ih;
        CItemEq[] possibili_item_eq = new CItemEq[this.maxNumItem];
        for (int j = 0; j < this.maxNumItem; ++j) {
            possibili_item_eq[j] = new CItemEq();
        }
        CFrequentItem[] freq_array = htab.frequentArray;
        for (ih = htab.frequentCount - 1; ih >= 0; --ih) {
            freq_array[ih].accorpato = 0;
        }
        for (int rif = htab.frequentCount - 1; rif > 0; --rif) {
            int dim_possibili_item_eq = 0;
            if (freq_array[rif].accorpato != 0) continue;
            for (ih = rif - 1; ih > 0 && freq_array[ih].supp == freq_array[rif].supp; --ih) {
                if (freq_array[ih].accorpato != 0) continue;
                boolean uguali = true;
                for (int c = 0; c < MAX_CLASSES && uguali; ++c) {
                    if (freq_array[ih].suppClass[c] == freq_array[rif].suppClass[c]) continue;
                    uguali = false;
                }
                if (!uguali) continue;
                possibili_item_eq[dim_possibili_item_eq].pos = ih;
                possibili_item_eq[dim_possibili_item_eq].flag = 0;
                ++dim_possibili_item_eq;
            }
            if (dim_possibili_item_eq <= 0) continue;
            this.equivalenti(htab, fptree, rif, possibili_item_eq, dim_possibili_item_eq);
            for (int p = 0; p < dim_possibili_item_eq; ++p) {
                if (possibili_item_eq[p].flag != 0) continue;
                freq_array[possibili_item_eq[p].pos].accorpato = 1;
                int itemacc = freq_array[possibili_item_eq[p].pos].itemId;
                freq_array[rif].itemAccorpati.addFirst(itemacc);
                Iterator it = freq_array[possibili_item_eq[p].pos].itemAccorpati.iterator();
                while (it.hasNext()) {
                    itemacc = (Integer)it.next();
                    freq_array[rif].itemAccorpati.addFirst(itemacc);
                }
            }
        }
        freq_array = htab.frequentArray;
        int newFreqcounter = 0;
        for (int ht = 0; ht < htab.frequentCount; ++ht) {
            if (freq_array[ht].accorpato == 0) {
                freq_array[newFreqcounter] = freq_array[ht];
                ++newFreqcounter;
                continue;
            }
            freq_array[ht].itemAccorpati.clear();
        }
        htab.setFrequent(newFreqcounter);
    }

    public void equivalenti(CHeaderTable htab, CFptree fptree, int pos_item_di_rif, CItemEq[] possibili_item_eq, int dim_possibili_item_eq) {
        CItem[] itempresenti = new CItem[this.maxNumItem];
        for (int k = 0; k < this.maxNumItem; ++k) {
            itempresenti[k] = new CItem(MAX_CLASSES);
        }
        boolean esistono_candidati = true;
        CFpNode nodelink = htab.frequentArray[pos_item_di_rif].head;
        int livello = pos_item_di_rif - possibili_item_eq[dim_possibili_item_eq - 1].pos;
        while (nodelink != null && esistono_candidati) {
            CChildPtr curr_elem = nodelink.children;
            while (curr_elem != null) {
                this.aggiornaPresenze(curr_elem, itempresenti, livello);
                curr_elem = curr_elem.next;
            }
            esistono_candidati = false;
            for (int i = 0; i < dim_possibili_item_eq; ++i) {
                if (possibili_item_eq[i].flag == 0 && itempresenti[htab.frequentArray[possibili_item_eq[i].pos].itemId].supp == nodelink.local_supp) {
                    int c;
                    for (c = 0; c < MAX_CLASSES && itempresenti[htab.frequentArray[possibili_item_eq[i].pos].itemId].suppClass[c] == nodelink.local_suppClass[c]; ++c) {
                    }
                    if (c == MAX_CLASSES) {
                        esistono_candidati = true;
                        continue;
                    }
                    possibili_item_eq[i].flag = -1;
                    continue;
                }
                possibili_item_eq[i].flag = -1;
            }
            nodelink = nodelink.next;
        }
    }

    public void aggiornaPresenze(CChildPtr curr_elem, CItem[] itempresenti, int livello) {
        CFpNode node = curr_elem.child;
        itempresenti[node.itemId].supp += node.local_supp;
        for (int c = 0; c < MAX_CLASSES; ++c) {
            itempresenti[node.itemId].suppClass[c] = itempresenti[node.itemId].suppClass[c] + node.local_suppClass[c];
        }
        CChildPtr child = node.children;
        while (child != null && livello > 1) {
            this.aggiornaPresenze(child, itempresenti, livello - 1);
            child = child.next;
        }
    }

    public void combineItem(CHeaderTable htab, CMacroItem[] condition, int minedepth, int comb_size, PrintWriter file, int supp_thres, CMacroItem[] coda, int dimcoda) {
        CMacroItem[] comb = new CMacroItem[comb_size];
        for (int t = 0; t < comb_size; ++t) {
            comb[t] = new CMacroItem();
        }
        if (htab == null) {
            return;
        }
        if (htab.frequentCount == 0) {
            return;
        }
        CFrequentItem[] freq_array = htab.frequentArray;
        int cl = 0;
        for (int ht = htab.frequentCount - 1; ht >= 0; --ht) {
            int pos;
            int sitem = 1;
            condition[minedepth - 1].vettItemId[0] = freq_array[ht].itemId;
            for (pos = 0; pos != freq_array[ht].itemAccorpati.size(); ++pos) {
                condition[minedepth - 1].vettItemId[sitem] = freq_array[ht].itemAccorpati.get(pos);
                ++sitem;
            }
            condition[minedepth - 1].numItem = sitem;
            this.storeItemset(condition, minedepth, comb, cl, freq_array[ht], 0, 0, null, file, supp_thres, coda, dimcoda);
            sitem = 1;
            comb[cl].vettItemId[0] = freq_array[ht].itemId;
            for (pos = 0; pos != freq_array[ht].itemAccorpati.size(); ++pos) {
                comb[cl].vettItemId[sitem] = freq_array[ht].itemAccorpati.get(pos);
                ++sitem;
            }
            comb[cl].numItem = sitem;
            ++cl;
        }
    }

    public void storeItemset(CMacroItem[] condition, int condition_lenght, CMacroItem[] comb, int comb_size, CFrequentItem items, int position, int store_level, CMacroItem[] itemset, PrintWriter piw, int supp_thres, CMacroItem[] coda, int dimcoda) {
        int start = 0;
        CItemCorpo cit = new CItemCorpo(RULE_MAX_LENGHT);
        StringBuffer corpo = new StringBuffer();
        StringBuffer singolo_item = new StringBuffer();
        StringBuffer regola_max = new StringBuffer();
        int itemc = 0;
        if (itemset == null) {
            double gen_rapr = 1.0;
            double regole_rappresentate = 1.0;
            corpo.append("{");
            for (int i = 0; i < condition_lenght - 1; ++i) {
                corpo.append("(");
                for (int j = 0; j < condition[i].numItem - 1; ++j) {
                    corpo.append(condition[i].vettItemId[j] + ",");
                    cit.item_corpo[itemc] = condition[i].vettItemId[j];
                    ++itemc;
                }
                corpo.append(condition[i].vettItemId[condition[i].numItem - 1] + "),");
                cit.item_corpo[itemc] = condition[i].vettItemId[condition[i].numItem - 1];
                ++itemc;
                regole_rappresentate *= this.combinazioni(condition[i].numItem);
                gen_rapr *= (double)condition[i].numItem;
            }
            corpo.append("(");
            for (int k = 0; k < condition[condition_lenght - 1].numItem - 1; ++k) {
                corpo.append(condition[condition_lenght - 1].vettItemId[k] + ",");
                cit.item_corpo[itemc] = condition[condition_lenght - 1].vettItemId[k];
                ++itemc;
            }
            corpo.append(condition[condition_lenght - 1].vettItemId[condition[condition_lenght - 1].numItem - 1] + ")}");
            cit.item_corpo[itemc] = condition[condition_lenght - 1].vettItemId[condition[condition_lenght - 1].numItem - 1];
            ++itemc;
            regole_rappresentate *= this.combinazioni(condition[condition_lenght - 1].numItem);
            gen_rapr *= (double)condition[condition_lenght - 1].numItem;
            if (dimcoda > 0) {
                for (int h = 0; h < dimcoda - 1; ++h) {
                    corpo.append("(");
                    for (int g = 0; g < coda[h].numItem - 1; ++g) {
                        corpo.append(coda[h].vettItemId[g] + ",");
                        cit.item_corpo[itemc] = coda[h].vettItemId[g];
                        ++itemc;
                    }
                    corpo.append(coda[h].vettItemId[coda[h].numItem - 1] + "),");
                    cit.item_corpo[itemc] = coda[h].vettItemId[coda[h].numItem - 1];
                    ++itemc;
                    regole_rappresentate *= this.combinazioni(coda[h].numItem) + 1.0;
                }
                corpo.append("(");
                for (int l = 0; l < coda[dimcoda - 1].numItem - 1; ++l) {
                    corpo.append(coda[dimcoda - 1].vettItemId[l] + ",");
                    cit.item_corpo[itemc] = coda[dimcoda - 1].vettItemId[l];
                    ++itemc;
                }
                corpo.append(coda[dimcoda - 1].vettItemId[coda[dimcoda - 1].numItem - 1] + ")");
                cit.item_corpo[itemc] = coda[dimcoda - 1].vettItemId[coda[dimcoda - 1].numItem - 1];
                ++itemc;
                regole_rappresentate *= this.combinazioni(coda[dimcoda - 1].numItem) + 1.0;
            } else {
                corpo.append("()");
            }
            cit.ordina(0, itemc - 1);
            for (int ic = 0; ic < itemc; ++ic) {
                regola_max.append(cit.item_corpo[ic] + " ");
            }
            if (items.suppClass[this.classeDesiderata] >= supp_thres && 100.0 * (double)items.suppClass[this.classeDesiderata] / (double)items.supp >= CMain.conf_threshold) {
                DecimalFormat format = new DecimalFormat("###0.00", new DecimalFormatSymbols(new Locale("EN")));
                FieldPosition field = new FieldPosition(0);
                format.format(100.0 * (double)items.suppClass[this.classeDesiderata] / (double)items.supp, this.s, field);
                piw.append(corpo + " -> " + (CMain.idBaseClasse + this.classeDesiderata) + " " + items.suppClass[this.classeDesiderata] + " " + this.s + " " + itemc + " " + regola_max + "\n");
                piw.flush();
                corpo.delete(0, corpo.length());
                regola_max.delete(0, regola_max.length());
                this.s.delete(0, this.s.length());
                this.regoleTotali += regole_rappresentate;
                this.macroRegoleTotali += 1.0;
            }
            if (comb_size != 0) {
                itemset = new CMacroItem[comb_size];
                for (int q = 0; q < comb_size; ++q) {
                    itemset[q] = new CMacroItem();
                }
                this.storeItemset(condition, condition_lenght, comb, comb_size, items, 0, 1, itemset, piw, supp_thres, coda, dimcoda);
            }
        } else {
            start = position;
            for (position = comb_size - 1; position >= start; --position) {
                itemset[store_level - 1] = comb[position];
                double regole_rappresentate = 1.0;
                double gen_rapr = 1.0;
                corpo.append("{");
                for (int i = 0; i < store_level; ++i) {
                    corpo.append("(");
                    for (int j = 0; j < itemset[i].numItem - 1; ++j) {
                        corpo.append(itemset[i].vettItemId[j] + ",");
                        cit.item_corpo[itemc] = itemset[i].vettItemId[j];
                        ++itemc;
                    }
                    corpo.append(itemset[i].vettItemId[itemset[i].numItem - 1] + "),");
                    cit.item_corpo[itemc] = itemset[i].vettItemId[itemset[i].numItem - 1];
                    ++itemc;
                    regole_rappresentate *= this.combinazioni(itemset[i].numItem);
                    gen_rapr *= (double)itemset[i].numItem;
                }
                for (int k = 0; k < condition_lenght - 1; ++k) {
                    corpo.append("(");
                    for (int c = 0; c < condition[k].numItem - 1; ++c) {
                        corpo.append(condition[k].vettItemId[c] + ",");
                        cit.item_corpo[itemc] = condition[k].vettItemId[c];
                        ++itemc;
                    }
                    corpo.append(condition[k].vettItemId[condition[k].numItem - 1] + "),");
                    cit.item_corpo[itemc] = condition[k].vettItemId[condition[k].numItem - 1];
                    ++itemc;
                    regole_rappresentate *= this.combinazioni(condition[k].numItem);
                    gen_rapr *= (double)condition[k].numItem;
                }
                corpo.append("(");
                for (int e = 0; e < condition[condition_lenght - 1].numItem - 1; ++e) {
                    corpo.append(condition[condition_lenght - 1].vettItemId[e] + ",");
                    cit.item_corpo[itemc] = condition[condition_lenght - 1].vettItemId[e];
                    ++itemc;
                }
                corpo.append(condition[condition_lenght - 1].vettItemId[condition[condition_lenght - 1].numItem - 1] + ")}");
                cit.item_corpo[itemc] = condition[condition_lenght - 1].vettItemId[condition[condition_lenght - 1].numItem - 1];
                ++itemc;
                regole_rappresentate *= this.combinazioni(condition[condition_lenght - 1].numItem);
                gen_rapr *= (double)condition[condition_lenght - 1].numItem;
                if (dimcoda > 0) {
                    for (int o = 0; o < dimcoda - 1; ++o) {
                        corpo.append("(");
                        for (int u = 0; u < coda[o].numItem - 1; ++u) {
                            corpo.append(coda[o].vettItemId[u] + ",");
                            cit.item_corpo[itemc] = coda[o].vettItemId[u];
                            ++itemc;
                        }
                        corpo.append(coda[o].vettItemId[coda[o].numItem - 1] + "),");
                        cit.item_corpo[itemc] = coda[o].vettItemId[coda[o].numItem - 1];
                        ++itemc;
                        regole_rappresentate *= this.combinazioni(coda[o].numItem) + 1.0;
                    }
                    corpo.append("(");
                    for (int a = 0; a < coda[dimcoda - 1].numItem - 1; ++a) {
                        corpo.append(coda[dimcoda - 1].vettItemId[a] + ",");
                        cit.item_corpo[itemc] = coda[dimcoda - 1].vettItemId[a];
                        ++itemc;
                    }
                    corpo.append(coda[dimcoda - 1].vettItemId[coda[dimcoda - 1].numItem - 1] + ")");
                    cit.item_corpo[itemc] = coda[dimcoda - 1].vettItemId[coda[dimcoda - 1].numItem - 1];
                    ++itemc;
                    regole_rappresentate *= this.combinazioni(coda[dimcoda - 1].numItem) + 1.0;
                } else {
                    corpo.append("()");
                }
                cit.ordina(0, itemc - 1);
                for (int ic = 0; ic < itemc; ++ic) {
                    singolo_item.append(cit.item_corpo[ic] + " ");
                }
                if (items.suppClass[this.classeDesiderata] >= supp_thres && 100.0 * (double)items.suppClass[this.classeDesiderata] / (double)items.supp >= CMain.conf_threshold) {
                    DecimalFormat format = new DecimalFormat("###0.00", new DecimalFormatSymbols(new Locale("EN")));
                    FieldPosition field = new FieldPosition(0);
                    format.format(100.0 * (double)items.suppClass[this.classeDesiderata] / (double)items.supp, this.s, field);
                    piw.append(corpo + " -> " + (CMain.idBaseClasse + this.classeDesiderata) + " " + items.suppClass[this.classeDesiderata] + " " + this.s + " " + itemc + " " + singolo_item + "\n");
                    piw.flush();
                    corpo.delete(0, corpo.length());
                    singolo_item.delete(0, singolo_item.length());
                    this.s.delete(0, this.s.length());
                    this.regoleTotali += regole_rappresentate;
                    this.macroRegoleTotali += 1.0;
                }
                this.storeItemset(condition, condition_lenght, comb, comb_size, items, position + 1, store_level + 1, itemset, piw, supp_thres, coda, dimcoda);
            }
        }
    }

    public CHeaderTable headerTableCreate(CItemEntry tmptab, int supp_thres, int frequent_count) {
        CHeaderTable htab = new CHeaderTable(frequent_count);
        htab.frequentCount = frequent_count;
        if (frequent_count != 0) {
            CItemEntry itemd = tmptab;
            int i = 0;
            while (itemd != null) {
                if (itemd.suppClass[this.classeDesiderata] >= supp_thres) {
                    htab.frequentArray[i].itemId = itemd.itemId;
                    htab.frequentArray[i].supp = itemd.supp;
                    htab.frequentArray[i].accorpato = 0;
                    htab.frequentArray[i].itemAccorpati = new LinkedList();
                    for (int b = 0; b < MAX_CLASSES; ++b) {
                        htab.frequentArray[i].suppClass[b] = itemd.suppClass[b];
                    }
                    htab.frequentArray[i].nodeLinkCounter = 0;
                    ++i;
                }
                itemd = itemd.next;
            }
            htab.quicksort(0, frequent_count - 1);
        }
        return htab;
    }

    public int accresciCodaperCondition(CMacroItem[] coda, int dimcoda, CHeaderTable htab, int suppcondition) {
        CFrequentItem[] freq_array = htab.frequentArray;
        for (int ht = 0; ht < htab.frequentCount; ++ht) {
            if (freq_array[ht].supp != suppcondition) continue;
            int sitem = 1;
            coda[dimcoda].vettItemId[0] = freq_array[ht].itemId;
            Iterator it = freq_array[ht].itemAccorpati.iterator();
            while (it.hasNext()) {
                coda[dimcoda].vettItemId[sitem] = (Integer)it.next();
                ++sitem;
            }
            coda[dimcoda].numItem = sitem;
            ++dimcoda;
        }
        return dimcoda;
    }

    public CFptree fptCreate(CHeaderTable htab) {
        CItem local = new CItem(MAX_CLASSES);
        this.noditree = 0.0;
        CFptree fp = new CFptree(MAX_CLASSES);
        fp.branches = 0;
        this.noditree += 1.0;
        CFrequentItem[] freq_array = htab.frequentArray;
        CFpNode nodelink = this.node_pattern_base.head;
        int nlcounter = this.node_pattern_base.nodeLinkCounter;
        for (int inl = 0; inl < nlcounter; ++inl) {
            local.supp = nodelink.local_supp;
            for (int c = 0; c < MAX_CLASSES; ++c) {
                local.suppClass[c] = nodelink.local_suppClass[c];
            }
            CFpNode parent = fp.root;
            for (int ih = htab.frequentCount - 1; ih >= 0; --ih) {
                CFpNode pattern_node = nodelink.parent;
                boolean found = false;
                while (!found && pattern_node != null) {
                    if (pattern_node.itemId == freq_array[ih].itemId) {
                        found = true;
                        continue;
                    }
                    pattern_node = pattern_node.parent;
                }
                if (!found) continue;
                CFpNode current = this.insertNode(parent, freq_array[ih], local, fp);
                if (current == null) {
                    return null;
                }
                this.noditree += this.create_node;
                parent = current;
            }
            nodelink = nodelink.next;
        }
        return fp;
    }

    public CFpNode insertNode(CFpNode parent, CFrequentItem header_table_entry, CItem local, CFptree fp) {
        boolean found = false;
        this.create_node = 0.0;
        CChildPtr curr_elem = parent.children;
        CChildPtr prev_elem = parent.children;
        while (curr_elem != null && !found) {
            if (curr_elem.child.itemId == header_table_entry.itemId) {
                found = true;
                continue;
            }
            prev_elem = curr_elem;
            curr_elem = curr_elem.next;
        }
        if (found) {
            curr_elem.child.local_supp += local.supp;
            for (int c = 0; c < MAX_CLASSES; ++c) {
                int n = c;
                curr_elem.child.local_suppClass[n] = curr_elem.child.local_suppClass[n] + local.suppClass[c];
            }
            parent = curr_elem.child;
        } else {
            if (parent.children == null && parent.parent == null) {
                fp.setBranches(1);
            } else if (parent.children != null) {
                fp.setBranches(2);
            }
            CChildPtr tmp_elem = new CChildPtr(MAX_CLASSES);
            this.create_node = 1.0;
            CFpNode tmp_child = tmp_elem.child;
            tmp_child.itemId = header_table_entry.itemId;
            tmp_child.parent = parent;
            tmp_child.local_supp = local.supp;
            for (int h = 0; h < MAX_CLASSES; ++h) {
                tmp_child.local_suppClass[h] = local.suppClass[h];
            }
            tmp_child.next = header_table_entry.head;
            if (prev_elem == null) {
                parent.children = tmp_elem;
            } else {
                prev_elem.next = tmp_elem;
            }
            header_table_entry.incCounter(1);
            header_table_entry.head = tmp_child;
            parent = tmp_child;
        }
        return parent;
    }

    public double combinazioni(int numero) {
        if (numero < 1) {
            return 0.0;
        }
        double totale = 1.0;
        for (int i = 0; i < numero; ++i) {
            totale *= 2.0;
        }
        return totale - 1.0;
    }
}

