/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import weka.classifiers.rules.BinaryFile;
import weka.core.Instances;

public class L3implementation
implements Serializable {
    int CLASS_NUM = 200;
    String[] class_labels;
    public int num_features;
    public int num_samples;
    public int num_classes;

    public void get_header(String dataset_name, String format) {
        try {
            if (format.equalsIgnoreCase("arff")) {
                FileReader file = new FileReader(dataset_name);
                BufferedReader buff = new BufferedReader(file);
                boolean eof = false;
                boolean start_count_samples = false;
                String line = null;
                String s = null;
                String s2 = null;
                int count_genes = 0;
                int count_classes = 0;
                int count_samples = 0;
                while (!eof) {
                    line = buff.readLine();
                    if (line == null) {
                        eof = true;
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(line);
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s.equalsIgnoreCase("@attribute")) {
                            ++count_genes;
                        }
                        if (s.indexOf("{") != -1) {
                            StringTokenizer st2 = new StringTokenizer(s, ",");
                            while (st2.hasMoreTokens()) {
                                s2 = st2.nextToken();
                                ++count_classes;
                            }
                        }
                        if (start_count_samples) {
                            ++count_samples;
                        }
                        if (!s.equalsIgnoreCase("@data")) continue;
                        start_count_samples = true;
                    }
                }
                this.num_features = count_genes - 1;
                this.num_samples = count_samples;
            } else {
                FileReader file = new FileReader(dataset_name);
                BufferedReader buff = new BufferedReader(file);
                boolean eof = false;
                boolean start_count_samples = false;
                String line = null;
                String s = null;
                Object s2 = null;
                boolean firstline = true;
                int count_features = 0;
                int count_samples = 0;
                boolean count_classes = false;
                while (!eof) {
                    line = buff.readLine();
                    if (line == null) {
                        eof = true;
                        continue;
                    }
                    if (firstline) {
                        StringTokenizer st = new StringTokenizer(line, ",");
                        while (st.hasMoreTokens()) {
                            s = st.nextToken();
                            ++count_features;
                        }
                        --count_features;
                        continue;
                    }
                    ++count_samples;
                }
                this.num_features = count_features;
                this.num_samples = count_samples;
            }
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public String[] read_Class_Labels_not_well_formed(String dataset_name, String format) {
        String[] temp = new String[100];
        boolean eof = false;
        boolean start = false;
        String line = null;
        Object line2 = null;
        int count_features = 0;
        this.num_classes = 0;
        try {
            String s2;
            int i;
            boolean found;
            String s;
            StringTokenizer st;
            FileReader file = new FileReader(dataset_name);
            BufferedReader buff = new BufferedReader(file);
            if (format.equalsIgnoreCase("Arff")) {
                while (!eof) {
                    line = buff.readLine();
                    if (line == null) {
                        eof = true;
                    } else {
                        if (start) {
                            st = new StringTokenizer(line, ",");
                            while (st.hasMoreTokens()) {
                                s = st.nextToken();
                                if (count_features == this.num_features) {
                                    found = false;
                                    for (i = 0; i < this.num_classes; ++i) {
                                        if (!temp[i].equalsIgnoreCase(s)) continue;
                                        found = true;
                                    }
                                    if (!found) {
                                        ++this.num_classes;
                                        temp[this.num_classes - 1] = new String(s);
                                    }
                                }
                                ++count_features;
                            }
                        }
                        if (line.equalsIgnoreCase("@data")) {
                            start = true;
                        }
                    }
                    count_features = 0;
                }
            }
            if (format.equalsIgnoreCase("csv")) {
                line = buff.readLine();
                if (line == null) {
                    return null;
                }
                this.num_features = -1;
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    s2 = st.nextToken();
                    ++this.num_features;
                }
                while (!eof) {
                    line = buff.readLine();
                    if (line == null) {
                        eof = true;
                    } else {
                        st = new StringTokenizer(line, ",");
                        while (st.hasMoreTokens()) {
                            s = st.nextToken();
                            if (count_features == this.num_features) {
                                found = false;
                                for (i = 0; i < this.num_classes; ++i) {
                                    if (!temp[i].equalsIgnoreCase(s)) continue;
                                    found = true;
                                }
                                if (!found) {
                                    ++this.num_classes;
                                    temp[this.num_classes - 1] = new String(s);
                                }
                            }
                            ++count_features;
                        }
                    }
                    count_features = 0;
                }
            }
            if (format.equalsIgnoreCase("data")) {
                line = buff.readLine();
                if (line == null) {
                    return null;
                }
                this.num_features = -1;
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    s2 = st.nextToken();
                    ++this.num_features;
                }
                file.close();
                buff.close();
                file = new FileReader(dataset_name);
                buff = new BufferedReader(file);
                while (!eof) {
                    line = buff.readLine();
                    if (line == null) {
                        eof = true;
                    } else {
                        st = new StringTokenizer(line, ",");
                        while (st.hasMoreTokens()) {
                            s = st.nextToken();
                            if (count_features == this.num_features) {
                                found = false;
                                for (i = 0; i < this.num_classes; ++i) {
                                    if (!temp[i].equalsIgnoreCase(s)) continue;
                                    found = true;
                                }
                                if (!found) {
                                    ++this.num_classes;
                                    temp[this.num_classes - 1] = new String(s);
                                }
                            }
                            ++count_features;
                        }
                    }
                    count_features = 0;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.class_labels = new String[this.num_classes];
        for (int i = 0; i < this.num_classes; ++i) {
            this.class_labels[i] = new String(temp[i]);
        }
        return this.class_labels;
    }

    String[] read_Class_Labels_well_formed(String dataset_name, String format) {
        this.class_labels = new String[this.num_classes];
        try {
            if (format.equalsIgnoreCase("arff")) {
                FileReader file = new FileReader(dataset_name);
                BufferedReader buff = new BufferedReader(file);
                boolean eof = false;
                boolean start_count_samples = false;
                String line = null;
                String s = null;
                String s2 = null;
                int count_genes = 0;
                int count_classes = 0;
                boolean count_samples = false;
                while (!eof) {
                    line = buff.readLine();
                    if (line == null) {
                        eof = true;
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(line);
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s.equalsIgnoreCase("@attribute")) {
                            ++count_genes;
                        }
                        if (s.indexOf("{") == -1) continue;
                        StringTokenizer st2 = new StringTokenizer(s, ",");
                        while (st2.hasMoreTokens()) {
                            s2 = st2.nextToken();
                            if (s2.indexOf("{") != -1) {
                                s2 = s2.substring(s2.indexOf("{") + 1, s2.length());
                            }
                            if (s2.indexOf("}") != -1) {
                                s2 = s2.substring(0, s2.indexOf("}"));
                            }
                            this.class_labels[count_classes] = new String(s2);
                            ++count_classes;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.getMessage();
        }
        return this.class_labels;
    }

    public Hashtable creabin(String filename, int label, String[] class_labels, Hashtable hash, String class_path, String bin_name) {
        int endian = 2;
        boolean signed = false;
        boolean eof = false;
        int j = 0;
        FileWriter cl_file = null;
        boolean start = false;
        int attrib_counter = 0;
        String line2 = null;
        Object myStr2 = null;
        int current_value = 0;
        long t_id = 0L;
        long c_id = 0L;
        try {
            FileReader file_rd = new FileReader(filename);
            BufferedReader buff_rd = new BufferedReader(file_rd);
            RandomAccessFile file = new RandomAccessFile(bin_name, "rw");
            BinaryFile binFile = new BinaryFile(file);
            try {
                binFile.setEndian((short)2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            binFile.setSigned(false);
            if (label == 1) {
                cl_file = new FileWriter(class_path);
                cl_file.write(Integer.toString(this.CLASS_NUM) + "\n");
                for (int i = 0; i < this.num_classes; ++i) {
                    cl_file.write(class_labels[i] + "\n");
                }
                cl_file.close();
            }
            while (!eof) {
                line2 = buff_rd.readLine();
                if (line2 == null) {
                    eof = true;
                } else {
                    if (start) {
                        StringTokenizer st = new StringTokenizer(line2, ",");
                        binFile.writeDWord(t_id);
                        binFile.writeDWord(c_id);
                        ++t_id;
                        ++c_id;
                        binFile.writeDWord(this.num_features + 1);
                        while (st.hasMoreTokens()) {
                            String s = st.nextToken();
                            if (attrib_counter == this.num_features && s != null) {
                                for (j = 0; j < this.num_classes && !class_labels[j].equals(s); ++j) {
                                }
                                binFile.writeDWord(this.CLASS_NUM + j);
                            } else if (s != null) {
                                String myStr = "Attr" + attrib_counter + "Value" + s;
                                Integer n = (Integer)hash.get(myStr);
                                if (n != null) {
                                    binFile.writeDWord(n.longValue());
                                } else {
                                    hash.put(myStr, new Integer(++current_value));
                                    binFile.writeDWord(current_value);
                                }
                            }
                            ++attrib_counter;
                        }
                    }
                    if (line2.equalsIgnoreCase("@data")) {
                        start = true;
                    }
                }
                attrib_counter = 0;
            }
            buff_rd.close();
            file_rd.close();
            binFile = null;
            file.close();
        }
        catch (IOException e) {
            e.getMessage();
        }
        return hash;
    }

    public void leggiDWordbin(String filename) {
        int endian = 2;
        boolean signed = false;
        try {
            RandomAccessFile file = new RandomAccessFile(filename, "r");
            BinaryFile binFile = new BinaryFile(file);
            binFile.setEndian((short)2);
            binFile.setSigned(false);
            while (true) {
                long item;
                long tid = binFile.readDWord();
                long cid = binFile.readDWord();
                long numItems = binFile.readDWord();
                for (long i = 0L; i < numItems - 1L; ++i) {
                    item = binFile.readDWord();
                }
                item = binFile.readDWord();
            }
        }
        catch (Exception e) {
            System.out.println("**Error: " + e.getMessage());
            return;
        }
    }

    public void leggiWordbin(String filename) {
        int endian = 2;
        boolean signed = false;
        try {
            RandomAccessFile file = new RandomAccessFile(filename, "r");
            BinaryFile binFile = new BinaryFile(file);
            binFile.setEndian((short)2);
            binFile.setSigned(false);
            while (true) {
                int item;
                int tid = binFile.readWord();
                int cid = binFile.readWord();
                int numItems = binFile.readWord();
                for (long i = 0L; i < (long)(numItems - 1); ++i) {
                    item = binFile.readWord();
                }
                item = binFile.readWord();
            }
        }
        catch (Exception e) {
            System.out.println("**Error: " + e.getMessage());
            return;
        }
    }

    public void readbin(String filename) {
        try {
            FileInputStream file = new FileInputStream(filename);
            boolean eof = false;
            int count = 0;
            while (!eof) {
                int input = file.read();
                if (input == -1) {
                    eof = true;
                    continue;
                }
                ++count;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String create_arff_from_data(String dataset, String path_name) {
        String arff_filename = path_name + "dataset_converted.Arff";
        try {
            FileReader file_rd = new FileReader(dataset);
            BufferedReader buff_rd = new BufferedReader(file_rd);
            String line2 = buff_rd.readLine();
            StringTokenizer st = new StringTokenizer(line2, ",");
            int attributes = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                ++attributes;
            }
            FileWriter fw = new FileWriter(arff_filename);
            fw.write("@relation Arff_dataset\n\n");
            for (int counter = 1; counter < attributes + 1; ++counter) {
                if (counter != attributes) {
                    fw.write("@attribute attr" + counter + " numeric" + "\n");
                    continue;
                }
                fw.write("@attribute class {");
                for (int i = 0; i < this.class_labels.length; ++i) {
                    if (i != this.class_labels.length - 1) {
                        fw.write(this.class_labels[i] + ",");
                        continue;
                    }
                    fw.write(this.class_labels[i] + "}" + "\n");
                }
            }
            fw.write("\n@data");
            buff_rd.close();
            file_rd.close();
            boolean eof = false;
            file_rd = new FileReader(dataset);
            buff_rd = new BufferedReader(file_rd);
            while (!eof) {
                line2 = buff_rd.readLine();
                if (line2 == null) {
                    eof = true;
                    continue;
                }
                fw.write("\n");
                fw.write(line2);
            }
            fw.close();
            buff_rd.close();
            file_rd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return arff_filename;
    }

    String create_arff_from_csv(String dataset, String pathname) {
        String arff_filename = null;
        String conversion_path = null;
        try {
            FileReader file_rd = new FileReader(dataset);
            BufferedReader buff_rd = new BufferedReader(file_rd);
            String line2 = buff_rd.readLine();
            StringTokenizer st = new StringTokenizer(line2, ",");
            int attributes = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                ++attributes;
            }
            arff_filename = dataset.substring(dataset.lastIndexOf("/") + 1, dataset.lastIndexOf("."));
            conversion_path = pathname + arff_filename + ".Arff";
            FileWriter fw = new FileWriter(conversion_path);
            fw.write("@relation Arff_dataset\n\n");
            for (int counter = 1; counter < attributes + 1; ++counter) {
                if (counter != attributes) {
                    fw.write("@attribute " + counter + " string" + "\n");
                    continue;
                }
                fw.write("@attribute class string\n");
            }
            fw.write("@data");
            boolean eof = false;
            while (!eof) {
                line2 = buff_rd.readLine();
                if (line2 == null) {
                    eof = true;
                    continue;
                }
                fw.write("\n");
                fw.write(line2);
            }
            fw.close();
            buff_rd.close();
            file_rd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return conversion_path;
    }

    void converti_in_numerico(String dataset, String numerico_path, String format) {
        boolean eof = false;
        boolean j = false;
        Object cl_file = null;
        boolean start = false;
        int attrib_counter = 0;
        boolean sample_index = false;
        int feature = -1;
        String line2 = null;
        Object myStr2 = null;
        int current_value = 0;
        int current_class_value = 0;
        Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
        try {
            Integer n;
            String myStr;
            String s;
            StringTokenizer st;
            FileReader file_rd = new FileReader(dataset);
            BufferedReader buff_rd = new BufferedReader(file_rd);
            FileWriter fw = new FileWriter(numerico_path);
            if (format.equalsIgnoreCase("Arff")) {
                while (!eof) {
                    line2 = buff_rd.readLine();
                    if (line2 == null) {
                        eof = true;
                    } else {
                        if (start) {
                            st = new StringTokenizer(line2, ",");
                            while (st.hasMoreTokens()) {
                                s = st.nextToken();
                                if (attrib_counter == feature && s != null) {
                                    myStr = "Attr" + attrib_counter + "Value" + s;
                                    n = (Integer)hash.get(myStr);
                                    if (n != null) {
                                        fw.write(n + "\n");
                                    } else {
                                        hash.put(myStr, new Integer(++current_class_value));
                                        fw.write(current_class_value + "\n");
                                    }
                                } else if (s != null) {
                                    myStr = "Attr" + attrib_counter + "Value" + s;
                                    n = (Integer)hash.get(myStr);
                                    if (n != null) {
                                        fw.write(n + ",");
                                    } else {
                                        hash.put(myStr, new Integer(++current_value));
                                        fw.write(current_value + ",");
                                    }
                                }
                                ++attrib_counter;
                            }
                        } else {
                            fw.write(line2 + "\n");
                            if (line2.contains("@attribute")) {
                                ++feature;
                            }
                        }
                        if (line2.equalsIgnoreCase("@data")) {
                            start = true;
                        }
                    }
                    attrib_counter = 0;
                }
            }
            if (format.equalsIgnoreCase("csv")) {
                while (!eof) {
                    line2 = buff_rd.readLine();
                    if (line2 == null) {
                        eof = true;
                    } else if (start) {
                        st = new StringTokenizer(line2, ",");
                        while (st.hasMoreTokens()) {
                            s = st.nextToken();
                            if (attrib_counter == feature && s != null) {
                                myStr = "Attr" + attrib_counter + "Value" + s;
                                n = (Integer)hash.get(myStr);
                                if (n != null) {
                                    fw.write(n + "\n");
                                } else {
                                    hash.put(myStr, new Integer(++current_class_value));
                                    fw.write(current_class_value + "\n");
                                }
                            } else if (s != null) {
                                myStr = "Attr" + attrib_counter + "Value" + s;
                                n = (Integer)hash.get(myStr);
                                if (n != null) {
                                    fw.write(n + ",");
                                } else {
                                    hash.put(myStr, new Integer(++current_value));
                                    fw.write(current_value + ",");
                                }
                            }
                            ++attrib_counter;
                        }
                    } else {
                        fw.write(line2 + "\n");
                        StringTokenizer st2 = new StringTokenizer(line2, ",");
                        while (st2.hasMoreTokens()) {
                            String s2 = st2.nextToken();
                            ++feature;
                        }
                        start = true;
                    }
                    attrib_counter = 0;
                }
            }
            if (format.equalsIgnoreCase("data")) {
                boolean firstline = true;
                while (!eof) {
                    line2 = buff_rd.readLine();
                    if (firstline) {
                        StringTokenizer st3 = new StringTokenizer(line2, ",");
                        while (st3.hasMoreTokens()) {
                            String s3 = st3.nextToken();
                            ++feature;
                        }
                        firstline = false;
                    }
                    if (line2 == null) {
                        eof = true;
                    } else {
                        st = new StringTokenizer(line2, ",");
                        while (st.hasMoreTokens()) {
                            Integer n2;
                            String myStr3;
                            String s2 = st.nextToken();
                            if (attrib_counter == feature && s2 != null) {
                                myStr3 = "Attr" + attrib_counter + "Value" + s2;
                                n2 = (Integer)hash.get(myStr3);
                                if (n2 != null) {
                                    fw.write(n2 + "\n");
                                } else {
                                    hash.put(myStr3, new Integer(current_class_value));
                                    fw.write(current_class_value + "\n");
                                    ++current_class_value;
                                }
                            } else if (s2 != null) {
                                myStr3 = "Attr" + attrib_counter + "Value" + s2;
                                n2 = (Integer)hash.get(myStr3);
                                if (n2 != null) {
                                    fw.write(n2 + ",");
                                } else {
                                    hash.put(myStr3, new Integer(++current_value));
                                    fw.write(current_value + ",");
                                }
                            }
                            ++attrib_counter;
                        }
                    }
                    attrib_counter = 0;
                }
            }
            buff_rd.close();
            fw.close();
            file_rd.close();
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public String[] read_Class_Labels_from_instances(Instances inst) {
        this.num_classes = inst.numClasses();
        String[] classes = new String[this.num_classes];
        for (int g = 0; g < this.num_classes; ++g) {
            classes[g] = "";
        }
        int cur_num_classes = -1;
        boolean found = false;
        for (int i = 0; i < inst.numInstances(); ++i) {
            if (cur_num_classes >= 0) {
                for (int k = 0; k < cur_num_classes && !found; ++k) {
                    if (inst.instance(i).classValue() != Double.parseDouble(classes[k])) continue;
                    found = true;
                }
            }
            if (!found) {
                if (cur_num_classes == -1) {
                    ++cur_num_classes;
                }
                classes[cur_num_classes] = new String(String.valueOf(inst.instance(i).classValue()));
                ++cur_num_classes;
            }
            found = false;
        }
        return classes;
    }

    public Hashtable creabin_from_instances(Instances inst, int label, String[] class_labels, Hashtable hash, String pathname, String dataset, int current_fold) {
        int endian = 2;
        boolean signed = false;
        int j = 0;
        FileWriter cl_file = null;
        int current_value = 0;
        long t_id = 0L;
        long c_id = 0L;
        boolean found = false;
        try {
            String dataset_name = dataset.substring(dataset.lastIndexOf("/") + 1, dataset.lastIndexOf("."));
            String bin_name = pathname + dataset_name + "k" + current_fold + ".bin";
            String class_path = pathname + dataset_name + "k" + current_fold + ".cls";
            RandomAccessFile file = new RandomAccessFile(bin_name, "rw");
            BinaryFile binFile = new BinaryFile(file);
            try {
                binFile.setEndian((short)2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            binFile.setSigned(false);
            this.num_classes = inst.numClasses();
            if (label == 1) {
                cl_file = new FileWriter(class_path);
                cl_file.write(Integer.toString(this.CLASS_NUM) + "\n");
                for (int i = 0; i < this.num_classes; ++i) {
                    cl_file.write(class_labels[i] + "\n");
                }
                cl_file.close();
            }
            for (int i = 0; i < inst.numInstances(); ++i) {
                binFile.writeDWord(t_id);
                binFile.writeDWord(c_id);
                ++t_id;
                ++c_id;
                binFile.writeDWord(inst.firstInstance().numAttributes());
                for (int k = 0; k < inst.instance(i).numAttributes() - 1; ++k) {
                    String myStr = "Attr" + k + "Value" + String.valueOf(inst.instance(i).value(k));
                    Integer n = (Integer)hash.get(myStr);
                    if (n != null) {
                        binFile.writeDWord(n.longValue());
                        continue;
                    }
                    hash.put(myStr, new Integer(++current_value));
                    binFile.writeDWord(current_value);
                }
                for (j = 0; j < this.num_classes && !(Double.parseDouble(class_labels[j]) == inst.instance(i).classValue()); ++j) {
                }
                binFile.writeDWord(this.CLASS_NUM + j);
                found = false;
            }
            file.close();
        }
        catch (IOException e) {
            e.getMessage();
        }
        return hash;
    }

    String create_csv_from_data(String dataset, String[] class_labels, String path_name) {
        String csv_filename = path_name + "dataset_converted.csv";
        try {
            FileReader file_rd = new FileReader(dataset);
            BufferedReader buff_rd = new BufferedReader(file_rd);
            String line2 = buff_rd.readLine();
            StringTokenizer st = new StringTokenizer(line2, ",");
            int attributes = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                ++attributes;
            }
            FileWriter fw = new FileWriter(csv_filename);
            for (int counter = 1; counter < attributes + 1; ++counter) {
                if (counter != attributes) {
                    fw.write("Attr" + counter + ",");
                    continue;
                }
                fw.write("class");
            }
            buff_rd.close();
            file_rd.close();
            boolean eof = false;
            file_rd = new FileReader(dataset);
            buff_rd = new BufferedReader(file_rd);
            while (!eof) {
                line2 = buff_rd.readLine();
                if (line2 == null) {
                    eof = true;
                    continue;
                }
                fw.write("\n");
                fw.write(line2);
            }
            fw.close();
            buff_rd.close();
            file_rd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return csv_filename;
    }

    void update_class_values(String training_filename, String training_filename_new, String[] class_labels) {
        try {
            FileReader file_rd = new FileReader(training_filename);
            BufferedReader buff_rd = new BufferedReader(file_rd);
            FileWriter fw = new FileWriter(training_filename_new);
            boolean eof = false;
            String line = null;
            int contatore = 1;
            while (!eof) {
                line = buff_rd.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                if (line.indexOf("@attribute") == -1) {
                    fw.write(line + "\n");
                    continue;
                }
                if (line.indexOf("@attribute class") != -1) {
                    fw.write("@attribute class {");
                    for (int i = 0; i < class_labels.length; ++i) {
                        fw.write("'" + class_labels[i] + "'");
                        if (i == class_labels.length - 1) continue;
                        fw.write(",");
                    }
                    fw.write("}");
                    fw.write("\n");
                    continue;
                }
                String linea = "@attribute attr" + contatore + " String";
                fw.write(linea + "\n");
                ++contatore;
            }
            fw.close();
            buff_rd.close();
            file_rd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

