/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import weka.classifiers.rules.BinaryFile;
import weka.core.Instance;

public class Classify_Test
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
    }

    static int maggioranza(String[] rules, String[] class_labels, String class_path, String pathname, Instance instance) {
        int id_base_class = 0;
        int[] class_labels_freq = new int[class_labels.length];
        for (int i = 0; i < class_labels.length; ++i) {
            class_labels_freq[i] = 0;
        }
        FileReader file = null;
        try {
            file = new FileReader(class_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buff = new BufferedReader(file);
        boolean eof = false;
        boolean firstline = true;
        String line = null;
        try {
            while (!eof) {
                line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                if (!firstline) continue;
                id_base_class = Integer.parseInt(line);
                firstline = false;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < rules.length; ++i) {
            if (rules[i] == null || rules[i] == "") continue;
            StringTokenizer st2 = new StringTokenizer(rules[i], " ");
            int counter = 0;
            while (st2.hasMoreTokens()) {
                String s = st2.nextToken();
                if (++counter != 3) continue;
                int n = Integer.parseInt(s) - id_base_class;
                class_labels_freq[n] = class_labels_freq[n] + 1;
            }
        }
        int maximum = -1;
        int result = -1;
        for (int i = 0; i < class_labels_freq.length; ++i) {
            if (class_labels_freq[i] <= maximum) continue;
            result = i;
            maximum = class_labels_freq[i];
        }
        instance.setClassValue(class_labels[result]);
        int my_result = (int)instance.value(instance.classIndex());
        return my_result;
    }

    static int maggioranza_numeric(String[] rules, String[] class_labels, String class_path, String pathname) {
        int id_base_class = 0;
        int[] class_labels_freq = new int[class_labels.length];
        for (int i = 0; i < class_labels.length; ++i) {
            class_labels_freq[i] = 0;
        }
        FileReader file = null;
        try {
            file = new FileReader(class_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buff = new BufferedReader(file);
        boolean eof = false;
        boolean firstline = true;
        String line = null;
        try {
            while (!eof) {
                line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                if (!firstline) continue;
                id_base_class = Integer.parseInt(line);
                firstline = false;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < rules.length; ++i) {
            if (rules[i] == null || rules[i] == "") continue;
            StringTokenizer st2 = new StringTokenizer(rules[i], " ");
            int counter = 0;
            while (st2.hasMoreTokens()) {
                String s = st2.nextToken();
                if (++counter != 3) continue;
                int n = Integer.parseInt(s) - id_base_class;
                class_labels_freq[n] = class_labels_freq[n] + 1;
            }
        }
        int maximum = -1;
        int result = -1;
        for (int i = 0; i < class_labels_freq.length; ++i) {
            if (class_labels_freq[i] <= maximum) continue;
            result = i;
            maximum = class_labels_freq[i];
        }
        return Integer.parseInt(class_labels[result]);
    }

    static int elimina(String[] rules, double soglia) {
        String s;
        double rule_conf = 0.0;
        int counter = 0;
        StringTokenizer st = new StringTokenizer(rules[0], " ");
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (++counter != 5) continue;
            rule_conf = Double.parseDouble(s);
        }
        double conf = rule_conf - soglia;
        int i = 1;
        while (rules[i] != null) {
            st = new StringTokenizer(rules[i], " ");
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                if (++counter != 5) continue;
                rule_conf = Double.parseDouble(s);
            }
            if (rule_conf <= conf) {
                for (int j = i; j < rules.length; ++j) {
                    rules[j] = null;
                }
                return i;
            }
            ++i;
        }
        return i;
    }

    double[] search_row_NEW(String current_bin_path, String dataset, Instance instance, String[] class_labels, int id_class_base) {
        int row = -1;
        String my_String = "";
        double[] instance_vector = new double[instance.numAttributes() - 1];
        for (int i = 0; i < instance.numAttributes() - 1; ++i) {
            my_String = my_String + Integer.toString((int)instance.value(i));
            if (i == instance.numAttributes() - 1) continue;
            my_String = my_String + ",";
        }
        FileReader file = null;
        try {
            file = new FileReader(dataset);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buff = new BufferedReader(file);
        boolean start = false;
        boolean eof = false;
        String line = null;
        int row_counter = 0;
        try {
            while (!eof) {
                line = buff.readLine();
                if (start) {
                    ++row_counter;
                }
                if (line == null) {
                    eof = true;
                    continue;
                }
                if (start) {
                    line = line.substring(0, line.lastIndexOf(",") + 1);
                }
                if (line.equalsIgnoreCase(my_String)) {
                    row = row_counter - 1;
                }
                if (!line.equalsIgnoreCase("@data")) continue;
                start = true;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (row == -1) {
            return null;
        }
        RandomAccessFile filebin = null;
        int endian = 2;
        boolean signed = false;
        try {
            filebin = new RandomAccessFile(current_bin_path, "r");
            BinaryFile binFile = new BinaryFile(filebin);
            binFile.setEndian((short)2);
            binFile.setSigned(false);
            while (true) {
                long item;
                long tid = binFile.readDWord();
                long cid = binFile.readDWord();
                long numItems = binFile.readDWord();
                for (long i = 0L; i < numItems - 1L; ++i) {
                    item = binFile.readDWord();
                    if (tid != (long)row) continue;
                    instance_vector[(int)i] = item;
                }
                item = binFile.readDWord();
            }
        }
        catch (Exception e) {
            System.out.println("**Error: " + e.getMessage());
            try {
                filebin.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return instance_vector;
        }
    }

    static String[] selection_NEW(double[] transaction, String levelI_path, String levelII_path, int num_rules, int num_features) {
        int j;
        String s;
        StringTokenizer st;
        String[] rules = new String[num_rules];
        int index = 0;
        for (int i = 0; i < num_rules; ++i) {
            rules[i] = null;
        }
        FileReader file = null;
        try {
            file = new FileReader(levelI_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buff = new BufferedReader(file);
        boolean eof = false;
        boolean found = false;
        String line = null;
        try {
            while (!eof) {
                line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    found = false;
                    s = st.nextToken();
                    if (s.indexOf("{") != -1 && s.indexOf("}") == -1) {
                        s = s.substring(1, s.length());
                    }
                    if (s.indexOf("{") != -1 && s.indexOf("}") != -1) {
                        s = s.substring(1, s.length() - 1);
                    }
                    if (s.indexOf("{") == -1 && s.indexOf("}") != -1) {
                        s = s.substring(0, s.indexOf("}"));
                    }
                    for (j = 0; j < num_features && !found; ++j) {
                        if (transaction[j] != Double.parseDouble(s)) continue;
                        found = true;
                    }
                    if (found) continue;
                    break;
                }
                if (!found) continue;
                rules[index] = new String(line);
                if (++index != num_rules) continue;
                return rules;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (rules != null) {
            return rules;
        }
        file = null;
        st = null;
        try {
            file = new FileReader(levelII_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        buff = new BufferedReader(file);
        eof = false;
        found = false;
        line = null;
        try {
            while (!eof) {
                line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    found = false;
                    s = st.nextToken();
                    if (s.indexOf("{") != -1 && s.indexOf("}") == -1) {
                        s = s.substring(1, s.length());
                    }
                    if (s.indexOf("{") != -1 && s.indexOf("}") != -1) {
                        s = s.substring(1, s.length() - 1);
                    }
                    if (s.indexOf("{") == -1 && s.indexOf("}") != -1) {
                        s = s.substring(0, s.indexOf("}"));
                    }
                    for (j = 0; j < num_features && !found; ++j) {
                        if (transaction[j] != Double.parseDouble(s)) continue;
                        found = true;
                    }
                    if (found) continue;
                    break;
                }
                if (!found) continue;
                rules[index] = new String(line);
                if (++index != num_rules) continue;
                return rules;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rules;
    }

    static String[] selection_HASH(String[] transaction, String levelI_path, String levelII_path, int num_rules, int num_features, Hashtable hash) {
        Integer n;
        String myStr;
        int j;
        String s;
        StringTokenizer st;
        if (hash.isEmpty()) {
            return null;
        }
        String[] rules = new String[num_rules];
        int index = 0;
        for (int i = 0; i < num_rules; ++i) {
            rules[i] = null;
        }
        FileReader file = null;
        try {
            file = new FileReader(levelI_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buff = new BufferedReader(file);
        boolean eof = false;
        boolean found = false;
        String line = null;
        try {
            while (!eof) {
                line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    found = false;
                    s = st.nextToken();
                    if (s.indexOf("{") != -1 && s.indexOf("}") == -1) {
                        s = s.substring(1, s.length());
                    } else if (s.indexOf("{") != -1 && s.indexOf("}") != -1) {
                        s = s.substring(1, s.indexOf("}"));
                    } else if (s.indexOf("{") == -1 && s.indexOf("}") != -1) {
                        s = s.substring(0, s.indexOf("}"));
                    }
                    for (j = 0; j < transaction.length && !found; ++j) {
                        myStr = "Attr" + j + "Value" + transaction[j];
                        n = (Integer)hash.get(myStr);
                        if (n == null || Integer.parseInt(s) != n) continue;
                        found = true;
                    }
                    if (found) continue;
                    break;
                }
                if (!found) continue;
                rules[index] = new String(line);
                if (++index != num_rules) continue;
                return rules;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (index > 0) {
            return rules;
        }
        file = null;
        st = null;
        try {
            file = new FileReader(levelII_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        buff = new BufferedReader(file);
        eof = false;
        found = false;
        line = null;
        try {
            while (!eof) {
                line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    found = false;
                    s = st.nextToken();
                    if (s.indexOf("{") != -1 && s.indexOf("}") == -1) {
                        s = s.substring(1, s.length());
                    } else if (s.indexOf("{") != -1 && s.indexOf("}") != -1) {
                        s = s.substring(1, s.indexOf("}"));
                    } else if (s.indexOf("{") == -1 && s.indexOf("}") != -1) {
                        s = s.substring(0, s.indexOf("}"));
                    }
                    for (j = 0; j < transaction.length && !found; ++j) {
                        myStr = "Attr" + j + "Value" + transaction[j];
                        n = (Integer)hash.get(myStr);
                        if (n == null || Integer.parseInt(s) != n) continue;
                        found = true;
                    }
                    if (found) continue;
                    break;
                }
                if (!found) continue;
                rules[index] = new String(line);
                if (++index != num_rules) continue;
                return rules;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rules;
    }

    static String[] selection_HASH_numeric(double[] transaction, String levelI_path, String levelII_path, int num_rules, int num_features, Hashtable hash) {
        Integer n;
        String myStr;
        int j;
        String s;
        StringTokenizer st;
        if (hash.isEmpty()) {
            System.err.println("Error on hash table!\n");
            return null;
        }
        String[] rules = new String[num_rules];
        int index = 0;
        for (int i = 0; i < num_rules; ++i) {
            rules[i] = null;
        }
        FileReader file = null;
        try {
            file = new FileReader(levelI_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader buff = new BufferedReader(file);
        boolean eof = false;
        boolean found = false;
        String line = null;
        try {
            while (!eof) {
                line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    found = false;
                    s = st.nextToken();
                    if (s.indexOf("{") != -1 && s.indexOf("}") == -1) {
                        s = s.substring(1, s.length());
                    } else if (s.indexOf("{") != -1 && s.indexOf("}") != -1) {
                        s = s.substring(1, s.indexOf("}"));
                    } else if (s.indexOf("{") == -1 && s.indexOf("}") != -1) {
                        s = s.substring(0, s.indexOf("}"));
                    }
                    for (j = 0; j < transaction.length && !found; ++j) {
                        myStr = "Attr" + j + "Value" + (int)transaction[j];
                        n = (Integer)hash.get(myStr);
                        if (n == null || Double.parseDouble(s) != (double)n.intValue()) continue;
                        found = true;
                    }
                    if (found) continue;
                    break;
                }
                if (!found) continue;
                rules[index] = new String(line);
                if (++index != num_rules) continue;
                return rules;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (index > 0) {
            return rules;
        }
        file = null;
        st = null;
        try {
            file = new FileReader(levelII_path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        buff = new BufferedReader(file);
        eof = false;
        found = false;
        line = null;
        try {
            while (!eof) {
                line = buff.readLine();
                if (line == null) {
                    eof = true;
                    continue;
                }
                st = new StringTokenizer(line, ",");
                while (st.hasMoreTokens()) {
                    found = false;
                    s = st.nextToken();
                    if (s.indexOf("{") != -1 && s.indexOf("}") == -1) {
                        s = s.substring(1, s.length());
                    } else if (s.indexOf("{") != -1 && s.indexOf("}") != -1) {
                        s = s.substring(1, s.indexOf("}"));
                    } else if (s.indexOf("{") == -1 && s.indexOf("}") != -1) {
                        s = s.substring(0, s.indexOf("}"));
                    }
                    for (j = 0; j < num_features && !found; ++j) {
                        myStr = "Attr" + j + "Value" + Double.parseDouble(s);
                        n = (Integer)hash.get(myStr);
                        if (n == null || transaction[j] != (double)n.intValue()) continue;
                        found = true;
                    }
                    if (found) continue;
                    break;
                }
                if (!found) continue;
                rules[index] = new String(line);
                if (++index != num_rules) continue;
                return rules;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rules;
    }
}

