/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.meta.AdaBoostM1;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class MultiBoostAB
extends AdaBoostM1
implements TechnicalInformationHandler {
    static final long serialVersionUID = -6681619178187935148L;
    protected int m_NumSubCmtys = 3;
    protected Random m_Random = null;

    @Override
    public String globalInfo() {
        return "Class for boosting a classifier using the MultiBoosting method.\n\nMultiBoosting is an extension to the highly successful AdaBoost technique for forming decision committees. MultiBoosting can be viewed as combining AdaBoost with wagging. It is able to harness both AdaBoost's high bias and variance reduction with wagging's superior variance reduction. Using C4.5 as the base learning algorithm, Multi-boosting is demonstrated to produce decision committees with lower error than either AdaBoost or wagging significantly more often than the reverse over a large representative cross-section of UCI data sets. It offers the further advantage over AdaBoost of suiting parallel execution.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Geoffrey I. Webb");
        result.setValue(TechnicalInformation.Field.YEAR, "2000");
        result.setValue(TechnicalInformation.Field.TITLE, "MultiBoosting: A Technique for Combining Boosting and Wagging");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "Vol.40");
        result.setValue(TechnicalInformation.Field.NUMBER, "No.2");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Kluwer Academic Publishers");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Boston");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Enumeration enu = super.listOptions();
        Vector<Option> vec = new Vector<Option>(1);
        vec.addElement(new Option("\tNumber of sub-committees. (Default 3)", "C", 1, "-C <num>"));
        while (enu.hasMoreElements()) {
            vec.addElement((Option)enu.nextElement());
        }
        return vec.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String subcmtyString = Utils.getOption('C', options);
        if (subcmtyString.length() != 0) {
            this.setNumSubCmtys(Integer.parseInt(subcmtyString));
        } else {
            this.setNumSubCmtys(3);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] ops = super.getOptions();
        String[] options = new String[ops.length + 2];
        options[0] = "-C";
        options[1] = "" + this.getNumSubCmtys();
        System.arraycopy(ops, 0, options, 2, ops.length);
        return options;
    }

    public String numSubCmtysTipText() {
        return "Sets the (approximate) number of subcommittees.";
    }

    public void setNumSubCmtys(int subc) {
        this.m_NumSubCmtys = subc;
    }

    public int getNumSubCmtys() {
        return this.m_NumSubCmtys;
    }

    @Override
    public void buildClassifier(Instances training) throws Exception {
        this.m_Random = new Random(this.m_Seed);
        super.buildClassifier(training);
        this.m_Random = null;
    }

    @Override
    protected void setWeights(Instances training, double reweight) throws Exception {
        int subCmtySize = this.m_Classifiers.length / this.m_NumSubCmtys;
        if ((this.m_NumIterationsPerformed + 1) % subCmtySize == 0) {
            if (this.getDebug()) {
                System.err.println(this.m_NumIterationsPerformed + " " + subCmtySize);
            }
            double oldSumOfWeights = training.sumOfWeights();
            for (int i = 0; i < training.numInstances(); ++i) {
                training.instance(i).setWeight(-Math.log(this.m_Random.nextDouble() * 9999.0 / 10000.0));
            }
            double sumProbs = training.sumOfWeights();
            for (int i = 0; i < training.numInstances(); ++i) {
                training.instance(i).setWeight(training.instance(i).weight() * oldSumOfWeights / sumProbs);
            }
        } else {
            super.setWeights(training, reweight);
        }
    }

    @Override
    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        StringBuffer text = new StringBuffer();
        if (this.m_NumIterations == 0) {
            text.append("MultiBoostAB: No model built yet.\n");
        } else if (this.m_NumIterations == 1) {
            text.append("MultiBoostAB: No boosting possible, one classifier used!\n");
            text.append(this.m_Classifiers[0].toString() + "\n");
        } else {
            text.append("MultiBoostAB: Base classifiers and their weights: \n\n");
            for (int i = 0; i < this.m_NumIterations; ++i) {
                if (this.m_Classifiers != null && this.m_Classifiers[i] != null) {
                    text.append(this.m_Classifiers[i].toString() + "\n\n");
                    text.append("Weight: " + Utils.roundDouble(this.m_Betas[i], 2) + "\n\n");
                    continue;
                }
                text.append("not yet initialized!\n\n");
            }
            text.append("Number of performed Iterations: " + this.m_NumIterations + "\n");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.16 $");
    }

    public static void main(String[] argv) {
        MultiBoostAB.runClassifier(new MultiBoostAB(), argv);
    }
}

