/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Evaluation;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.InstanceComparator;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.Randomizable;

public class RandomizedSphereCover
extends AbstractClassifier
implements Randomizable {
    private int alpha;
    private NormalizableDistance distanceFunc;
    private TreeSet<Instance> uncoveredCases;
    private Instances allCases;
    private ArrayList<Instance> T;
    private ArrayList<Sphere> sphereSet;
    private int randSeed = 100;
    private Random random = new Random(this.randSeed);
    private boolean crossValidateAlpha = false;

    public RandomizedSphereCover() {
        this.crossValidate(true);
        this.distanceFunc = new EuclideanDistance();
    }

    public RandomizedSphereCover(int a) {
        this.alpha = a;
        this.distanceFunc = new EuclideanDistance();
    }

    public final void crossValidate(boolean b) {
        this.crossValidateAlpha = b;
    }

    @Override
    public void setSeed(int seed) {
        this.random.setSeed(seed);
        this.randSeed = seed;
    }

    @Override
    public int getSeed() {
        return this.randSeed;
    }

    @Override
    public void buildClassifier(Instances inst) {
        if (this.crossValidateAlpha) {
            double bestAccuracy = 0.0;
            int maxAlpha = inst.numInstances() / 10;
            int folds = 10;
            for (int a = 1; a < maxAlpha; ++a) {
                RandomizedSphereCover r = new RandomizedSphereCover(1);
                try {
                    Evaluation e = new Evaluation(inst);
                    e.crossValidateModel(r, inst, folds, this.random, new Object[0]);
                    double acc = e.correct() / (double)inst.numInstances();
                    if (!(acc > bestAccuracy)) continue;
                    bestAccuracy = acc;
                    this.alpha = a;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
            }
        }
        this.sphereSet = new ArrayList();
        this.uncoveredCases = new TreeSet<Instance>(new InstanceComparator());
        this.distanceFunc.setInstances(inst);
        this.allCases = inst;
        for (int j = 0; j < inst.numInstances(); ++j) {
            this.uncoveredCases.add(inst.instance(j));
        }
        while (this.uncoveredCases.size() > 0) {
            int j;
            int rand = (int)(this.random.nextDouble() * (double)this.uncoveredCases.size());
            Instance[] tempArray = new Instance[this.uncoveredCases.size()];
            this.uncoveredCases.toArray(tempArray);
            Instance temp = tempArray[rand];
            this.uncoveredCases.remove(temp);
            Instance edge = null;
            double distance = Double.MAX_VALUE;
            for (int j2 = 0; j2 < this.allCases.numInstances(); ++j2) {
                Instance temp2 = this.allCases.instance(j2);
                double tempDist = this.distanceFunc.distance(temp, temp2);
                if (!(tempDist <= distance) || temp.classValue() == temp2.classValue()) continue;
                distance = tempDist;
                edge = temp2;
            }
            Sphere TempSphere = new Sphere(temp, distance);
            this.T = new ArrayList();
            this.T.add(edge);
            for (j = 0; j < this.allCases.numInstances(); ++j) {
                Instance tempInst = this.allCases.instance(j);
                double tempDist = this.distanceFunc.distance(temp, tempInst);
                if (!(tempDist <= distance) || tempDist == 0.0) continue;
                this.T.add(tempInst);
            }
            if (this.T.size() < this.alpha) continue;
            for (j = 0; j < this.T.size(); ++j) {
                Instance temp1 = this.T.get(j);
                this.uncoveredCases.remove(temp1);
            }
            this.sphereSet.add(TempSphere);
        }
    }

    @Override
    public double classifyInstance(Instance i) throws Exception {
        int closestSphere = 0;
        int closestCentre = -1;
        double previousDistance = Double.MAX_VALUE;
        if (this.sphereSet.size() > 0) {
            for (int j = 0; j < this.sphereSet.size(); ++j) {
                Sphere temp = this.sphereSet.get(j);
                double distance = this.distanceFunc.distance(temp.getCentre(), i);
                if (distance <= temp.getRadius()) {
                    if (closestCentre != -1) {
                        if (!(distance < this.distanceFunc.distance(this.sphereSet.get(closestCentre).getCentre(), i))) continue;
                        closestCentre = j;
                        continue;
                    }
                    closestCentre = j;
                    continue;
                }
                if (!(distance - temp.getRadius() <= previousDistance)) continue;
                previousDistance = distance - temp.getRadius();
                closestSphere = j;
            }
            if (closestCentre != -1) {
                return this.sphereSet.get(closestCentre).getCentre().classValue();
            }
            return this.sphereSet.get(closestSphere).getCentre().classValue();
        }
        throw new Exception("No Spheres in the set");
    }

    public void setDistanceFunc(NormalizableDistance in) {
        this.distanceFunc = in;
    }

    public ArrayList<Sphere> getSphereSet() {
        return this.sphereSet;
    }

    @Override
    public String getRevision() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        System.out.println(" Test harness not implemented");
    }

    public static class Sphere {
        private Instance centre;
        private double radius;

        public Sphere(Instance c, double r) {
            this.centre = c;
            this.radius = r;
        }

        public Instance getCentre() {
            return this.centre;
        }

        public double getRadius() {
            return this.radius;
        }
    }
}

