/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class WAODE
extends AbstractClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 2170978824284697882L;
    private double[] m_ClassCounts;
    private double[] m_AttCounts;
    private double[][] m_AttAttCounts;
    private double[][][] m_ClassAttAttCounts;
    private int[] m_NumAttValues;
    private int m_TotalAttValues;
    private int m_NumClasses;
    private int m_NumAttributes;
    private int m_NumInstances;
    private int m_ClassIndex;
    private int[] m_StartAttIndex;
    private double[] m_mutualInformation;
    private Instances m_Header = null;
    private boolean m_Internals = false;
    private Classifier m_ZeroR;

    public String globalInfo() {
        return "WAODE contructs the model called Weightily Averaged One-Dependence Estimators.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tWhether to print some more internals.\n\t(default: no)", "I", 0, "-I"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.setInternals(Utils.getFlag('I', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getInternals()) {
            result.add("-I");
        }
        return result.toArray(new String[result.size()]);
    }

    public String internalsTipText() {
        return "Prints more internals of the classifier.";
    }

    public void setInternals(boolean value) {
        this.m_Internals = value;
    }

    public boolean getInternals() {
        return this.m_Internals;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "L. Jiang and H. Zhang");
        result.setValue(TechnicalInformation.Field.TITLE, "Weightily Averaged One-Dependence Estimators");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 9th Biennial Pacific Rim International Conference on Artificial Intelligence, PRICAI 2006");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.PAGES, "970-974");
        result.setValue(TechnicalInformation.Field.SERIES, "LNAI");
        result.setValue(TechnicalInformation.Field.VOLUME, "4099");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_NumClasses = instances.numClasses();
        this.m_ClassIndex = instances.classIndex();
        this.m_NumAttributes = instances.numAttributes();
        this.m_NumInstances = instances.numInstances();
        this.m_TotalAttValues = 0;
        this.m_StartAttIndex = new int[this.m_NumAttributes];
        this.m_NumAttValues = new int[this.m_NumAttributes];
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (i != this.m_ClassIndex) {
                this.m_StartAttIndex[i] = this.m_TotalAttValues;
                this.m_NumAttValues[i] = instances.attribute(i).numValues();
                this.m_TotalAttValues += this.m_NumAttValues[i];
                continue;
            }
            this.m_StartAttIndex[i] = -1;
            this.m_NumAttValues[i] = this.m_NumClasses;
        }
        this.m_ClassCounts = new double[this.m_NumClasses];
        this.m_AttCounts = new double[this.m_TotalAttValues];
        this.m_AttAttCounts = new double[this.m_TotalAttValues][this.m_TotalAttValues];
        this.m_ClassAttAttCounts = new double[this.m_NumClasses][this.m_TotalAttValues][this.m_TotalAttValues];
        this.m_Header = new Instances(instances, 0);
        for (int k = 0; k < this.m_NumInstances; ++k) {
            int classVal;
            int n = classVal = (int)instances.instance(k).classValue();
            this.m_ClassCounts[n] = this.m_ClassCounts[n] + 1.0;
            int[] attIndex = new int[this.m_NumAttributes];
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (i == this.m_ClassIndex) {
                    attIndex[i] = -1;
                    continue;
                }
                attIndex[i] = this.m_StartAttIndex[i] + (int)instances.instance(k).value(i);
                int n2 = attIndex[i];
                this.m_AttCounts[n2] = this.m_AttCounts[n2] + 1.0;
            }
            for (int Att1 = 0; Att1 < this.m_NumAttributes; ++Att1) {
                if (attIndex[Att1] == -1) continue;
                for (int Att2 = 0; Att2 < this.m_NumAttributes; ++Att2) {
                    if (attIndex[Att2] == -1) continue;
                    double[] dArray = this.m_AttAttCounts[attIndex[Att1]];
                    int n3 = attIndex[Att2];
                    dArray[n3] = dArray[n3] + 1.0;
                    double[] dArray2 = this.m_ClassAttAttCounts[classVal][attIndex[Att1]];
                    int n4 = attIndex[Att2];
                    dArray2[n4] = dArray2[n4] + 1.0;
                }
            }
        }
        this.m_mutualInformation = new double[this.m_NumAttributes];
        for (int att = 0; att < this.m_NumAttributes; ++att) {
            if (att == this.m_ClassIndex) continue;
            this.m_mutualInformation[att] = this.mutualInfo(att);
        }
    }

    private double mutualInfo(int att) {
        int j;
        int i;
        double mutualInfo = 0.0;
        int attIndex = this.m_StartAttIndex[att];
        double[] PriorsClass = new double[this.m_NumClasses];
        double[] PriorsAttribute = new double[this.m_NumAttValues[att]];
        double[][] PriorsClassAttribute = new double[this.m_NumClasses][this.m_NumAttValues[att]];
        for (i = 0; i < this.m_NumClasses; ++i) {
            PriorsClass[i] = this.m_ClassCounts[i] / (double)this.m_NumInstances;
        }
        for (int j2 = 0; j2 < this.m_NumAttValues[att]; ++j2) {
            PriorsAttribute[j2] = this.m_AttCounts[attIndex + j2] / (double)this.m_NumInstances;
        }
        for (i = 0; i < this.m_NumClasses; ++i) {
            for (j = 0; j < this.m_NumAttValues[att]; ++j) {
                PriorsClassAttribute[i][j] = this.m_ClassAttAttCounts[i][attIndex + j][attIndex + j] / (double)this.m_NumInstances;
            }
        }
        for (i = 0; i < this.m_NumClasses; ++i) {
            for (j = 0; j < this.m_NumAttValues[att]; ++j) {
                mutualInfo += PriorsClassAttribute[i][j] * this.log2(PriorsClassAttribute[i][j], PriorsClass[i] * PriorsAttribute[j]);
            }
        }
        return mutualInfo;
    }

    private double log2(double x, double y) {
        if (x < Utils.SMALL || y < Utils.SMALL) {
            return 0.0;
        }
        return Math.log(x / y) / Math.log(2.0);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] probs = new double[this.m_NumClasses];
        int[] attIndex = new int[this.m_NumAttributes];
        for (int att = 0; att < this.m_NumAttributes; ++att) {
            attIndex[att] = att == this.m_ClassIndex ? -1 : this.m_StartAttIndex[att] + (int)instance.value(att);
        }
        int classVal = 0;
        while (classVal < this.m_NumClasses) {
            probs[classVal] = 0.0;
            double prob = 1.0;
            double mutualInfoSum = 0.0;
            for (int parent = 0; parent < this.m_NumAttributes; ++parent) {
                if (attIndex[parent] == -1) continue;
                prob = (this.m_ClassAttAttCounts[classVal][attIndex[parent]][attIndex[parent]] + 1.0 / (double)(this.m_NumClasses * this.m_NumAttValues[parent])) / ((double)this.m_NumInstances + 1.0);
                for (int son = 0; son < this.m_NumAttributes; ++son) {
                    if (attIndex[son] == -1 || son == parent) continue;
                    prob *= (this.m_ClassAttAttCounts[classVal][attIndex[parent]][attIndex[son]] + 1.0 / (double)this.m_NumAttValues[son]) / (this.m_ClassAttAttCounts[classVal][attIndex[parent]][attIndex[parent]] + 1.0);
                }
                mutualInfoSum += this.m_mutualInformation[parent];
                int n = classVal;
                probs[n] = probs[n] + this.m_mutualInformation[parent] * prob;
            }
            int n = classVal++;
            probs[n] = probs[n] / mutualInfoSum;
        }
        if (!Double.isNaN(Utils.sum(probs))) {
            Utils.normalize(probs);
        }
        return probs;
    }

    public String toString() {
        StringBuffer result;
        if (this.m_ZeroR != null) {
            result = new StringBuffer();
            result.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            result.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            result.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            result.append(this.m_ZeroR.toString());
        } else {
            String classname = this.getClass().getName().replaceAll(".*\\.", "");
            result = new StringBuffer();
            result.append(classname + "\n");
            result.append(classname.replaceAll(".", "=") + "\n\n");
            if (this.m_Header == null) {
                result.append("No Model built yet.\n");
            } else if (this.getInternals()) {
                result.append("Mutual information of attributes with class attribute:\n");
                for (int i = 0; i < this.m_Header.numAttributes(); ++i) {
                    if (i == this.m_Header.classIndex()) continue;
                    result.append(i + 1 + ". " + this.m_Header.attribute(i).name() + ": " + Utils.doubleToString(this.m_mutualInformation[i], 6) + "\n");
                }
            } else {
                result.append("Model built successfully.\n");
            }
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5516 $");
    }

    public static void main(String[] argv) {
        WAODE.runClassifier(new WAODE(), argv);
    }
}

