/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class LFSMethods
implements RevisionHandler {
    private static final int MAX_SUBSET_SIZE = 200;
    private BitSet m_bestGroup;
    private double m_bestMerit;
    private int m_evalsTotal;
    private int m_evalsCached;
    private BitSet[] m_bestGroupOfSize = new BitSet[200];

    public BitSet getBestGroup() {
        return this.m_bestGroup;
    }

    public double getBestMerit() {
        return this.m_bestMerit;
    }

    public BitSet getBestGroupOfSize(int size) {
        return this.m_bestGroupOfSize[size];
    }

    public int getNumEvalsCached() {
        return this.m_evalsCached;
    }

    public int getNumEvalsTotal() {
        return this.m_evalsTotal;
    }

    public int[] rankAttributes(Instances data, SubsetEvaluator evaluator, boolean verbose) throws Exception {
        if (verbose) {
            System.out.println("Ranking attributes with " + evaluator.getClass().getName());
        }
        double[] merit = new double[data.numAttributes()];
        BitSet group = new BitSet(data.numAttributes());
        for (int k = 0; k < data.numAttributes(); ++k) {
            if (k != data.classIndex()) {
                group.set(k);
                int n = k;
                merit[n] = merit[n] - evaluator.evaluateSubset(group);
                ++this.m_evalsTotal;
                group.clear(k);
            } else {
                merit[k] = Double.MAX_VALUE;
            }
            if (!verbose) continue;
            System.out.println(k + ": " + merit[k]);
        }
        int[] ranking = Utils.sort(merit);
        if (verbose) {
            System.out.print("Ranking [ ");
            for (int i = 0; i < ranking.length; ++i) {
                System.out.print(ranking[i] + " ");
            }
            System.out.println("]\n");
        }
        return ranking;
    }

    public BitSet forwardSearch(int cacheSize, BitSet startGroup, int[] ranking, int k, boolean incrementK, int maxStale, int forceResultSize, Instances data, SubsetEvaluator evaluator, boolean verbose) throws Exception {
        if (forceResultSize > 0 && maxStale > 1) {
            throw new Exception("Forcing result size only works for maxStale=1");
        }
        if (verbose) {
            System.out.println("Starting forward selection");
        }
        int bestSize = 0;
        int tempSize = 0;
        double tempMerit = 0.0;
        LinkedList2 list = new LinkedList2(maxStale);
        Hashtable<String, Double> alreadyExpanded = new Hashtable<String, Double>(cacheSize * data.numAttributes());
        int insertCount = 0;
        int stale = 0;
        int thisK = k;
        int evalsTotal = 0;
        int evalsCached = 0;
        BitSet bestGroup = (BitSet)startGroup.clone();
        String hashKey2 = bestGroup.toString();
        double bestMerit = evaluator.evaluateSubset(bestGroup);
        if (verbose) {
            System.out.print("Group: ");
            LFSMethods.printGroup(bestGroup, data.numAttributes());
            System.out.println("Merit: " + tempMerit);
            System.out.println("----------");
        }
        alreadyExpanded.put(hashKey2, new Double(bestMerit));
        ++insertCount;
        bestSize = bestGroup.cardinality();
        if (maxStale > 1) {
            Object[] best = new Object[]{bestGroup.clone()};
            list.addToList(best, bestMerit);
        }
        while (stale < maxStale) {
            BitSet tempGroup;
            boolean improvement = false;
            if (maxStale > 1) {
                if (list.size() == 0) {
                    stale = maxStale;
                    break;
                }
                Link2 link = list.getLinkAt(0);
                tempGroup = (BitSet)link.getData()[0];
                tempGroup = (BitSet)tempGroup.clone();
                list.removeLinkAt(0);
                tempSize = 0;
                for (int i = 0; i < data.numAttributes(); ++i) {
                    if (!tempGroup.get(i)) continue;
                    ++tempSize;
                }
            } else {
                tempGroup = (BitSet)bestGroup.clone();
                tempSize = bestSize;
            }
            thisK = incrementK ? Math.min(Math.max(thisK, k + tempSize), data.numAttributes()) : k;
            for (int i = 0; i < thisK; ++i) {
                if (ranking[i] == data.classIndex() || tempGroup.get(ranking[i])) continue;
                tempGroup.set(ranking[i]);
                ++tempSize;
                hashKey2 = tempGroup.toString();
                if (!alreadyExpanded.containsKey(hashKey2)) {
                    ++evalsTotal;
                    tempMerit = evaluator.evaluateSubset(tempGroup);
                    if (insertCount > cacheSize * data.numAttributes()) {
                        alreadyExpanded = new Hashtable(cacheSize * data.numAttributes());
                        insertCount = 0;
                    }
                    alreadyExpanded.put(hashKey2, new Double(tempMerit));
                    ++insertCount;
                } else {
                    ++evalsCached;
                    tempMerit = (Double)alreadyExpanded.get(hashKey2);
                }
                if (verbose) {
                    System.out.print("Group: ");
                    LFSMethods.printGroup(tempGroup, data.numAttributes());
                    System.out.println("Merit: " + tempMerit);
                }
                if (tempMerit - bestMerit > 1.0E-5 || forceResultSize >= tempSize && tempSize > bestSize) {
                    improvement = true;
                    stale = 0;
                    bestMerit = tempMerit;
                    bestSize = tempSize;
                    bestGroup = (BitSet)tempGroup.clone();
                    this.m_bestGroupOfSize[bestSize] = (BitSet)tempGroup.clone();
                }
                if (maxStale > 1) {
                    Object[] add = new Object[]{tempGroup.clone()};
                    list.addToList(add, tempMerit);
                }
                tempGroup.clear(ranking[i]);
                --tempSize;
            }
            if (verbose) {
                System.out.println("----------");
            }
            if (!improvement || forceResultSize == bestSize) {
                ++stale;
            }
            if (forceResultSize <= 0 || bestSize != forceResultSize) continue;
        }
        if (verbose) {
            System.out.println("Best Group: ");
            LFSMethods.printGroup(bestGroup, data.numAttributes());
            System.out.println();
        }
        this.m_bestGroup = bestGroup;
        this.m_bestMerit = bestMerit;
        this.m_evalsTotal += evalsTotal;
        this.m_evalsCached += evalsCached;
        return bestGroup;
    }

    public BitSet floatingForwardSearch(int cacheSize, BitSet startGroup, int[] ranking, int k, boolean incrementK, int maxStale, Instances data, SubsetEvaluator evaluator, boolean verbose) throws Exception {
        if (verbose) {
            System.out.println("Starting floating forward selection");
        }
        int bestSize = 0;
        int tempSize = 0;
        double tempMerit = 0.0;
        LinkedList2 list = new LinkedList2(maxStale);
        Hashtable<String, Double> alreadyExpanded = new Hashtable<String, Double>(cacheSize * data.numAttributes());
        int insertCount = 0;
        int backtrackingSteps = 0;
        int thisK = k;
        int evalsTotal = 0;
        int evalsCached = 0;
        BitSet bestGroup = (BitSet)startGroup.clone();
        String hashKey2 = bestGroup.toString();
        double bestMerit = evaluator.evaluateSubset(bestGroup);
        if (verbose) {
            System.out.print("Group: ");
            LFSMethods.printGroup(bestGroup, data.numAttributes());
            System.out.println("Merit: " + tempMerit);
            System.out.println("----------");
        }
        alreadyExpanded.put(hashKey2, new Double(bestMerit));
        ++insertCount;
        bestSize = bestGroup.cardinality();
        if (maxStale > 1) {
            Object[] best = new Object[]{bestGroup.clone()};
            list.addToList(best, bestMerit);
        }
        boolean improvement = true;
        boolean backward = true;
        while (true) {
            BitSet tempGroup;
            if (backward) {
                if (!improvement) {
                    backward = false;
                }
            } else {
                if (!improvement && backtrackingSteps >= maxStale) break;
                backward = true;
            }
            improvement = false;
            if (maxStale > 1) {
                if (list.size() == 0) {
                    backtrackingSteps = maxStale;
                    break;
                }
                Link2 link = list.getLinkAt(0);
                tempGroup = (BitSet)link.getData()[0];
                tempGroup = (BitSet)tempGroup.clone();
                list.removeLinkAt(0);
                tempSize = 0;
                for (int i = 0; i < data.numAttributes(); ++i) {
                    if (!tempGroup.get(i)) continue;
                    ++tempSize;
                }
            } else {
                tempGroup = (BitSet)bestGroup.clone();
                tempSize = bestSize;
            }
            if (backward && tempSize <= 2) {
                backward = false;
            }
            thisK = incrementK ? Math.max(thisK, Math.min(Math.max(thisK, k + tempSize), data.numAttributes())) : k;
            for (int i = 0; i < thisK; ++i) {
                if (ranking[i] == data.classIndex()) continue;
                if (backward) {
                    if (!tempGroup.get(ranking[i])) continue;
                    tempGroup.clear(ranking[i]);
                    --tempSize;
                } else {
                    if (ranking[i] == data.classIndex() || tempGroup.get(ranking[i])) continue;
                    tempGroup.set(ranking[i]);
                    ++tempSize;
                }
                hashKey2 = tempGroup.toString();
                if (!alreadyExpanded.containsKey(hashKey2)) {
                    ++evalsTotal;
                    tempMerit = evaluator.evaluateSubset(tempGroup);
                    if (insertCount > cacheSize * data.numAttributes()) {
                        alreadyExpanded = new Hashtable(cacheSize * data.numAttributes());
                        insertCount = 0;
                    }
                    alreadyExpanded.put(hashKey2, new Double(tempMerit));
                    ++insertCount;
                } else {
                    ++evalsCached;
                    tempMerit = (Double)alreadyExpanded.get(hashKey2);
                }
                if (verbose) {
                    System.out.print("Group: ");
                    LFSMethods.printGroup(tempGroup, data.numAttributes());
                    System.out.println("Merit: " + tempMerit);
                }
                if (tempMerit - bestMerit > 1.0E-5) {
                    improvement = true;
                    backtrackingSteps = 0;
                    bestMerit = tempMerit;
                    bestSize = tempSize;
                    bestGroup = (BitSet)tempGroup.clone();
                }
                if (maxStale > 1) {
                    Object[] add = new Object[]{tempGroup.clone()};
                    list.addToList(add, tempMerit);
                }
                if (backward) {
                    tempGroup.set(ranking[i]);
                    ++tempSize;
                    continue;
                }
                tempGroup.clear(ranking[i]);
                --tempSize;
            }
            if (verbose) {
                System.out.println("----------");
            }
            if (maxStale > 1 && backward && !improvement) {
                Object[] add = new Object[]{tempGroup.clone()};
                list.addToList(add, Double.MAX_VALUE);
            }
            if (backward || improvement) continue;
            ++backtrackingSteps;
        }
        if (verbose) {
            System.out.println("Best Group: ");
            LFSMethods.printGroup(bestGroup, data.numAttributes());
            System.out.println();
        }
        this.m_bestGroup = bestGroup;
        this.m_bestMerit = bestMerit;
        this.m_evalsTotal += evalsTotal;
        this.m_evalsCached += evalsCached;
        return bestGroup;
    }

    protected static void printGroup(BitSet tt, int numAttribs) {
        System.out.print("{ ");
        for (int i = 0; i < numAttribs; ++i) {
            if (!tt.get(i)) continue;
            System.out.print(i + 1 + " ");
        }
        System.out.println("}");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }

    public class LinkedList2
    extends FastVector {
        private static final long serialVersionUID = -7776010892419656105L;
        int m_MaxSize;

        public LinkedList2(int sz) {
            this.m_MaxSize = sz;
        }

        public void removeLinkAt(int index) throws Exception {
            if (index < 0 || index >= this.size()) {
                throw new Exception("index out of range (removeLinkAt)");
            }
            this.removeElementAt(index);
        }

        public Link2 getLinkAt(int index) throws Exception {
            if (this.size() == 0) {
                throw new Exception("List is empty (getLinkAt)");
            }
            if (index >= 0 && index < this.size()) {
                return (Link2)this.elementAt(index);
            }
            throw new Exception("index out of range (getLinkAt)");
        }

        public void addToList(Object[] data, double mer) throws Exception {
            Link2 newL = new Link2(data, mer);
            if (this.size() == 0) {
                this.addElement(newL);
            } else if (mer > ((Link2)this.firstElement()).m_merit) {
                if (this.size() == this.m_MaxSize) {
                    this.removeLinkAt(this.m_MaxSize - 1);
                }
                this.insertElementAt(newL, 0);
            } else {
                int i = 0;
                int size = this.size();
                boolean done = false;
                if (size != this.m_MaxSize || !(mer <= ((Link2)this.lastElement()).m_merit)) {
                    while (!done && i < size) {
                        if (mer > ((Link2)this.elementAt((int)i)).m_merit) {
                            if (size == this.m_MaxSize) {
                                this.removeLinkAt(this.m_MaxSize - 1);
                            }
                            this.insertElementAt(newL, i);
                            done = true;
                            continue;
                        }
                        if (i == size - 1) {
                            this.addElement(newL);
                            done = true;
                            continue;
                        }
                        ++i;
                    }
                }
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.3 $");
        }
    }

    public class Link2
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -7422719407475185086L;
        Object[] m_data;
        double m_merit;

        public Link2(Object[] data, double mer) {
            this.m_data = data;
            this.m_merit = mer;
        }

        public Object[] getData() {
            return this.m_data;
        }

        public String toString() {
            return "Node: " + this.m_data.toString() + "  " + this.m_merit;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.3 $");
        }
    }
}

