/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import java.util.Random;
import vector_classifiers.TunedRotationForest;
import weka.core.Instances;

public class RotationForestLimitedAttributes
extends TunedRotationForest {
    private int maxNumAttributes = 100;
    private boolean propToNumAtts = true;

    public RotationForestLimitedAttributes() {
        this.estimateAccFromTrain(false);
        this.tuneParameters(false);
        this.setNumIterations(200);
    }

    public void setMaxNumAttributes(int m) {
        this.maxNumAttributes = m < 100 ? m : (m < 400 ? m / 2 : m / 4);
        if (m < 1) {
            this.maxNumAttributes = 1;
        }
    }

    @Override
    protected int[] attributesPermutation(int numAttributes, int classAttribute, Random random) {
        int i;
        int[] permutation = new int[numAttributes - 1];
        for (i = 0; i < classAttribute; ++i) {
            permutation[i] = i;
        }
        while (i < permutation.length) {
            permutation[i] = i + 1;
            ++i;
        }
        this.permute(permutation, random);
        if (numAttributes > this.maxNumAttributes) {
            int[] temp = new int[this.maxNumAttributes];
            System.arraycopy(permutation, 0, temp, 0, this.maxNumAttributes);
            permutation = temp;
        }
        return permutation;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.propToNumAtts) {
            this.setMaxNumAttributes(data.numAttributes() - 1);
        }
        super.buildClassifier(data);
    }

    public static void main(String[] args) {
    }
}

