/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;
import utilities.class_distributions.ClassDistribution;
import utilities.class_distributions.TreeSetClassDistribution;
import utilities.generic_storage.Pair;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.DistanceFunction;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class InstanceTools {
    public static Pair<Instance, Double> findMinDistance(Instances data, Instance inst, DistanceFunction dist) {
        double min = dist.distance(data.get(0), inst);
        Instance minI = data.get(0);
        for (int i = 1; i < data.numInstances(); ++i) {
            double temp = dist.distance(data.get(i), inst);
            if (!(temp < min)) continue;
            min = temp;
            minI = data.get(i);
        }
        return new Pair<Instance, Double>(minI, min);
    }

    public static int[] deleteClassValues(Instances d) {
        int[] classVals = new int[d.numInstances()];
        for (int i = 0; i < d.numInstances(); ++i) {
            classVals[i] = (int)d.instance(i).classValue();
            d.instance(i).setMissing(d.instance(i).classIndex());
        }
        return classVals;
    }

    public static Map<Double, Integer> createClassDistributions(Instances data) {
        TreeMap<Double, Integer> classDistribution = new TreeMap<Double, Integer>();
        ListIterator it = data.listIterator();
        while (it.hasNext()) {
            double classValue = ((Instance)it.next()).classValue();
            Integer val = (Integer)classDistribution.get(classValue);
            val = val != null ? val + 1 : 1;
            classDistribution.put(classValue, val);
        }
        return classDistribution;
    }

    public static double[] findClassDistributions(Instances data) {
        double[] dist = new double[data.numClasses()];
        for (Instance d : data) {
            int n = (int)d.classValue();
            dist[n] = dist[n] + 1.0;
        }
        int i = 0;
        while (i < dist.length) {
            int n = i++;
            dist[n] = dist[n] / (double)data.numInstances();
        }
        return dist;
    }

    public static double[] findClassDistributions(ArrayList<Double> classLabels, int numClasses) {
        double[] dist = new double[numClasses];
        for (double d : classLabels) {
            int n = (int)d;
            dist[n] = dist[n] + 1.0;
        }
        int i = 0;
        while (i < dist.length) {
            int n = i++;
            dist[n] = dist[n] / (double)classLabels.size();
        }
        return dist;
    }

    public static Map<Double, Instances> createClassInstancesMap(Instances data) {
        TreeMap<Double, Instances> instancesMap = new TreeMap<Double, Instances>();
        ListIterator it = data.listIterator();
        while (it.hasNext()) {
            Instance inst = (Instance)it.next();
            double classValue = inst.classValue();
            Instances val = (Instances)instancesMap.get(classValue);
            if (val == null) {
                val = new Instances(data, 0);
            }
            val.add(inst);
            instancesMap.put(classValue, val);
        }
        return instancesMap;
    }

    public static Instances[] resampleTrainAndTestInstances(Instances train, Instances test, long seed) {
        if (seed == 0L) {
            Instances newTrain = new Instances(train);
            Instances newTest = new Instances(test);
            return new Instances[]{newTrain, newTest};
        }
        Instances all = new Instances(train);
        all.addAll(test);
        TreeSetClassDistribution trainDistribution = new TreeSetClassDistribution(train);
        Map<Double, Instances> classBins = InstanceTools.createClassInstancesMap(all);
        Random r = new Random(seed);
        Instances outputTrain = new Instances(all, 0);
        Instances outputTest = new Instances(all, 0);
        for (double classVal : classBins.keySet()) {
            int occurences = ((ClassDistribution)trainDistribution).get(classVal);
            Instances bin = classBins.get(classVal);
            bin.randomize(r);
            outputTrain.addAll(bin.subList(0, occurences));
            outputTest.addAll(bin.subList(occurences, bin.size()));
        }
        return new Instances[]{outputTrain, outputTest};
    }

    public static Instances[] resampleInstances(Instances all, long seed, double propInTrain) {
        TreeSetClassDistribution classDist = new TreeSetClassDistribution(all);
        Map<Double, Instances> classBins = InstanceTools.createClassInstancesMap(all);
        Random r = new Random(seed);
        Instances outputTrain = new Instances(all, 0);
        Instances outputTest = new Instances(all, 0);
        for (double classVal : classBins.keySet()) {
            int classCount = ((ClassDistribution)classDist).get(classVal);
            int occurences = (int)((double)classCount * propInTrain);
            Instances bin = classBins.get(classVal);
            bin.randomize(r);
            outputTrain.addAll(bin.subList(0, occurences));
            outputTest.addAll(bin.subList(occurences, bin.size()));
        }
        return new Instances[]{outputTrain, outputTest};
    }

    public static Instances toWekaInstances(double[][] data) {
        int i;
        Instances wekaInstances = null;
        if (data.length <= 0) {
            return wekaInstances;
        }
        int dimRows = data.length;
        int dimColumns = data[0].length;
        FastVector<Attribute> attributes = new FastVector<Attribute>(dimColumns);
        for (i = 0; i < dimColumns; ++i) {
            attributes.addElement(new Attribute("attr" + String.valueOf(i + 1)));
        }
        wekaInstances = new Instances("", attributes, dimRows);
        for (i = 0; i < dimRows; ++i) {
            double[] instanceValues = new double[dimColumns];
            for (int j = 0; j < dimColumns; ++j) {
                instanceValues[j] = data[i][j];
            }
            wekaInstances.add(new DenseInstance(1.0, instanceValues));
        }
        return wekaInstances;
    }

    public static Instances toWekaInstancesWithClass(double[][] data) {
        Instances wekaInstances = InstanceTools.toWekaInstances(data);
        wekaInstances.setClassIndex(wekaInstances.numAttributes() - 1);
        return wekaInstances;
    }

    public static double[][] fromWekaInstancesArray(Instances ds, boolean removeLastVal) {
        int numFeatures = ds.numAttributes() - (removeLastVal ? 1 : 0);
        int numInstances = ds.numInstances();
        double[][] data = new double[numInstances][numFeatures];
        for (int i = 0; i < numInstances; ++i) {
            for (int j = 0; j < numFeatures; ++j) {
                data[i][j] = ds.get(i).value(j);
            }
        }
        return data;
    }

    public static ArrayList<ArrayList<Double>> fromWekaInstancesList(Instances ds) {
        int numFeatures = ds.numAttributes() - 1;
        int numInstances = ds.numInstances();
        ArrayList<ArrayList<Double>> data = new ArrayList<ArrayList<Double>>(numInstances);
        for (int i = 0; i < numInstances; ++i) {
            ArrayList<Double> temp = new ArrayList<Double>(numFeatures);
            for (int j = 0; j < numFeatures; ++j) {
                temp.add(ds.get(i).value(j));
            }
            data.add(temp);
        }
        return data;
    }

    public static double[][] create2DMatrixFromInstances(Instances train, Instances test) {
        double[][] data = new double[train.numInstances() + test.numInstances()][train.numAttributes()];
        for (int i = 0; i < train.numInstances(); ++i) {
            for (int j = 0; j < train.numAttributes(); ++j) {
                data[i][j] = train.get(i).value(j);
            }
        }
        int index = 0;
        for (int i = train.numInstances(); i < train.numInstances() + test.numInstances(); ++i) {
            for (int j = 0; j < test.numAttributes(); ++j) {
                data[i][j] = test.get(index).value(j);
            }
            ++index;
        }
        return data;
    }

    public static Instances convertFromUCRtoARFF(String inputFilePath) throws Exception {
        return InstanceTools.convertFromUCRtoARFF(inputFilePath, null, null);
    }

    public static Instances convertFromUCRtoARFF(String inputFilePath, String outputRelationName, String fullOutputPath) throws Exception {
        File input = new File(inputFilePath);
        if (!input.exists()) {
            throw new Exception("Error converting to ARFF - input file not found: " + input.getAbsolutePath());
        }
        Scanner scan = new Scanner(input);
        scan.useDelimiter("\n");
        String firstIns = scan.next();
        int numAtts = firstIns.split(",").length;
        ArrayList<Attribute> attList = new ArrayList<Attribute>();
        for (int i = 0; i < numAtts - 1; ++i) {
            attList.add(new Attribute("att" + i));
        }
        attList.add(new Attribute("classVal"));
        Instances output = outputRelationName == null ? new Instances("temp", attList, numAtts) : new Instances(outputRelationName, attList, numAtts);
        output.setClassIndex(numAtts - 1);
        scan = new Scanner(input);
        scan.useDelimiter("\n");
        while (scan.hasNext()) {
            String[] nextIns = scan.next().split(",");
            DenseInstance d = new DenseInstance(numAtts);
            for (int a = 0; a < numAtts - 1; ++a) {
                d.setValue(a, Double.parseDouble(nextIns[a + 1]));
            }
            d.setValue(numAtts - 1, Double.parseDouble(nextIns[0]));
            output.add(d);
        }
        if (fullOutputPath != null) {
            System.out.println(fullOutputPath.substring(fullOutputPath.length() - 5, fullOutputPath.length()));
            if (!fullOutputPath.substring(fullOutputPath.length() - 5, fullOutputPath.length()).equalsIgnoreCase(".ARFF")) {
                fullOutputPath = fullOutputPath + ".ARFF";
            }
            new File(fullOutputPath).getParentFile().mkdirs();
            FileWriter out = new FileWriter(fullOutputPath);
            out.append(output.toString());
            out.close();
        }
        return output;
    }

    public static void removeConstantTrainAttributes(Instances train, Instances test) {
        int i = 0;
        while (i < train.numAttributes() - 1) {
            int j;
            for (j = 1; j < train.numInstances() && train.instance(j - 1).value(i) == train.instance(j).value(i); ++j) {
            }
            if (j == train.numInstances()) {
                train.deleteAttributeAt(i);
                test.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
    }

    public static boolean hasMissing(Instances ins) {
        for (Instance in : ins) {
            if (!in.hasMissingValue()) continue;
            return true;
        }
        return false;
    }

    public static void removeConstantAttributes(Instances test, int[] features) {
        for (int del : features) {
            test.deleteAttributeAt(del);
        }
    }

    public static int[] removeConstantTrainAttributes(Instances train) {
        int i = 0;
        LinkedList<Integer> list = new LinkedList<Integer>();
        int count = 0;
        while (i < train.numAttributes() - 1) {
            int j;
            for (j = 1; j < train.numInstances() && train.instance(j - 1).value(i) == train.instance(j).value(i); ++j) {
            }
            if (j == train.numInstances()) {
                train.deleteAttributeAt(i);
                list.add(i);
            } else {
                ++i;
            }
            ++count;
        }
        int[] del = new int[list.size()];
        count = 0;
        for (Integer in : list) {
            del[count++] = in;
        }
        return del;
    }

    public static int[] removeRedundantTrainAttributes(Instances train) {
        int i = 0;
        int minNumDifferent = 2;
        boolean remove = false;
        LinkedList<Integer> list = new LinkedList<Integer>();
        int count = 0;
        while (i < train.numAttributes() - 1) {
            remove = false;
            int j = 1;
            if (train.instance(j - 1).value(i) == train.instance(j).value(i)) {
                while (j < train.numInstances() && train.instance(j - 1).value(i) == train.instance(j).value(i)) {
                    ++j;
                }
            }
            if (j == train.numInstances()) {
                remove = true;
            } else {
                count = 0;
                for (j = 1; j < train.numInstances(); ++j) {
                    if (train.instance(j - 1).value(i) != train.instance(j).value(i)) continue;
                    ++count;
                }
                if (train.numInstances() - count < minNumDifferent + 1) {
                    remove = true;
                }
            }
            if (remove) {
                train.deleteAttributeAt(i);
                list.add(i);
            } else {
                ++i;
            }
            ++count;
        }
        int[] del = new int[list.size()];
        count = 0;
        for (Integer in : list) {
            del[count++] = in;
        }
        return del;
    }

    public static Instances subSample(Instances data, int amount, int seed) {
        if (amount < data.numClasses()) {
            System.out.println("Error: too few instances compared to classes.");
        }
        Map<Double, Instances> classBins = InstanceTools.createClassInstancesMap(data);
        TreeSetClassDistribution trainDistribution = new TreeSetClassDistribution(data);
        Random r = new Random(seed);
        Instances output = new Instances(data, 0);
        for (double classVal : classBins.keySet()) {
            int occurences = ((ClassDistribution)trainDistribution).get(classVal);
            float proportion = (float)occurences / (float)data.numInstances();
            int numInstances = (int)(proportion * (float)amount);
            Instances bin = classBins.get(classVal);
            bin.randomize(r);
            output.addAll(bin.subList(0, numInstances));
        }
        return output;
    }

    public static Instances subSampleFixedProportion(Instances data, double proportion, long seed) {
        Map<Double, Instances> classBins = InstanceTools.createClassInstancesMap(data);
        TreeSetClassDistribution trainDistribution = new TreeSetClassDistribution(data);
        Random r = new Random(seed);
        Instances output = new Instances(data, 0);
        for (double classVal : ((ClassDistribution)trainDistribution).keySet()) {
            int occurences = ((ClassDistribution)trainDistribution).get(classVal);
            int numInstances = (int)(proportion * (double)occurences);
            Instances bin = classBins.get(classVal);
            bin.randomize(r);
            output.addAll(bin.subList(0, numInstances));
        }
        return output;
    }

    public static double calculateSubSampleProportion(Instances train, int min) {
        int small_sf = InstanceTools.findSmallestClassAmount(train);
        double proportion = 1.0;
        if (small_sf > min && (proportion = (double)min / (double)small_sf) < 0.1) {
            proportion = 0.1;
        }
        return proportion;
    }

    public static int findSmallestClassAmount(Instances data) {
        TreeSetClassDistribution trainDistribution = new TreeSetClassDistribution(data);
        Iterator<Double> keys = ((ClassDistribution)trainDistribution).keySet().iterator();
        int small_sf = Integer.MAX_VALUE;
        while (keys.hasNext()) {
            double key = keys.next();
            int occurences = ((ClassDistribution)trainDistribution).get(key);
            if (occurences >= small_sf) continue;
            small_sf = occurences;
        }
        return small_sf;
    }

    public static int indexOf(Instances dataset, Instance find) {
        int index = -1;
        for (int i = 0; i < dataset.numInstances(); ++i) {
            Instance in = dataset.get(i);
            boolean match = true;
            for (int j = 0; j < in.numAttributes(); ++j) {
                if (in.value(j) == find.value(j)) continue;
                match = false;
            }
            if (!match) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOf2(Instances dataset, Instance find) {
        int index = -1;
        for (int i = 0; i < dataset.numInstances(); ++i) {
            if (!dataset.instance(i).toString(0).contains(find.toString(0))) continue;
            index = i;
            break;
        }
        return index;
    }

    public static Instances mergeInstances(String dataset, Instances[] inst, String[] dimChars) {
        FastVector<Attribute> atts = new FastVector<Attribute>();
        Instances firstInst = inst[0];
        int dimensions = inst.length;
        int length = (firstInst.numAttributes() - 1) * dimensions;
        for (int i = 0; i < length; ++i) {
            String name = dataset + "_" + dimChars[i % dimensions] + "_" + i / dimensions;
            atts.addElement(new Attribute(name));
        }
        Attribute target = firstInst.attribute(firstInst.classIndex());
        FastVector<String> vals = new FastVector<String>(target.numValues());
        for (int i = 0; i < target.numValues(); ++i) {
            vals.addElement(target.value(i));
        }
        atts.addElement(new Attribute(firstInst.attribute(firstInst.classIndex()).name(), vals));
        Instances result = new Instances(dataset + "_merged", atts, firstInst.numInstances());
        int size = result.numAttributes() - 1;
        for (int i = 0; i < firstInst.numInstances(); ++i) {
            result.add(new DenseInstance(size + 1));
            int j = 0;
            while (j < size) {
                for (int k = 0; k < dimensions; ++k) {
                    result.instance(i).setValue(j, inst[k].get(i).value(j / dimensions));
                    ++j;
                }
            }
        }
        for (int j = 0; j < result.numInstances(); ++j) {
            result.instance(j).setValue(size, firstInst.get(j).classValue());
        }
        return result;
    }
}

