/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.function.Consumer;

public interface DebugPrinting {
    public static final Consumer<String> printer = s -> System.out.print((String)s);
    public static final Consumer<String> printlner = s -> System.out.println((String)s);
    public static final Consumer<String> nothing_placeholder = s -> {};
    public static final Consumer[] printers = new Consumer[]{nothing_placeholder, nothing_placeholder};

    default public void setDebugPrinting(boolean b) {
        if (b) {
            DebugPrinting.printers[0] = printer;
            DebugPrinting.printers[1] = printlner;
        } else {
            DebugPrinting.printers[0] = nothing_placeholder;
            DebugPrinting.printers[1] = nothing_placeholder;
        }
    }

    default public boolean getDebugPrinting() {
        return printers[0] == nothing_placeholder;
    }

    default public void printDebug(String str) {
        printers[0].accept(str);
    }

    default public void printlnDebug(String str) {
        printers[1].accept(str);
    }
}

