/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import ResultsProcessing.MatlabController;
import ResultsProcessing.ResultColumn;
import ResultsProcessing.ResultTable;
import development.MultipleClassifiersPairwiseTest;
import fileIO.OutFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Scanner;
import java.util.function.Function;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import statistics.tests.OneSampleTests;
import statistics.tests.TwoSampleTests;
import utilities.ClassifierResults;
import utilities.StatisticalUtilities;
import utilities.generic_storage.Pair;

public class ClassifierResultsAnalysis {
    protected static String matlabFilePath = "matlabfiles/";
    protected static String pairwiseScatterDiaPath = "PairwiseScatterDias/";
    protected static String cdDiaPath = "cddias/";
    public static double FRIEDMANCDDIA_PVAL = 0.05;
    public static boolean buildMatlabDiagrams = false;
    public static boolean testResultsOnly = false;
    protected static final Function<ClassifierResults, Double> getAccs = cr -> cr.acc;
    protected static final Function<ClassifierResults, Double> getBalAccs = cr -> cr.balancedAcc;
    protected static final Function<ClassifierResults, Double> getAUROCs = cr -> cr.meanAUROC;
    protected static final Function<ClassifierResults, Double> getNLLs = cr -> cr.nll;
    protected static final Function<ClassifierResults, Double> getF1s = cr -> cr.f1;
    protected static final Function<ClassifierResults, Double> getPrecisions = cr -> cr.precision;
    protected static final Function<ClassifierResults, Double> getRecalls = cr -> cr.recall;
    protected static final Function<ClassifierResults, Double> getSensitivities = cr -> cr.sensitivity;
    protected static final Function<ClassifierResults, Double> getSpecificities = cr -> cr.specificity;
    private static final String testLabel = "TEST";
    private static final String trainLabel = "TRAIN";
    private static final String trainTestDiffLabel = "TRAINTESTDIFFS";

    public static ArrayList<Pair<String, Function<ClassifierResults, Double>>> getDefaultStatistics() {
        ArrayList<Pair<String, Function<ClassifierResults, Double>>> stats = new ArrayList<Pair<String, Function<ClassifierResults, Double>>>();
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("ACC", getAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("BALACC", getBalAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("AUROC", getAUROCs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("NLL", getNLLs));
        return stats;
    }

    public static ArrayList<Pair<String, Function<ClassifierResults, Double>>> getAllStatistics() {
        ArrayList<Pair<String, Function<ClassifierResults, Double>>> stats = new ArrayList<Pair<String, Function<ClassifierResults, Double>>>();
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("ACC", getAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("BALACC", getBalAccs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("AUROC", getAUROCs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("NLL", getNLLs));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("F1", getF1s));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("Prec", getPrecisions));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("Recall", getRecalls));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("Sens", getSensitivities));
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("Spec", getSpecificities));
        return stats;
    }

    public static ArrayList<Pair<String, Function<ClassifierResults, Double>>> getAccuracyStatisticOnly() {
        ArrayList<Pair<String, Function<ClassifierResults, Double>>> stats = new ArrayList<Pair<String, Function<ClassifierResults, Double>>>();
        stats.add(new Pair<String, Function<ClassifierResults, Double>>("ACC", getAccs));
        return stats;
    }

    protected static void writeTableFile(String filename, String tableName, double[][] accs, String[] cnames, String[] dsets) {
        OutFile out = new OutFile(filename);
        out.writeLine(tableName + ":" + ClassifierResultsAnalysis.tabulate(accs, cnames, dsets));
        out.closeFile();
    }

    protected static void writeTableFileRaw(String filename, double[][] accs, String[] cnames) {
        OutFile out = new OutFile(filename);
        out.writeLine(ClassifierResultsAnalysis.tabulateRaw(accs, cnames));
        out.closeFile();
    }

    protected static String[] writeStatisticSummaryFile(String outPath, String filename, String statName, double[][][] statPerFold, double[][] statPerDset, double[][] ranks, double[][] stddevsFoldAccs, String[] cnames, String[] dsets) {
        StringBuilder suppressedSummaryStats = new StringBuilder();
        suppressedSummaryStats.append(ClassifierResultsAnalysis.header(cnames)).append("\n");
        suppressedSummaryStats.append("Avg" + statName + ":").append(ClassifierResultsAnalysis.mean(statPerDset)).append("\n");
        suppressedSummaryStats.append("Avg" + statName + "_RANK:").append(ClassifierResultsAnalysis.mean(ranks)).append("\n");
        StringBuilder summaryStats = new StringBuilder();
        summaryStats.append(statName).append(ClassifierResultsAnalysis.header(cnames)).append("\n");
        summaryStats.append("avgOverDsets:").append(ClassifierResultsAnalysis.mean(statPerDset)).append("\n");
        summaryStats.append("stddevOverDsets:").append(ClassifierResultsAnalysis.stddev(statPerDset)).append("\n");
        summaryStats.append("avgStddevsOverFolds:").append(ClassifierResultsAnalysis.mean(stddevsFoldAccs)).append("\n");
        summaryStats.append("avgRankOverDsets:").append(ClassifierResultsAnalysis.mean(ranks)).append("\n");
        summaryStats.append("stddevsRankOverDsets:").append(ClassifierResultsAnalysis.stddev(ranks)).append("\n");
        String[] wdl = ClassifierResultsAnalysis.winsDrawsLosses(statPerDset, cnames, dsets);
        String[] sig01wdl = ClassifierResultsAnalysis.sigWinsDrawsLosses(0.01, statPerDset, statPerFold, cnames, dsets);
        String[] sig05wdl = ClassifierResultsAnalysis.sigWinsDrawsLosses(0.05, statPerDset, statPerFold, cnames, dsets);
        new File(outPath + "/WinsDrawsLosses/").mkdir();
        OutFile outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_listWDLFLAT_" + statName + ".csv");
        outwdl.writeLine(wdl[1]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_listWDLSig01_" + statName + ".csv");
        outwdl.writeLine(sig01wdl[1]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_listWDLSig05_" + statName + ".csv");
        outwdl.writeLine(sig05wdl[1]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_tableWDLFLAT_" + statName + ".csv");
        outwdl.writeLine(wdl[2]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_tableWDLSig01_" + statName + ".csv");
        outwdl.writeLine(sig01wdl[2]);
        outwdl.closeFile();
        outwdl = new OutFile(outPath + "/WinsDrawsLosses/" + filename + "_tableWDLSig05_" + statName + ".csv");
        outwdl.writeLine(sig05wdl[2]);
        outwdl.closeFile();
        OutFile out = new OutFile(outPath + filename + "_" + statName + "_SUMMARY.csv");
        out.writeLine(summaryStats.toString());
        out.writeLine(wdl[0]);
        out.writeLine("\n");
        out.writeLine(sig01wdl[0]);
        out.writeLine("\n");
        out.writeLine(sig05wdl[0]);
        out.writeLine("\n");
        String cliques = "";
        try {
            out.writeLine(MultipleClassifiersPairwiseTest.runTests(outPath + filename + "_" + statName + ".csv").toString());
            cliques = MultipleClassifiersPairwiseTest.printCliques();
            out.writeLine("\n\n" + cliques);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        out.closeFile();
        return new String[]{summaryStats.toString(), suppressedSummaryStats.toString(), cliques};
    }

    protected static String cdFileName(String filename, String statistic) {
        return "cd_" + filename + "_" + statistic + "S";
    }

    protected static String pwsFileName(String filename, String statistic) {
        return "pws_" + filename + "_" + statistic + "S";
    }

    protected static String pwsIndFileName(String c1, String c2, String statistic) {
        return "pws_" + c1 + "VS" + c2 + "_" + statistic + "S";
    }

    protected static String[] writeStatisticOnSplitFiles(String outPath, String filename, String evalSet, String statName, double[][][] foldVals, String[] cnames, String[] dsets) {
        outPath = outPath + evalSet + "/";
        double[][] dsetVals = ClassifierResultsAnalysis.findAvgsOverFolds(foldVals);
        double[][] stddevsFoldVals = ClassifierResultsAnalysis.findStddevsOverFolds(foldVals);
        double[][] ranks = ClassifierResultsAnalysis.findRanks(dsetVals);
        ClassifierResultsAnalysis.writePerFoldFiles(outPath + evalSet + "FOLD" + statName + "S/", foldVals, cnames, dsets, evalSet);
        int[] ordering = ClassifierResultsAnalysis.findOrdering(ranks);
        ranks = ClassifierResultsAnalysis.order(ranks, ordering);
        cnames = ClassifierResultsAnalysis.order(cnames, ordering);
        foldVals = ClassifierResultsAnalysis.order(foldVals, ordering);
        dsetVals = ClassifierResultsAnalysis.order(dsetVals, ordering);
        stddevsFoldVals = ClassifierResultsAnalysis.order(stddevsFoldVals, ordering);
        if (evalSet.equalsIgnoreCase(testLabel)) {
            String cdFolder = new File(outPath).getParentFile().getParent() + "/cddias/";
            new File(cdFolder).mkdirs();
            OutFile out = new OutFile(cdFolder + "readme.txt");
            out.writeLine("remember that nlls are auto-negated now for cd dia ordering\n");
            out.writeLine("and that basic notepad wont show the line breaks properly, view (cliques especially) in notepad++");
            out.closeFile();
            for (String subFolder : new String[]{"pairwise", "friedman"}) {
                new File(cdFolder + subFolder + "/").mkdirs();
                String cdName = cdFolder + subFolder + "/" + ClassifierResultsAnalysis.cdFileName(filename, statName) + ".csv";
                if (statName.contains("NLL")) {
                    double[][] negatedDsetVals = new double[dsetVals.length][dsetVals[0].length];
                    for (int i = 0; i < dsetVals.length; ++i) {
                        for (int j = 0; j < dsetVals[i].length; ++j) {
                            negatedDsetVals[i][j] = dsetVals[i][j] * -1.0;
                        }
                    }
                    ClassifierResultsAnalysis.writeTableFileRaw(cdName, negatedDsetVals, cnames);
                    continue;
                }
                ClassifierResultsAnalysis.writeTableFileRaw(cdName, dsetVals, cnames);
            }
            String pwsFolder = new File(outPath).getParentFile().getParent() + "/" + pairwiseScatterDiaPath;
            new File(pwsFolder).mkdirs();
            String pwsName = pwsFolder + ClassifierResultsAnalysis.pwsFileName(filename, statName) + ".csv";
            ClassifierResultsAnalysis.writeTableFileRaw(pwsName, dsetVals, cnames);
        }
        ClassifierResultsAnalysis.writeTableFile(outPath + filename + "_" + evalSet + statName + "RANKS.csv", evalSet + statName + "RANKS", ranks, cnames, dsets);
        ClassifierResultsAnalysis.writeTableFile(outPath + filename + "_" + evalSet + statName + ".csv", evalSet + statName, dsetVals, cnames, dsets);
        ClassifierResultsAnalysis.writeTableFileRaw(outPath + filename + "_" + evalSet + statName + "RAW.csv", dsetVals, cnames);
        ClassifierResultsAnalysis.writeTableFile(outPath + filename + "_" + evalSet + statName + "STDDEVS.csv", evalSet + statName + "STDDEVS", stddevsFoldVals, cnames, dsets);
        return ClassifierResultsAnalysis.writeStatisticSummaryFile(outPath, filename, evalSet + statName, foldVals, dsetVals, ranks, stddevsFoldVals, cnames, dsets);
    }

    public static void summariseTestAccuracies(String outPath, String filename, double[][][] testFolds, String[] cnames, String[] dsets) {
        ClassifierResultsAnalysis.writeStatisticOnSplitFiles(outPath, filename, testLabel, "ACC", testFolds, cnames, dsets);
    }

    protected static String[] writeStatisticFiles(String outPath, String filename, ArrayList<ClassifierEvaluation> results, Pair<String, Function<ClassifierResults, Double>> evalStatistic, String[] cnames, String[] dsets) {
        String statName = (String)evalStatistic.var1;
        outPath = outPath + statName + "/";
        new File(outPath).mkdirs();
        double[][][] testFolds = ClassifierResultsAnalysis.getInfo(results, (Function)evalStatistic.var2, testLabel);
        if (!testResultsOnly) {
            double[][][] trainFolds = ClassifierResultsAnalysis.getInfo(results, (Function)evalStatistic.var2, trainLabel);
            double[][][] trainTestDiffsFolds = ClassifierResultsAnalysis.findTrainTestDiffs(trainFolds, testFolds);
            ClassifierResultsAnalysis.writeStatisticOnSplitFiles(outPath, filename, trainLabel, statName, trainFolds, cnames, dsets);
            ClassifierResultsAnalysis.writeStatisticOnSplitFiles(outPath, filename, trainTestDiffLabel, statName, trainTestDiffsFolds, cnames, dsets);
        }
        return ClassifierResultsAnalysis.writeStatisticOnSplitFiles(outPath, filename, testLabel, statName, testFolds, cnames, dsets);
    }

    public static void writeAllEvaluationFiles(String outPath, String expname, ArrayList<ClassifierEvaluation> results, String[] dsets) {
        ClassifierResultsAnalysis.writeAllEvaluationFiles(outPath, expname, ClassifierResultsAnalysis.getDefaultStatistics(), results, dsets);
    }

    public static void writeAllEvaluationFiles(String outPath, String expname, ArrayList<Pair<String, Function<ClassifierResults, Double>>> statistics, ArrayList<ClassifierEvaluation> results, String[] dsets) {
        MultipleClassifiersPairwiseTest.beQuiet = true;
        OneSampleTests.beQuiet = true;
        outPath = outPath + expname + "/";
        new File(outPath).mkdirs();
        OutFile bigSummary = new OutFile(outPath + expname + "_BIGglobalSummary.csv");
        OutFile smallSummary = new OutFile(outPath + expname + "_SMALLglobalSummary.csv");
        String[] cnames = ClassifierResultsAnalysis.getNames(results);
        String[] statCliques = new String[statistics.size()];
        String[] statNames = new String[statistics.size()];
        for (int i = 0; i < statistics.size(); ++i) {
            Pair<String, Function<ClassifierResults, Double>> stat = statistics.get(i);
            String[] summary = ClassifierResultsAnalysis.writeStatisticFiles(outPath, expname, results, stat, cnames, dsets);
            bigSummary.writeString((String)stat.var1 + ":");
            bigSummary.writeLine(summary[0]);
            smallSummary.writeString((String)stat.var1 + ":");
            smallSummary.writeLine(summary[1]);
            statNames[i] = (String)stat.var1;
            statCliques[i] = summary[2];
        }
        bigSummary.closeFile();
        smallSummary.closeFile();
        ClassifierResultsAnalysis.buildResultsSpreadsheet(outPath, expname, statistics);
        ClassifierResultsAnalysis.writeCliqueHelperFiles(outPath + "/cdDias/pairwise/", expname, statNames, statCliques);
        if (buildMatlabDiagrams) {
            ClassifierResultsAnalysis.buildCDDias(outPath, expname, statNames, statCliques);
            ClassifierResultsAnalysis.buildPairwiseScatterDiagrams(outPath, expname, statNames, dsets);
        }
    }

    protected static void writeCliqueHelperFiles(String cdCSVpath, String expname, String[] stats, String[] cliques) {
        for (int i = 0; i < stats.length; ++i) {
            OutFile out = new OutFile(cdCSVpath + ClassifierResultsAnalysis.cdFileName(expname, stats[i]) + "_cliques.txt");
            out.writeString(cliques[i]);
            out.closeFile();
        }
    }

    protected static void buildCDDias(String outpath, String expname, String[] stats, String[] cliques) {
        MatlabController proxy = MatlabController.getInstance();
        proxy.eval("addpath(genpath('" + matlabFilePath + "'))");
        proxy.eval("buildDiasInDirectory('" + outpath + "/cdDias/friedman/" + "', 0, " + FRIEDMANCDDIA_PVAL + ")");
        proxy.eval("buildDiasInDirectory('" + outpath + "/cdDias/pairwise/" + "', 1)");
    }

    protected static void writePerFoldFiles(String outPath, double[][][] folds, String[] cnames, String[] dsets, String splitLabel) {
        new File(outPath).mkdirs();
        StringBuilder headers = new StringBuilder("folds:");
        for (int f = 0; f < folds[0][0].length; ++f) {
            headers.append("," + f);
        }
        for (int c = 0; c < folds.length; ++c) {
            OutFile out = new OutFile(outPath + cnames[c] + "_" + splitLabel + "FOLDS.csv");
            out.writeLine(headers.toString());
            for (int d = 0; d < folds[c].length; ++d) {
                out.writeString(dsets[d]);
                for (int f = 0; f < folds[c][d].length; ++f) {
                    out.writeString("," + folds[c][d][f]);
                }
                out.writeLine("");
            }
            out.closeFile();
        }
        OutFile out = new OutFile(outPath + "TEXASPLOT_" + splitLabel + ".csv");
        out.writeString(cnames[0]);
        for (int c = 1; c < cnames.length; ++c) {
            out.writeString("," + cnames[c]);
        }
        out.writeLine("");
        for (int d = 0; d < dsets.length; ++d) {
            for (int f = 0; f < folds[0][0].length; ++f) {
                out.writeDouble(folds[0][d][f]);
                for (int c = 1; c < cnames.length; ++c) {
                    out.writeString("," + folds[c][d][f]);
                }
                out.writeLine("");
            }
        }
        out.closeFile();
    }

    protected static String tabulate(double[][] res, String[] cnames, String[] dsets) {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassifierResultsAnalysis.header(cnames));
        for (int i = 0; i < res[0].length; ++i) {
            sb.append("\n").append(dsets[i]);
            for (int j = 0; j < res.length; ++j) {
                sb.append("," + res[j][i]);
            }
        }
        return sb.toString();
    }

    protected static String tabulateRaw(double[][] res, String[] cnames) {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassifierResultsAnalysis.header(cnames).substring(1));
        for (int i = 0; i < res[0].length; ++i) {
            sb.append("\n").append(res[0][i]);
            for (int j = 1; j < res.length; ++j) {
                sb.append("," + res[j][i]);
            }
        }
        return sb.toString();
    }

    protected static String header(String[] names) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            sb.append(",").append(names[i]);
        }
        return sb.toString();
    }

    protected static String mean(double[][] res) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < res.length; ++i) {
            sb.append(",").append(StatisticalUtilities.mean(res[i], false));
        }
        return sb.toString();
    }

    protected static String stddev(double[][] res) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < res.length; ++i) {
            sb.append(",").append(StatisticalUtilities.standardDeviation(res[i], false, StatisticalUtilities.mean(res[i], false)));
        }
        return sb.toString();
    }

    protected static double[][][] findTrainTestDiffs(double[][][] trainFoldAccs, double[][][] testFoldAccs) {
        double[][][] diffs = new double[trainFoldAccs.length][trainFoldAccs[0].length][trainFoldAccs[0][0].length];
        for (int c = 0; c < diffs.length; ++c) {
            for (int d = 0; d < diffs[c].length; ++d) {
                for (int f = 0; f < diffs[c][d].length; ++f) {
                    diffs[c][d][f] = trainFoldAccs[c][d][f] - testFoldAccs[c][d][f];
                }
            }
        }
        return diffs;
    }

    protected static double[][] findAvgsOverFolds(double[][][] foldaccs) {
        double[][] accs = new double[foldaccs.length][foldaccs[0].length];
        for (int i = 0; i < accs.length; ++i) {
            for (int j = 0; j < accs[i].length; ++j) {
                accs[i][j] = StatisticalUtilities.mean(foldaccs[i][j], false);
            }
        }
        return accs;
    }

    protected static double[][] findStddevsOverFolds(double[][][] foldaccs) {
        double[][] devs = new double[foldaccs.length][foldaccs[0].length];
        for (int i = 0; i < devs.length; ++i) {
            for (int j = 0; j < devs[i].length; ++j) {
                devs[i][j] = StatisticalUtilities.standardDeviation(foldaccs[i][j], false, StatisticalUtilities.mean(foldaccs[i][j], false));
            }
        }
        return devs;
    }

    protected static int[] findOrdering(double[][] r) {
        double[] avgranks = new double[r.length];
        for (int i = 0; i < r.length; ++i) {
            avgranks[i] = StatisticalUtilities.mean(r[i], false);
        }
        double[] cpy = Arrays.copyOf(avgranks, avgranks.length);
        int[] res = new int[avgranks.length];
        int i = 0;
        while (i < res.length) {
            ArrayList<Integer> mins = ClassifierResultsAnalysis.min(avgranks);
            for (int j = 0; j < mins.size(); ++j) {
                res[mins.get((int)j).intValue()] = i++;
                avgranks[mins.get((int)j).intValue()] = Double.MAX_VALUE;
            }
        }
        return res;
    }

    protected static int[] findReverseOrdering(double[][] r) {
        double[] avgranks = new double[r.length];
        for (int i = 0; i < r.length; ++i) {
            avgranks[i] = StatisticalUtilities.mean(r[i], false);
        }
        double[] cpy = Arrays.copyOf(avgranks, avgranks.length);
        int[] res = new int[avgranks.length];
        int i = 0;
        while (i < res.length) {
            ArrayList<Integer> maxs = ClassifierResultsAnalysis.max(avgranks);
            for (int j = 0; j < maxs.size(); ++j) {
                res[maxs.get((int)j).intValue()] = i++;
                avgranks[maxs.get((int)j).intValue()] = -1.7976931348623157E308;
            }
        }
        return res;
    }

    protected static ArrayList<Integer> min(double[] d) {
        double min = d.length + 1;
        ArrayList<Integer> minIndices = null;
        for (int c = 0; c < d.length; ++c) {
            if (d[c] < min) {
                min = d[c];
                minIndices = new ArrayList<Integer>();
                minIndices.add(c);
                continue;
            }
            if (d[c] != min) continue;
            minIndices.add(c);
        }
        return minIndices;
    }

    protected static ArrayList<Integer> max(double[] d) {
        double max = -1.0;
        ArrayList<Integer> maxIndices = null;
        for (int c = 0; c < d.length; ++c) {
            if (d[c] > max) {
                max = d[c];
                maxIndices = new ArrayList<Integer>();
                maxIndices.add(c);
                continue;
            }
            if (d[c] != max) continue;
            maxIndices.add(c);
        }
        return maxIndices;
    }

    protected static String[] order(String[] s, int[] ordering) {
        String[] res = new String[s.length];
        for (int i = 0; i < ordering.length; ++i) {
            res[ordering[i]] = s[i];
        }
        return res;
    }

    protected static double[][] order(double[][] s, int[] ordering) {
        double[][] res = new double[s.length][];
        for (int i = 0; i < ordering.length; ++i) {
            res[ordering[i]] = s[i];
        }
        return res;
    }

    protected static double[][][] order(double[][][] s, int[] ordering) {
        double[][][] res = new double[s.length][][];
        for (int i = 0; i < ordering.length; ++i) {
            res[ordering[i]] = s[i];
        }
        return res;
    }

    protected static double[][] findRanks(double[][] accs) {
        double[][] ranks = new double[accs.length][accs[0].length];
        for (int d = 0; d < accs[0].length; ++d) {
            int c;
            Double[] a = new Double[accs.length];
            for (int c2 = 0; c2 < accs.length; ++c2) {
                a[c2] = accs[c2][d];
            }
            Arrays.sort(a, Collections.reverseOrder());
            boolean numTies = false;
            double lastAcc = -1.0;
            for (int c1 = 0; c1 < accs.length; ++c1) {
                for (int c2 = 0; c2 < accs.length; ++c2) {
                    if (a[c1] != accs[c2][d]) continue;
                    ranks[c2][d] = c1;
                }
            }
            int[] hist = new int[accs.length];
            for (c = 0; c < accs.length; ++c) {
                int n = (int)ranks[c][d];
                hist[n] = hist[n] + 1;
            }
            for (int r = 0; r < hist.length; ++r) {
                if (hist[r] <= 1) continue;
                double newRank = 0.0;
                for (int i = 0; i < hist[r]; ++i) {
                    newRank += (double)(r - i);
                }
                newRank /= (double)hist[r];
                for (int c3 = 0; c3 < ranks.length; ++c3) {
                    if (ranks[c3][d] != (double)r) continue;
                    ranks[c3][d] = newRank;
                }
            }
            for (c = 0; c < accs.length; ++c) {
                double[] dArray = ranks[c];
                int n = d;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        return ranks;
    }

    protected static String[] winsDrawsLosses(double[][] accs, String[] cnames, String[] dsets) {
        StringBuilder table = new StringBuilder();
        ArrayList wdlList = new ArrayList();
        ArrayList<String> wdlListNames = new ArrayList<String>();
        String[][] wdlPlusMinus = new String[cnames.length * cnames.length][dsets.length];
        table.append("flat" + ClassifierResultsAnalysis.header(cnames)).append("\n");
        int count = 0;
        for (int c1 = 0; c1 < accs.length; ++c1) {
            table.append(cnames[c1]);
            for (int c2 = 0; c2 < accs.length; ++c2) {
                wdlListNames.add(cnames[c1] + "_VS_" + cnames[c2]);
                wdlList.add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                int wins = 0;
                int draws = 0;
                int losses = 0;
                for (int d = 0; d < dsets.length; ++d) {
                    if (accs[c1][d] > accs[c2][d]) {
                        ++wins;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(0)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "1";
                        continue;
                    }
                    if (accs[c1][d] == accs[c2][d]) {
                        ++draws;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(1)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "0";
                        continue;
                    }
                    ++losses;
                    ((ArrayList)((ArrayList)wdlList.get(count)).get(2)).add(dsets[d]);
                    wdlPlusMinus[count][d] = "-1";
                }
                table.append("," + wins + "|" + draws + "|" + losses);
                ++count;
            }
            table.append("\n");
        }
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < wdlListNames.size(); ++i) {
            list.append((String)wdlListNames.get(i));
            list.append("\n");
            list.append("Wins(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(0)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(0)) {
                list.append(",").append(dset);
            }
            list.append("\n");
            list.append("Draws(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(1)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(1)) {
                list.append(",").append(dset);
            }
            list.append("\n");
            list.append("Losses(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(2)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(2)) {
                list.append(",").append(dset);
            }
            list.append("\n\n");
        }
        StringBuilder plusMinuses = new StringBuilder();
        for (int j = 0; j < wdlPlusMinus.length; ++j) {
            plusMinuses.append(",").append((String)wdlListNames.get(j));
        }
        for (int i = 0; i < dsets.length; ++i) {
            plusMinuses.append("\n").append(dsets[i]);
            for (int j = 0; j < wdlPlusMinus.length; ++j) {
                plusMinuses.append(",").append(wdlPlusMinus[j][i]);
            }
        }
        return new String[]{table.toString(), list.toString(), plusMinuses.toString()};
    }

    protected static String[] sigWinsDrawsLosses(double pval, double[][] accs, double[][][] foldAccs, String[] cnames, String[] dsets) {
        StringBuilder table = new StringBuilder();
        ArrayList wdlList = new ArrayList();
        ArrayList<String> wdlListNames = new ArrayList<String>();
        String[][] wdlPlusMinus = new String[cnames.length * cnames.length][dsets.length];
        table.append("p=" + pval + ClassifierResultsAnalysis.header(cnames)).append("\n");
        int count = 0;
        for (int c1 = 0; c1 < foldAccs.length; ++c1) {
            table.append(cnames[c1]);
            for (int c2 = 0; c2 < foldAccs.length; ++c2) {
                wdlListNames.add(cnames[c1] + "_VS_" + cnames[c2]);
                wdlList.add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                ((ArrayList)wdlList.get(count)).add(new ArrayList());
                int wins = 0;
                int draws = 0;
                int losses = 0;
                for (int d = 0; d < dsets.length; ++d) {
                    if (accs[c1][d] == accs[c2][d]) {
                        ++draws;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(1)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "0";
                        continue;
                    }
                    double p = TwoSampleTests.studentT_PValue(foldAccs[c1][d], foldAccs[c2][d]);
                    if (p > pval) {
                        ++draws;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(1)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "0";
                        continue;
                    }
                    if (accs[c1][d] > accs[c2][d]) {
                        ++wins;
                        ((ArrayList)((ArrayList)wdlList.get(count)).get(0)).add(dsets[d]);
                        wdlPlusMinus[count][d] = "1";
                        continue;
                    }
                    ++losses;
                    ((ArrayList)((ArrayList)wdlList.get(count)).get(2)).add(dsets[d]);
                    wdlPlusMinus[count][d] = "-1";
                }
                table.append("," + wins + "|" + draws + "|" + losses);
                ++count;
            }
            table.append("\n");
        }
        StringBuilder list = new StringBuilder();
        for (int i = 0; i < wdlListNames.size(); ++i) {
            list.append((String)wdlListNames.get(i));
            list.append("\n");
            list.append("Wins(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(0)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(0)) {
                list.append(",").append(dset);
            }
            list.append("\n");
            list.append("Draws(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(1)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(1)) {
                list.append(",").append(dset);
            }
            list.append("\n");
            list.append("Losses(" + ((ArrayList)((ArrayList)wdlList.get(i)).get(2)).size() + "):");
            for (String dset : (ArrayList)((ArrayList)wdlList.get(i)).get(2)) {
                list.append(",").append(dset);
            }
            list.append("\n\n");
        }
        StringBuilder plusMinuses = new StringBuilder();
        for (int j = 0; j < wdlPlusMinus.length; ++j) {
            plusMinuses.append(",").append((String)wdlListNames.get(j));
        }
        for (int i = 0; i < dsets.length; ++i) {
            plusMinuses.append("\n").append(dsets[i]);
            for (int j = 0; j < wdlPlusMinus.length; ++j) {
                plusMinuses.append(",").append(wdlPlusMinus[j][i]);
            }
        }
        return new String[]{table.toString(), list.toString(), plusMinuses.toString()};
    }

    protected static double[][][] getInfo(ArrayList<ClassifierEvaluation> res, Function<ClassifierResults, Double> getter, String trainortest) {
        double[][][] info = new double[res.size()][res.get((int)0).testResults.length][res.get((int)0).testResults[0].length];
        for (int i = 0; i < res.size(); ++i) {
            int k;
            int j;
            if (trainortest.equalsIgnoreCase(trainLabel)) {
                for (j = 0; j < res.get((int)i).trainResults.length; ++j) {
                    for (k = 0; k < res.get((int)i).trainResults[j].length; ++k) {
                        info[i][j][k] = getter.apply(res.get((int)i).trainResults[j][k]);
                    }
                }
                continue;
            }
            if (trainortest.equalsIgnoreCase(testLabel)) {
                for (j = 0; j < res.get((int)i).testResults.length; ++j) {
                    for (k = 0; k < res.get((int)i).testResults[j].length; ++k) {
                        info[i][j][k] = getter.apply(res.get((int)i).testResults[j][k]);
                    }
                }
                continue;
            }
            System.out.println("teh fook? getInfo(), trainortest=" + trainortest);
            System.exit(0);
        }
        return info;
    }

    protected static String[] getNames(ArrayList<ClassifierEvaluation> res) {
        String[] names = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            names[i] = res.get((int)i).classifierName;
        }
        return names;
    }

    protected static void buildResultsSpreadsheet(String basePath, String expName, ArrayList<Pair<String, Function<ClassifierResults, Double>>> statistics) {
        WritableWorkbook wb = null;
        WorkbookSettings wbs = new WorkbookSettings();
        wbs.setLocale(new Locale("en", "EN"));
        try {
            wb = Workbook.createWorkbook((File)new File(basePath + expName + "ResultsSheet.xls"), (WorkbookSettings)wbs);
        }
        catch (Exception e) {
            System.out.println("ERROR CREATING RESULTS SPREADSHEET");
            System.out.println(e);
            System.exit(0);
        }
        WritableSheet summarySheet = wb.createSheet("GlobalSummary", 0);
        String summaryCSV = basePath + expName + "_SMALLglobalSummary.csv";
        ClassifierResultsAnalysis.copyCSVIntoSheet(summarySheet, summaryCSV);
        for (int i = 0; i < statistics.size(); ++i) {
            String statName = (String)statistics.get((int)i).var1;
            String path = basePath + statName + "/";
            ClassifierResultsAnalysis.buildStatSheets(wb, expName, path, statName, i);
        }
        try {
            wb.write();
            wb.close();
        }
        catch (Exception e) {
            System.out.println("ERROR WRITING AND CLOSING RESULTS SPREADSHEET");
            System.out.println(e);
            System.exit(0);
        }
    }

    protected static void buildStatSheets(WritableWorkbook wb, String expName, String filenameprefix, String statName, int statIndex) {
        boolean initialSummarySheetOffset = true;
        int numSubStats = 3;
        int testOffset = 0;
        if (!testResultsOnly) {
            numSubStats = 5;
            testOffset = 2;
            WritableSheet trainSheet = wb.createSheet(statName + "Train", 1 + statIndex * numSubStats + 0);
            String trainCSV = filenameprefix + trainLabel + "/" + expName + "_" + trainLabel + statName + ".csv";
            ClassifierResultsAnalysis.copyCSVIntoSheet(trainSheet, trainCSV);
            WritableSheet trainTestDiffSheet = wb.createSheet(statName + "TrainTestDiffs", 1 + statIndex * numSubStats + 1);
            String trainTestDiffCSV = filenameprefix + trainTestDiffLabel + "/" + expName + "_" + trainTestDiffLabel + statName + ".csv";
            ClassifierResultsAnalysis.copyCSVIntoSheet(trainTestDiffSheet, trainTestDiffCSV);
        }
        WritableSheet testSheet = wb.createSheet(statName + "Test", 1 + statIndex * numSubStats + 0 + testOffset);
        String testCSV = filenameprefix + testLabel + "/" + expName + "_" + testLabel + statName + ".csv";
        ClassifierResultsAnalysis.copyCSVIntoSheet(testSheet, testCSV);
        WritableSheet rankSheet = wb.createSheet(statName + "TestRanks", 1 + statIndex * numSubStats + 1 + testOffset);
        String rankCSV = filenameprefix + testLabel + "/" + expName + "_" + testLabel + statName + "RANKS.csv";
        ClassifierResultsAnalysis.copyCSVIntoSheet(rankSheet, rankCSV);
        WritableSheet summarySheet = wb.createSheet(statName + "TestSigDiffs", 1 + statIndex * numSubStats + 2 + testOffset);
        String summaryCSV = filenameprefix + testLabel + "/" + expName + "_" + testLabel + statName + "_SUMMARY.csv";
        ClassifierResultsAnalysis.copyCSVIntoSheet(summarySheet, summaryCSV);
    }

    protected static void copyCSVIntoSheet(WritableSheet sheet, String csvFile) {
        try {
            Scanner fileIn = new Scanner(new File(csvFile));
            int rowInd = 0;
            while (fileIn.hasNextLine()) {
                Scanner lineIn = new Scanner(fileIn.nextLine());
                lineIn.useDelimiter(",");
                int colInd = -1;
                while (lineIn.hasNext()) {
                    ++colInd;
                    String cellContents = lineIn.next();
                    WritableFont font = new WritableFont(WritableFont.ARIAL, 10);
                    WritableCellFormat format = new WritableCellFormat(font);
                    try {
                        int iCellContents = Integer.parseInt(cellContents);
                        sheet.addCell((WritableCell)new Number(colInd, rowInd, (double)iCellContents, (CellFormat)format));
                    }
                    catch (NumberFormatException iCellContents) {
                        try {
                            double dCellContents = Double.parseDouble(cellContents);
                            sheet.addCell((WritableCell)new Number(colInd, rowInd, dCellContents, (CellFormat)format));
                        }
                        catch (NumberFormatException numberFormatException) {
                            sheet.addCell((WritableCell)new Label(colInd, rowInd, cellContents, (CellFormat)format));
                        }
                    }
                }
                ++rowInd;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR BUILDING RESULTS SPREADSHEET, COPYING CSV");
            System.out.println(e);
            System.exit(0);
        }
    }

    public static Pair<String[], double[][]> readTheFileFFS(String file, int numDsets) throws FileNotFoundException {
        ArrayList<String> cnames = new ArrayList<String>();
        Scanner in = new Scanner(new File(file));
        Scanner linein = new Scanner(in.nextLine());
        linein.useDelimiter(",");
        while (linein.hasNext()) {
            cnames.add(linein.next());
        }
        double[][] vals = new double[cnames.size()][numDsets];
        for (int d = 0; d < numDsets; ++d) {
            linein = new Scanner(in.nextLine());
            linein.useDelimiter(",");
            for (int c = 0; c < cnames.size(); ++c) {
                vals[c][d] = linein.nextDouble();
            }
        }
        return new Pair<String[], double[][]>(cnames.toArray(new String[0]), vals);
    }

    public static void buildPairwiseScatterDiagrams(String outPath, String expName, String[] statNames, String[] dsets) {
        outPath = outPath + pairwiseScatterDiaPath;
        for (String statName : statNames) {
            try {
                Pair<String[], double[][]> asd = ClassifierResultsAnalysis.readTheFileFFS(outPath + ClassifierResultsAnalysis.pwsFileName(expName, statName) + ".csv", dsets.length);
                ResultTable rt = new ResultTable(ResultTable.createColumns((String[])((String[])asd.var1), (String[])dsets, (double[][])((double[][])asd.var2)));
                int numClassiifers = rt.getColumns().size();
                MatlabController proxy = MatlabController.getInstance();
                for (int c1 = 0; c1 < numClassiifers - 1; ++c1) {
                    for (int c2 = c1 + 1; c2 < numClassiifers; ++c2) {
                        String c2name;
                        String c1name = ((ResultColumn)rt.getColumns().get(c1)).getName();
                        if (c1name.compareTo(c2name = ((ResultColumn)rt.getColumns().get(c2)).getName()) > 0) {
                            String t = c1name;
                            c1name = c2name;
                            c2name = t;
                        }
                        String pwFolderName = outPath + c1name + "vs" + c2name + "/";
                        new File(pwFolderName).mkdir();
                        ArrayList pwrl = new ArrayList(2);
                        pwrl.add(rt.getColumn(c1name).get());
                        pwrl.add(rt.getColumn(c2name).get());
                        ResultTable pwrt = new ResultTable(pwrl);
                        proxy.eval("array = [" + pwrt.toStringValues(false) + "];");
                        StringBuilder concat = new StringBuilder();
                        concat.append("'");
                        concat.append(c1name.replaceAll("_", "\\\\_"));
                        concat.append("',");
                        concat.append("'");
                        concat.append(c2name.replaceAll("_", "\\\\_"));
                        concat.append("'");
                        proxy.eval("labels = {" + concat.toString() + "}");
                        proxy.eval("pairedscatter('" + pwFolderName + ClassifierResultsAnalysis.pwsIndFileName(c1name, c2name, statName).replaceAll("\\.", "") + "',array(:,1),array(:,2),labels,'" + statName + "')");
                    }
                }
            }
            catch (Exception io) {
                System.out.println("buildPairwiseScatterDiagrams(" + outPath + ") failed loading " + statName + " file\n" + io);
            }
        }
    }

    public static class BVOnDset {
        public int numClasses;
        public int[] trueClassVals;
        public ArrayList<Integer>[] allPreds;

        public BVOnDset(int[] trueClassVals, int numClasses) {
            this.trueClassVals = trueClassVals;
            this.numClasses = numClasses;
            this.allPreds = new ArrayList[trueClassVals.length];
            for (int i = 0; i < this.allPreds.length; ++i) {
                this.allPreds[i] = new ArrayList();
            }
        }

        public void storePreds(int[] testInds, int[] testPreds) {
            for (int i = 0; i < testInds.length; ++i) {
                this.allPreds[testInds[i]].add(testPreds[i]);
            }
        }

        public int[][] getFinalPreds() {
            int[][] res = new int[this.allPreds.length][];
            for (int i = 0; i < res.length; ++i) {
                res[i] = new int[this.allPreds[i].size()];
                for (int j = 0; j < this.allPreds[i].size(); ++j) {
                    res[i][j] = this.allPreds[i].get(j);
                }
            }
            return res;
        }
    }

    public static class ClassifierEvaluation {
        public String classifierName;
        public ClassifierResults[][] testResults;
        public ClassifierResults[][] trainResults;
        public BVOnDset[] bvs;

        public ClassifierEvaluation(String name, ClassifierResults[][] testResults, ClassifierResults[][] trainResults, BVOnDset[] bvs) {
            this.classifierName = name;
            this.testResults = testResults;
            this.trainResults = trainResults;
            this.bvs = bvs;
        }
    }
}

