/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import fileIO.OutFile;
import java.util.ArrayList;
import java.util.Random;
import utilities.ClassifierTools;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.ChiSquaredAttributeEval;
import weka.attributeSelection.GainRatioAttributeEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.InfoGainAttributeEval;
import weka.attributeSelection.Ranker;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class AttributeSelectionTools {
    private AttributeSelection attSel = new AttributeSelection();
    private ASEvaluation attEval = new CfsSubsetEval();
    private ASSearch attSearch = new GreedyStepwise();
    private int numFolds = 5;

    public AttributeSelectionTools() {
        this.attSel.setEvaluator(this.attEval);
        this.attSel.setSearch(this.attSearch);
    }

    public void setEvaluation(ASEvaluation a) {
        this.attEval = a;
        this.attSel.setEvaluator(this.attEval);
    }

    public void setSearch(ASSearch s) {
        this.attSearch = s;
        this.attSel.setSearch(this.attSearch);
    }

    public static void main(String[] args) {
        AttributeSelectionTools.attributeFilterTest();
    }

    public double crossValidateAccuracy(Instances train, Classifier c, int folds) {
        double acc = 0.0;
        train.randomize(new Random());
        for (int i = 0; i < folds; ++i) {
            Instances tempTrain = train.trainCV(folds, i);
            Instances tempTest = train.testCV(folds, i);
            tempTrain = this.filterTrainSet(tempTrain);
            tempTest = this.filterTestSet(tempTest);
            try {
                c.buildClassifier(tempTrain);
            }
            catch (Exception e) {
                System.out.println("Exception thrown in attributeScoring = " + e.toString());
                e.printStackTrace();
                System.exit(0);
            }
            acc += ClassifierTools.accuracy(tempTest, c) * (double)tempTest.numInstances();
        }
        return acc /= (double)train.numInstances();
    }

    public Instances filterTrainSet(Instances train) {
        try {
            this.attSel.SelectAttributes(train);
            return this.attSel.reduceDimensionality(train);
        }
        catch (Exception e) {
            System.out.println("Exception thrown in attributeScoring = " + e.toString());
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public Instances filterTestSet(Instances test) {
        try {
            return this.attSel.reduceDimensionality(test);
        }
        catch (Exception e) {
            System.out.println("Exception thrown in attributeScoring = " + e.toString());
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public double testAccuracy(Instances test, Classifier c) {
        try {
            Instances testReduced = this.attSel.reduceDimensionality(test);
            return ClassifierTools.accuracy(testReduced, c);
        }
        catch (Exception e) {
            System.out.println(" Exception in testAccuracy =" + e);
            e.printStackTrace();
            System.exit(0);
            return 0.0;
        }
    }

    public double[][] filteredAttributePredictions(Instances train, Instances test, Classifier c) {
        double[][] testPreds = new double[test.numInstances() + 1][2];
        try {
            this.attSel.SelectAttributes(train);
            Instances trainReduced = this.attSel.reduceDimensionality(train);
            Instances testReduced = this.attSel.reduceDimensionality(test);
            double[][] preds = ClassifierTools.crossValidationWithStats(c, trainReduced, this.numFolds);
            testPreds[0][0] = preds[0][0];
            testPreds[0][1] = preds[0][1];
            for (int i = 0; i < testReduced.numInstances(); ++i) {
                testPreds[i + 1][0] = c.classifyInstance(testReduced.instance(i));
                testPreds[i + 1][1] = testReduced.instance(i).classValue();
            }
        }
        catch (Exception e) {
            System.out.println("Exception thrown in attributeScoring = " + e.toString());
            e.printStackTrace();
            System.exit(0);
        }
        return testPreds;
    }

    public static void attributeScoring(Instances tr, String file) {
        try {
            OutFile f = new OutFile(file);
            InfoGainAttributeEval as = new InfoGainAttributeEval();
            GainRatioAttributeEval as2 = new GainRatioAttributeEval();
            ChiSquaredAttributeEval as3 = new ChiSquaredAttributeEval();
            f.writeLine("INDEX,NAME,IG,IGR,CHI");
            for (int i = 0; i < tr.numAttributes(); ++i) {
                double e1 = as.evaluateAttribute(i);
                double e2 = as2.evaluateAttribute(i);
                double e3 = as3.evaluateAttribute(i);
                f.writeLine(i + "," + tr.attribute(i).name() + "," + e1 + "," + e2 + "," + e3);
                System.out.println(i + "," + tr.attribute(i).toString() + e1 + "," + e2 + "," + e3);
            }
        }
        catch (Exception e) {
            System.out.println("Exception thrown in attributeScoring = " + e.toString());
        }
    }

    public static int[] simpleAttributeRanking(Instances tr, ASEvaluation as) {
        int size = tr.numInstances() - 1;
        Object trFiltered = null;
        Ranker rank = new Ranker();
        int[] att = null;
        try {
            as.buildEvaluator(tr);
            System.out.println("Attribute Selector built");
            ((ASSearch)rank).search(as, tr);
            AttributeSelection a = new AttributeSelection();
            a.setEvaluator(as);
            a.setSearch(rank);
            System.out.println("Attribute Selector set in AttributeSelection");
            System.out.println("Attribute Selector " + a);
            System.out.println("Ranker " + rank);
            System.out.println("ASEvaluator " + as);
            a.SelectAttributes(tr);
            att = a.selectedAttributes();
        }
        catch (Exception e) {
            System.out.println(" Error in  simpleAttributeRanking  " + e.toString());
        }
        return att;
    }

    public static double[] attributeForwardSelection(Instances allData, Classifier c, double testingProportion) {
        GainRatioAttributeEval as = new GainRatioAttributeEval();
        allData.randomize(new Random());
        int size = allData.numInstances();
        int testSize = (int)(testingProportion * (double)size);
        int trainSize = size - testSize;
        Instances trainData = new Instances(allData, 0, trainSize);
        Instances testData = new Instances(allData, trainSize, testSize);
        double[] accuracies = new double[allData.numAttributes()];
        int[] atts = AttributeSelectionTools.simpleAttributeRanking(trainData, as);
        for (int i = 0; i < accuracies.length; ++i) {
            try {
                c.buildClassifier(trainData);
                accuracies[i] = ClassifierTools.accuracy(testData, c);
                System.out.println("Nos Attributes train = " + trainData.numAttributes() + "  test = " + testData.numAttributes() + " Accuracy = " + accuracies[i]);
                int removalPos = atts[atts.length - 2 - i];
                trainData.deleteAttributeAt(removalPos);
                testData.deleteAttributeAt(removalPos);
                for (int j = 0; j < atts.length; ++j) {
                    if (atts[j] < removalPos) continue;
                    int n = j;
                    atts[n] = atts[n] - 1;
                }
                continue;
            }
            catch (Exception e) {
                System.out.println("Error in build classifier XXSS");
            }
        }
        return accuracies;
    }

    public static void attributeFilterTest() {
        Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\PhalangesOutlinesCorrect\\PhalangesOutlinesCorrect_TRAIN");
        Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\PhalangesOutlinesCorrect\\PhalangesOutlinesCorrect_TEST");
        AttributeSelection attSelect = new AttributeSelection();
        CfsSubsetEval eval = new CfsSubsetEval();
        GreedyStepwise search = new GreedyStepwise();
        attSelect.setEvaluator(eval);
        attSelect.setSearch(search);
        ArrayList<String> names = new ArrayList<String>();
        Classifier[] c = ClassifierTools.setDefaultSingleClassifiers(names);
        double[] acc = new double[c.length];
        double[] acc2 = new double[c.length];
        try {
            for (int i = 0; i < c.length; ++i) {
                c[i].buildClassifier(train);
                acc[i] = ClassifierTools.accuracy(test, c[i]);
            }
            System.out.println(" Number of attributes BEFORE =" + (train.numAttributes() - 1));
            attSelect.SelectAttributes(train);
            int[] indices = attSelect.selectedAttributes();
            System.out.println(" Number Selected =" + indices.length);
            train = attSelect.reduceDimensionality(train);
            test = attSelect.reduceDimensionality(test);
            System.out.println(" Number of attributes AFTER =" + (train.numAttributes() - 1));
            for (int i = 0; i < c.length; ++i) {
                c[i].buildClassifier(train);
                acc2[i] = ClassifierTools.accuracy(test, c[i]);
                System.out.println("Full = " + acc[i] + "\t Filtered =" + acc2[i]);
            }
        }
        catch (Exception e) {
            System.out.println("Error in filter test =" + e);
            e.printStackTrace();
            System.exit(0);
        }
    }
}

