/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.Arrays;
import utilities.ClassifierTools;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.InfoGainAttributeEval;
import weka.attributeSelection.Ranker;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class AttributeFilterBridge {
    ASEvaluation eval;
    int[] attsToKeep;
    int[] allAtts;
    private ASSearch search;
    private Instances data;
    protected double prop = 0.2;
    protected int n = 0;
    private boolean useProp = false;

    private AttributeFilterBridge() {
    }

    public AttributeFilterBridge(Instances d) {
        this.data = d;
        this.eval = new InfoGainAttributeEval();
        Ranker r = new Ranker();
        this.n = (int)(this.prop * (double)this.data.numAttributes());
        if (this.n == 0) {
            ++this.n;
        }
        r.setNumToSelect(this.n);
        this.search = r;
    }

    public AttributeFilterBridge makeCopy() {
        AttributeFilterBridge newAF = new AttributeFilterBridge();
        newAF.search = this.search;
        newAF.eval = this.eval;
        return newAF;
    }

    public AttributeFilterBridge(ASEvaluation e, ASSearch s) {
        this.eval = e;
        this.search = s;
    }

    public void setNosToKeep(int nos) {
        this.useProp = false;
        this.n = nos;
        if (this.data != null) {
            this.prop = (double)this.n / (double)(this.data.numAttributes() - 1);
        }
    }

    public void setProportionToKeep(double p) {
        this.useProp = true;
        this.prop = p;
        if (this.data != null) {
            this.n = (int)(this.prop * (double)(this.data.numAttributes() - 1));
        }
    }

    public Instances filter() {
        if (this.data != null) {
            return this.filter(this.data);
        }
        return null;
    }

    public Instances filter(Instances d) {
        this.data = d;
        Instances newD = d;
        try {
            int dataPos;
            this.eval.buildEvaluator(d);
            this.allAtts = this.search.search(this.eval, d);
            if (this.useProp) {
                this.n = (int)(this.prop * (double)(d.numAttributes() - 1));
            }
            if (this.n == 0) {
                ++this.n;
            }
            int[] atts = new int[this.n];
            if (this.n < this.allAtts.length) {
                System.arraycopy(this.allAtts, 0, atts, 0, this.n);
            } else {
                atts = this.allAtts;
            }
            Arrays.sort(atts);
            newD = new Instances(d);
            int nosDeleted = 0;
            int nosKept = 0;
            for (dataPos = 0; dataPos < newD.numAttributes() - 1 && nosKept < atts.length; ++nosKept, ++dataPos) {
                while (dataPos != atts[nosKept] - nosDeleted && dataPos < newD.numAttributes() - 1) {
                    newD.deleteAttributeAt(dataPos);
                    ++nosDeleted;
                }
            }
            while (dataPos < newD.numAttributes() - 1) {
                newD.deleteAttributeAt(dataPos);
            }
            this.attsToKeep = atts;
        }
        catch (Exception e) {
            System.out.println("Exception thrown in AttributeFilterBridge =" + e);
            e.printStackTrace();
            System.exit(0);
        }
        return newD;
    }

    public Instance filterInstance(Instance ins) {
        int dataPos;
        int nosDeleted = 0;
        int nosKept = 0;
        DenseInstance newIns = new DenseInstance(ins);
        for (dataPos = 0; dataPos < newIns.numAttributes() - 1 && nosKept < this.attsToKeep.length; ++nosKept, ++dataPos) {
            while (dataPos != this.attsToKeep[nosKept] - nosDeleted && dataPos < newIns.numAttributes() - 1) {
                newIns.deleteAttributeAt(dataPos);
                ++nosDeleted;
            }
        }
        while (dataPos < newIns.numAttributes() - 1) {
            newIns.deleteAttributeAt(dataPos);
        }
        return newIns;
    }

    public String toString() {
        String str = "\n Attributes retained =";
        for (int i = 0; i < this.attsToKeep.length; ++i) {
            str = str + " " + this.attsToKeep[i];
        }
        return str;
    }

    public void rankAttributes(Instances d) {
        this.data = d;
        try {
            this.eval.buildEvaluator(d);
            this.allAtts = this.search.search(this.eval, d);
            Arrays.sort(this.allAtts);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(" Exception in trank atts");
            System.exit(0);
        }
    }

    public static void testCorrectness() {
    }

    public static void main(String[] args) {
        String path = "C:\\Research\\Data\\WekaTest\\";
        Instances beef = ClassifierTools.loadData(path + "Beef_TRAIN");
        Instances data = ClassifierTools.loadData(path + "irisSmall");
        AttributeFilterBridge af = new AttributeFilterBridge(data);
        Instances d2 = af.filter();
        AttributeFilterBridge beefFilter = new AttributeFilterBridge(beef);
        beefFilter.setProportionToKeep(0.05);
        Instances b2 = beefFilter.filter();
        System.out.println("5% number of atts = " + (b2.numAttributes() - 1));
    }
}

