/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.ImpRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.generic_storage.Pair;
import weka.core.Instance;
import weka.core.Instances;

public class TabuSearch
extends ImpRandomSearch {
    int neighbourhoodWidth = 3;
    int maxTabuSize = 50;
    int numShapeletsPerSeries;
    Shapelet bsf_shapelet;
    BitSet seriesToConsider;
    float proportion = 1.0f;

    protected TabuSearch(ShapeletSearchOptions ops) {
        super(ops);
        this.proportion = ops.getProportion();
    }

    @Override
    public void init(Instances input) {
        super.init(input);
        float subsampleSize = (float)this.inputData.numInstances() * this.proportion;
        this.numShapeletsPerSeries = (int)((float)this.numShapelets / subsampleSize);
        this.seriesToConsider = new BitSet(this.inputData.numInstances());
        if ((double)this.proportion >= 1.0) {
            this.seriesToConsider.set(0, this.inputData.numInstances(), true);
            return;
        }
        int i = 0;
        while ((float)i < subsampleSize) {
            this.seriesToConsider.set(this.random.nextInt((int)subsampleSize));
            ++i;
        }
        if (this.numShapeletsPerSeries < 1) {
            System.err.println("Too Few Starting shapelets");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        ArrayList<Shapelet> seriesShapelets = new ArrayList<Shapelet>();
        if (!this.seriesToConsider.get(this.currentSeries++)) {
            return seriesShapelets;
        }
        LinkedList<Pair> tabuList = new LinkedList<Pair>();
        int numShapeletsEvaluated = 0;
        while (this.numShapeletsPerSeries > numShapeletsEvaluated) {
            void var10_13;
            Pair<Integer, Integer> shapelet;
            if (numShapeletsEvaluated == 0 && this.bsf_shapelet != null) {
                shapelet = new Pair<Integer, Integer>(this.bsf_shapelet.length, this.bsf_shapelet.startPos);
                this.bsf_shapelet = null;
            } else {
                shapelet = this.createRandomShapelet(timeSeries);
            }
            ArrayList<Pair<Integer, Integer>> candidateList = new ArrayList<Pair<Integer, Integer>>();
            candidateList.add(shapelet);
            candidateList.addAll(this.createNeighbourhood(shapelet, timeSeries.numAttributes()));
            boolean inList = false;
            for (Pair pair : candidateList) {
                if (!tabuList.contains(pair)) continue;
                inList = true;
                break;
            }
            if (inList) continue;
            Pair bestLocal = null;
            Object var10_12 = null;
            for (Pair pair : candidateList) {
                Shapelet sh = checkCandidate.process(timeSeries, (Integer)pair.var1, (Integer)pair.var2);
                ++numShapeletsEvaluated;
                if (sh == null) continue;
                if (var10_13 == null) {
                    bestLocal = pair;
                    Shapelet shapelet2 = sh;
                }
                if (this.comparator.compare(var10_13, sh) <= 0) continue;
                bestLocal = pair;
                Shapelet shapelet3 = sh;
            }
            if (var10_13 == null) continue;
            if (this.bsf_shapelet == null) {
                this.bsf_shapelet = var10_13;
            }
            if (this.comparator.compare(this.bsf_shapelet, var10_13) > 0) {
                this.bsf_shapelet = var10_13;
                seriesShapelets.add((Shapelet)var10_13);
            }
            tabuList.add(bestLocal);
            if (tabuList.size() <= this.maxTabuSize) continue;
            tabuList.remove();
        }
        return seriesShapelets;
    }

    ArrayList<Pair<Integer, Integer>> createNeighbourhood(Pair<Integer, Integer> shapelet) {
        return this.createNeighbourhood(shapelet, this.inputData.numAttributes() - 1);
    }

    ArrayList<Pair<Integer, Integer>> createNeighbourhood(Pair<Integer, Integer> shapelet, int m) {
        ArrayList<Pair<Integer, Integer>> neighbourhood = new ArrayList<Pair<Integer, Integer>>();
        neighbourhood.add(shapelet);
        int halfWidth = (int)((double)this.neighbourhoodWidth / 2.0);
        for (int pos = -halfWidth; pos <= halfWidth; ++pos) {
            for (int len = -halfWidth; len <= halfWidth; ++len) {
                if (len == 0 && pos == 0) continue;
                int newLen = (Integer)shapelet.var1 + len;
                int newPos = (Integer)shapelet.var2 + pos;
                if (newLen < this.minShapeletLength || newLen > this.maxShapeletLength || newPos < 0 || newPos >= m - newLen + 1) continue;
                neighbourhood.add(new Pair<Integer, Integer>(newLen, newPos));
            }
        }
        return neighbourhood;
    }

    private Pair<Integer, Integer> createRandomShapelet(Instance series) {
        int numLengths = this.maxShapeletLength - this.minShapeletLength;
        int length = this.random.nextInt(numLengths) + this.minShapeletLength;
        int position = this.random.nextInt(series.numAttributes() - length);
        return new Pair<Integer, Integer>(length, position);
    }

    public static void main(String[] args) {
        ShapeletSearchOptions tabuOptions = new ShapeletSearchOptions.Builder().setMin(3).setMax(100).setNumShapelets(1000L).setSeed(0L).build();
        TabuSearch tb = new TabuSearch(tabuOptions);
        for (int len = 3; len < 100; ++len) {
            for (int pos = 0; pos < 100 - len + 1; ++pos) {
                ArrayList<Pair<Integer, Integer>> createNeighbourhood = tb.createNeighbourhood(new Pair<Integer, Integer>(len, pos), 100);
                System.out.println(createNeighbourhood);
            }
        }
    }
}

