/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.MultivariateInstanceTools;
import weka.core.Instance;
import weka.core.Instances;

public class ShapeletSearch
implements Serializable {
    ArrayList<String> shapeletsVisited = new ArrayList();
    int seriesCount;
    protected Comparator<Shapelet> comparator;
    protected int seriesLength;
    protected int minShapeletLength;
    protected int maxShapeletLength;
    protected int numDimensions;
    protected int lengthIncrement = 1;
    protected int positionIncrement = 1;
    protected Instances inputData;
    protected transient ShapeletSearchOptions options;

    public ArrayList<String> getShapeletsVisited() {
        return this.shapeletsVisited;
    }

    public void setComparator(Comparator<Shapelet> comp) {
        this.comparator = comp;
    }

    protected ShapeletSearch(ShapeletSearchOptions ops) {
        this.options = ops;
        this.minShapeletLength = ops.getMin();
        this.maxShapeletLength = ops.getMax();
        this.lengthIncrement = ops.getLengthInc();
        this.positionIncrement = ops.getPosInc();
        this.numDimensions = ops.getNumDimensions();
    }

    public void setMinAndMax(int min, int max) {
        this.minShapeletLength = min;
        this.maxShapeletLength = max;
    }

    public int getMin() {
        return this.minShapeletLength;
    }

    public int getMax() {
        return this.maxShapeletLength;
    }

    public void init(Instances input) {
        this.inputData = input;
        this.seriesLength = this.getSeriesLength();
    }

    public int getSeriesLength() {
        return this.inputData.numAttributes() >= this.maxShapeletLength ? this.inputData.numAttributes() : MultivariateInstanceTools.channelLength(this.inputData) + 1;
    }

    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ProcessCandidate checkCandidate) {
        ArrayList<Shapelet> seriesShapelets = new ArrayList<Shapelet>();
        for (int length = this.minShapeletLength; length <= this.maxShapeletLength; length += this.lengthIncrement) {
            for (int start = 0; start < this.seriesLength - length; start += this.positionIncrement) {
                for (int dim = 0; dim < this.numDimensions; ++dim) {
                    Shapelet shapelet = checkCandidate.process(this.getTimeSeries(timeSeries, dim), start, length, dim);
                    if (shapelet == null) continue;
                    seriesShapelets.add(shapelet);
                    this.shapeletsVisited.add(this.seriesCount + "," + length + "," + start + "," + shapelet.qualityValue);
                }
            }
        }
        ++this.seriesCount;
        return seriesShapelets;
    }

    protected Instance getTimeSeries(Instance timeSeries, int dim) {
        if (this.numDimensions > 1) {
            return MultivariateInstanceTools.splitMultivariateInstanceWithClassVal(timeSeries)[dim];
        }
        return timeSeries;
    }

    public static interface ProcessCandidate {
        default public Shapelet process(Instance candidate, int start, int length) {
            return this.process(candidate, start, length, 0);
        }

        public Shapelet process(Instance var1, int var2, int var3, int var4);
    }

    public static enum SearchType {
        FULL,
        FS,
        GENETIC,
        RANDOM,
        LOCAL,
        MAGNIFY,
        TIMED_RANDOM,
        SKIPPING,
        TABU,
        REFINED_RANDOM,
        IMP_RANDOM,
        SUBSAMPLE_RANDOM,
        SKEWED;

    }
}

