/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import java.util.Random;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.RandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import weka.core.Instance;

public class RandomTimedSearch
extends RandomSearch {
    protected long timeLimit;

    protected RandomTimedSearch(ShapeletSearchOptions ops) {
        super(ops);
        this.timeLimit = ops.getTimeLimit();
        this.random = new Random(ops.getSeed());
    }

    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        int length;
        ArrayList<Shapelet> seriesShapelets = new ArrayList<Shapelet>();
        int numLengths = this.maxShapeletLength - this.minShapeletLength;
        this.visited = new boolean[numLengths][];
        for (long currentTime = 0L; this.timeLimit / (long)this.inputData.numInstances() > currentTime; currentTime += this.calculateTimeToRun(this.inputData.numInstances(), this.seriesLength - 1, length)) {
            int lengthIndex = this.random.nextInt(numLengths);
            length = lengthIndex + this.minShapeletLength;
            int maxPositions = this.seriesLength - length;
            int start = this.random.nextInt(maxPositions);
            this.initVisitedMemory(this.seriesLength, length);
            Shapelet shape = this.visitCandidate(timeSeries, start, length, checkCandidate);
            if (shape == null) continue;
            seriesShapelets.add(shape);
        }
        for (int i = 0; i < this.visited.length; ++i) {
            if (this.visited[i] == null) continue;
            for (int j = 0; j < this.visited[i].length; ++j) {
                if (!this.visited[i][j]) continue;
                this.shapeletsVisited.add(this.seriesCount + "," + (i + this.minShapeletLength) + "," + j);
            }
        }
        ++this.seriesCount;
        return seriesShapelets;
    }

    protected long calculateTimeToRun(int n, int m, int length) {
        long time = (m - length + 1) * length;
        return time * (long)(n - 1);
    }
}

