/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import java.util.BitSet;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.ImpRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.GenericTools;
import utilities.generic_storage.Pair;
import weka.core.Instance;
import weka.core.Instances;

public class MagnifySearch
extends ImpRandomSearch {
    int numShapeletsPerSeries;
    int maxDepth = 3;
    float proportion = 1.0f;
    BitSet seriesToConsider;

    protected MagnifySearch(ShapeletSearchOptions ops) {
        super(ops);
        this.proportion = ops.getProportion();
    }

    @Override
    public void init(Instances input) {
        this.maxDepth = 3;
        this.inputData = input;
        float subsampleSize = (float)this.inputData.numInstances() * this.proportion;
        this.numShapeletsPerSeries = (int)((float)this.numShapelets / subsampleSize);
        this.numShapeletsPerSeries = (int)((float)this.numShapeletsPerSeries / (float)this.maxDepth);
        this.seriesToConsider = new BitSet(this.inputData.numInstances());
        if ((double)this.proportion >= 1.0) {
            this.seriesToConsider.set(0, this.inputData.numInstances(), true);
            return;
        }
        int i = 0;
        while ((float)i < subsampleSize) {
            this.seriesToConsider.set(this.random.nextInt((int)subsampleSize));
            ++i;
        }
        if (this.numShapeletsPerSeries < 1) {
            System.err.println("Too Few Starting shapelets");
        }
    }

    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        ArrayList<Shapelet> candidateList = new ArrayList<Shapelet>();
        if (!this.seriesToConsider.get(this.currentSeries++)) {
            return candidateList;
        }
        int minLength = this.minShapeletLength;
        int maxLength = this.maxShapeletLength;
        int minPos = 0;
        int maxPos = this.maxShapeletLength - this.minShapeletLength + 1;
        int lengthWidth = (maxLength - minLength) / 2;
        int posWidth = (maxPos + minPos) / 2;
        for (int depth = 0; depth < this.maxDepth; ++depth) {
            Shapelet bsf = null;
            for (int i = 0; i < this.numShapeletsPerSeries; ++i) {
                Pair<Integer, Integer> sh = this.createRandomShapelet(this.seriesLength - 1, minLength, maxLength, minPos, maxPos);
                Shapelet shape = checkCandidate.process(timeSeries, (Integer)sh.var1, (Integer)sh.var2);
                if (bsf == null) {
                    bsf = shape;
                }
                if (shape == null || bsf == null) continue;
                if (depth == this.maxDepth - 1) {
                    candidateList.add(shape);
                }
                if (this.comparator.compare(bsf, shape) <= 0) continue;
                bsf = shape;
            }
            if (bsf == null) {
                --depth;
                continue;
            }
            minLength = bsf.length - (lengthWidth >>= 1);
            maxLength = bsf.length + lengthWidth;
            minPos = bsf.startPos - (posWidth >>= 1);
            maxPos = bsf.startPos + posWidth;
        }
        return candidateList;
    }

    private Pair<Integer, Integer> createRandomShapelet(int totalLength, int minLen, int maxLen, int minPos, int maxPos) {
        int maxL = Math.min(totalLength, Math.max(maxLen, this.minShapeletLength));
        int minL = Math.max(this.minShapeletLength, minLen);
        int length = GenericTools.randomRange(this.random, minL, maxL);
        int maxP = Math.min(totalLength - length + 1, maxPos);
        int minP = Math.max(0, minPos);
        int position = GenericTools.randomRange(this.random, minP, maxP);
        return new Pair<Integer, Integer>(length, position);
    }

    public static void main(String[] args) {
        ShapeletSearchOptions magnifyOptions = new ShapeletSearchOptions.Builder().setMin(3).setMax(100).setNumShapelets(1000L).setSeed(0L).build();
        MagnifySearch ps = new MagnifySearch(magnifyOptions);
        for (int i = 0; i < 100; ++i) {
            System.out.println(ps.createRandomShapelet(100, 3, 100, 0, 100));
        }
    }
}

