/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import java.util.List;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.ImpRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.generic_storage.Pair;
import weka.core.Instance;
import weka.core.Instances;

@Deprecated
public class GeneticSearch
extends ImpRandomSearch {
    int initialPopulationSize = 50;
    private int numShapeletsPerSeries;
    private int evaluated;
    private static final double mutationRate = 0.015;
    private static final int tournamentSize = 5;
    private static final boolean elitism = true;

    protected GeneticSearch(ShapeletSearchOptions sop) {
        super(sop);
    }

    @Override
    public void init(Instances input) {
        super.init(input);
        this.numShapeletsPerSeries = (int)(this.numShapelets / (long)this.inputData.numInstances());
    }

    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        this.evaluated = 0;
        double[] series = timeSeries.toDoubleArray();
        List<Shapelet> population = new ArrayList<Shapelet>();
        for (int i = 0; i < this.initialPopulationSize; ++i) {
            Pair<Integer, Integer> pair = this.createRandomShapelet(series);
            Shapelet shape = checkCandidate.process(timeSeries, (Integer)pair.var2, (Integer)pair.var1);
            ++this.evaluated;
            if (shape == null) continue;
            population.add(shape);
        }
        while (this.evaluated < this.numShapeletsPerSeries) {
            population = this.evolvePopulation(timeSeries, population, checkCandidate);
        }
        return population;
    }

    private Pair<Integer, Integer> createRandomShapelet(double[] series) {
        int numLengths = this.maxShapeletLength - this.minShapeletLength;
        int length = this.random.nextInt(numLengths) + this.minShapeletLength;
        int position = this.random.nextInt(series.length + 1 - length);
        return new Pair<Integer, Integer>(length, position);
    }

    private List<Shapelet> evolvePopulation(Instance timeSeries, List<Shapelet> shapesIn, ShapeletSearch.ProcessCandidate checkCandidate) {
        int elitismOffset;
        ArrayList<Shapelet> newPopulation = new ArrayList<Shapelet>();
        ArrayList<Pair<Integer, Integer>> populationToBe = new ArrayList<Pair<Integer, Integer>>();
        newPopulation.add(this.getBestShapelet(shapesIn));
        for (int i = elitismOffset = 1; i < shapesIn.size(); ++i) {
            Shapelet indiv1 = this.tournamentSelection(shapesIn);
            Shapelet indiv2 = this.tournamentSelection(shapesIn);
            Pair<Integer, Integer> crossed = this.crossOver(indiv1, indiv2);
            populationToBe.add(crossed);
        }
        double[] series = timeSeries.toDoubleArray();
        for (Pair<Integer, Integer> populationToBe1 : populationToBe) {
            this.mutate(populationToBe1);
            if (!this.validMutation(populationToBe1)) {
                Pair<Integer, Integer> pair;
                populationToBe1 = pair = this.createRandomShapelet(series);
            }
            Shapelet sh = checkCandidate.process(timeSeries, (Integer)populationToBe1.var2, (Integer)populationToBe1.var1);
            ++this.evaluated;
            if (sh == null) continue;
            newPopulation.add(sh);
        }
        return newPopulation;
    }

    private Shapelet getBestShapelet(List<Shapelet> shapes) {
        Shapelet bsf = shapes.get(0);
        for (Shapelet s : shapes) {
            if (!(s.getQualityValue() > bsf.getQualityValue())) continue;
            bsf = s;
        }
        return bsf;
    }

    private void mutate(Pair<Integer, Integer> shape) {
        Pair<Integer, Integer> pair;
        if (this.random.nextDouble() <= 0.015) {
            pair = shape;
            pair.var1 = (Integer)pair.var1 + (this.random.nextBoolean() ? 1 : -1);
        }
        if (this.random.nextDouble() <= 0.015) {
            pair = shape;
            pair.var2 = (Integer)pair.var2 + (this.random.nextBoolean() ? 1 : -1);
        }
    }

    private boolean validMutation(Pair<Integer, Integer> mutant) {
        int newLen = (Integer)mutant.var1;
        int newPos = (Integer)mutant.var2;
        int m = this.inputData.numAttributes() - 1;
        return newLen >= this.minShapeletLength && newLen <= this.maxShapeletLength && newPos >= 0 && newPos < m - newLen + 1;
    }

    private Pair<Integer, Integer> crossOver(Shapelet shape1, Shapelet shape2) {
        int length = this.random.nextBoolean() ? shape1.length : shape2.length;
        int position = this.random.nextBoolean() ? shape1.startPos : shape2.startPos;
        return new Pair<Integer, Integer>(length, position);
    }

    private Shapelet tournamentSelection(List<Shapelet> shapes) {
        ArrayList<Shapelet> tournament = new ArrayList<Shapelet>();
        for (int i = 0; i < 5; ++i) {
            int randomId = (int)(Math.random() * (double)shapes.size());
            tournament.add(shapes.get(randomId));
        }
        return this.getBestShapelet(tournament);
    }
}

