/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.FStat;
import timeseriesweka.filters.shapelet_transforms.quality_measures.FStatBound;
import timeseriesweka.filters.shapelet_transforms.quality_measures.InformationGain;
import timeseriesweka.filters.shapelet_transforms.quality_measures.InformationGainBound;
import timeseriesweka.filters.shapelet_transforms.quality_measures.KruskalWallis;
import timeseriesweka.filters.shapelet_transforms.quality_measures.KruskalWallisBound;
import timeseriesweka.filters.shapelet_transforms.quality_measures.MoodsMedian;
import timeseriesweka.filters.shapelet_transforms.quality_measures.MoodsMedianBound;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityBound;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityMeasure;
import utilities.class_distributions.ClassDistribution;

public class ShapeletQuality {
    ShapeletQualityChoice choice;
    ShapeletQualityMeasure qualityMeasure;
    Optional<ShapeletQualityBound> bound = Optional.empty();
    private static final List<Supplier<ShapeletQualityMeasure>> qualityConstructors = ShapeletQuality.createQuality();
    private static final List<BiFunction<ClassDistribution, Integer, ShapeletQualityBound>> boundConstructor = ShapeletQuality.createBound();

    public ShapeletQualityChoice getChoice() {
        return this.choice;
    }

    public ShapeletQualityMeasure getQualityMeasure() {
        return this.qualityMeasure;
    }

    public Optional<ShapeletQualityBound> getBound() {
        return this.bound;
    }

    private static List<Supplier<ShapeletQualityMeasure>> createQuality() {
        ArrayList<Supplier<ShapeletQualityMeasure>> cons = new ArrayList<Supplier<ShapeletQualityMeasure>>();
        cons.add(InformationGain::new);
        cons.add(FStat::new);
        cons.add(KruskalWallis::new);
        cons.add(MoodsMedian::new);
        return cons;
    }

    private static List<BiFunction<ClassDistribution, Integer, ShapeletQualityBound>> createBound() {
        ArrayList<BiFunction<ClassDistribution, Integer, ShapeletQualityBound>> cons = new ArrayList<BiFunction<ClassDistribution, Integer, ShapeletQualityBound>>();
        cons.add(InformationGainBound::new);
        cons.add(FStatBound::new);
        cons.add(KruskalWallisBound::new);
        cons.add(MoodsMedianBound::new);
        return cons;
    }

    public ShapeletQuality(ShapeletQualityChoice choice) {
        this.choice = choice;
        this.qualityMeasure = qualityConstructors.get(choice.ordinal()).get();
    }

    public void initQualityBound(ClassDistribution classDist, int percentage) {
        this.bound = Optional.of(boundConstructor.get(this.choice.ordinal()).apply(classDist, percentage));
    }

    public void setBsfQuality(double bsf) {
        if (this.bound.isPresent()) {
            this.bound.get().setBsfQuality(bsf);
        }
    }

    public boolean pruneCandidate() {
        return this.bound.isPresent() && this.bound.get().pruneCandidate();
    }

    public void updateOrderLine(OrderLineObj obj) {
        if (this.bound.isPresent()) {
            this.bound.get().updateOrderLine(obj);
        }
    }

    public static enum ShapeletQualityChoice {
        INFORMATION_GAIN,
        F_STAT,
        KRUSKALL_WALLIS,
        MOODS_MEDIAN;

    }
}

