/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityMeasure;
import utilities.class_distributions.ClassDistribution;

public class KruskalWallis
implements ShapeletQualityMeasure,
Serializable {
    protected KruskalWallis() {
    }

    @Override
    public double calculateQuality(List<OrderLineObj> orderline, ClassDistribution classDistribution) {
        double lastDistance;
        Collections.sort(orderline);
        int numClasses = classDistribution.size();
        int[] classRankCounts = new int[numClasses];
        double[] classRankMeans = new double[numClasses];
        double thisDistance = lastDistance = orderline.get(0).getDistance();
        double classVal = orderline.get(0).getClassVal();
        int n = (int)classVal;
        classRankCounts[n] = classRankCounts[n] + 1;
        int duplicateCount = 0;
        for (int i = 1; i < orderline.size(); ++i) {
            int j;
            double avgRank;
            double maxRank;
            double minRank;
            thisDistance = orderline.get(i).getDistance();
            if (duplicateCount == 0 && thisDistance != lastDistance) {
                int n2 = (int)orderline.get(i).getClassVal();
                classRankCounts[n2] = classRankCounts[n2] + (i + 1);
            } else if (duplicateCount > 0 && thisDistance != lastDistance) {
                minRank = i - duplicateCount;
                maxRank = i;
                avgRank = (minRank + maxRank) / 2.0;
                for (j = i - duplicateCount - 1; j < i; ++j) {
                    int n3 = (int)orderline.get(j).getClassVal();
                    classRankCounts[n3] = (int)((double)classRankCounts[n3] + avgRank);
                }
                duplicateCount = 0;
                int n4 = (int)orderline.get(i).getClassVal();
                classRankCounts[n4] = classRankCounts[n4] + (i + 1);
            } else {
                if (i == orderline.size() - 1) {
                    minRank = i - duplicateCount;
                    maxRank = i + 1;
                    avgRank = (minRank + maxRank) / 2.0;
                    for (j = i - duplicateCount - 1; j <= i; ++j) {
                        int n5 = (int)orderline.get(j).getClassVal();
                        classRankCounts[n5] = (int)((double)classRankCounts[n5] + avgRank);
                    }
                }
                ++duplicateCount;
            }
            lastDistance = thisDistance;
        }
        double overallMeanRank = (1.0 + (double)orderline.size()) / 2.0;
        double s = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            classRankMeans[i] = (double)classRankCounts[i] / (double)classDistribution.get((double)i);
            s += (double)classDistribution.get((double)i) * (classRankMeans[i] - overallMeanRank) * (classRankMeans[i] - overallMeanRank);
        }
        double h = 12.0 / (double)(orderline.size() * (orderline.size() + 1)) * s;
        return h;
    }

    @Override
    public double calculateSeperationGap(List<OrderLineObj> orderline) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

