/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityBound;
import utilities.class_distributions.ClassDistribution;

public class FStatBound
extends ShapeletQualityBound {
    private double[] sums;
    private double[] sumsSquared;
    private double[] sumOfSquares;
    private List<OrderLineObj> meanDistOrderLine;
    private double minDistance;
    private double maxDistance;

    protected FStatBound(ClassDistribution classDist, int percentage) {
        this.initParentFields(classDist, percentage);
        int numClasses = this.parentClassDist.size();
        this.sums = new double[numClasses];
        this.sumsSquared = new double[numClasses];
        this.sumOfSquares = new double[numClasses];
        this.meanDistOrderLine = new ArrayList<OrderLineObj>(numClasses);
        this.minDistance = -1.0;
        this.maxDistance = -1.0;
    }

    @Override
    public void updateOrderLine(OrderLineObj orderLineObj) {
        super.updateOrderLine(orderLineObj);
        int c = (int)orderLineObj.getClassVal();
        double thisDist = orderLineObj.getDistance();
        int n = c;
        this.sums[n] = this.sums[n] + thisDist;
        int n2 = c;
        this.sumOfSquares[n2] = this.sumOfSquares[n2] + thisDist * thisDist;
        this.sumsSquared[c] = this.sums[c] * this.sums[c];
        if (orderLineObj.getDistance() != 0.0) {
            if (this.minDistance == -1.0 || this.minDistance > orderLineObj.getDistance()) {
                this.minDistance = orderLineObj.getDistance();
            }
            if (this.maxDistance == -1.0 || this.maxDistance < orderLineObj.getDistance()) {
                this.maxDistance = orderLineObj.getDistance();
            }
        }
        boolean isUpdated = false;
        for (OrderLineObj meanDistOrderLine1 : this.meanDistOrderLine) {
            if (meanDistOrderLine1.getClassVal() != orderLineObj.getClassVal()) continue;
            meanDistOrderLine1.setDistance(this.sums[(int)orderLineObj.getClassVal()] / (double)this.orderLineClassDist.get(orderLineObj.getClassVal()));
            isUpdated = true;
            break;
        }
        if (!isUpdated) {
            this.meanDistOrderLine.add(new OrderLineObj(this.sums[(int)orderLineObj.getClassVal()] / (double)this.orderLineClassDist.get(orderLineObj.getClassVal()), orderLineObj.getClassVal()));
        }
    }

    @Override
    public double calculateBestQuality() {
        int numClasses = this.parentClassDist.size();
        Collections.sort(this.meanDistOrderLine);
        OrderLineObj min = new OrderLineObj(-1.0, 0.0);
        for (Double d : this.parentClassDist.keySet()) {
            int unassignedObjs = this.parentClassDist.get(d) - this.orderLineClassDist.get(d);
            double distMin = (this.sums[d.intValue()] + (double)unassignedObjs * this.minDistance) / (double)this.parentClassDist.get(d);
            if (min.getDistance() != -1.0 && !(distMin < min.getDistance())) continue;
            min.setDistance(distMin);
            min.setClassVal(d);
        }
        OrderLineObj max = new OrderLineObj(-1.0, 0.0);
        for (Double d : this.parentClassDist.keySet()) {
            int unassignedObjs = this.parentClassDist.get(d) - this.orderLineClassDist.get(d);
            double distMax = (this.sums[d.intValue()] + (double)unassignedObjs * this.maxDistance) / (double)this.parentClassDist.get(d);
            if (d.doubleValue() == min.getClassVal() || max.getDistance() != -1.0 && !(distMax > max.getDistance())) continue;
            max.setDistance(distMax);
            max.setClassVal(d);
        }
        double d = (max.getDistance() - min.getDistance()) / (double)(numClasses - 1);
        int multiplyer = 1;
        for (OrderLineObj currentObj : this.meanDistOrderLine) {
            double thisDist;
            int unassignedObjs = this.parentClassDist.get(currentObj.getClassVal()) - this.orderLineClassDist.get(currentObj.getClassVal());
            if (currentObj.getClassVal() == min.getClassVal()) {
                thisDist = this.minDistance;
            } else if (currentObj.getClassVal() == max.getClassVal()) {
                thisDist = this.maxDistance;
            } else {
                thisDist = this.minDistance + d * (double)multiplyer;
                ++multiplyer;
            }
            int n = (int)currentObj.getClassVal();
            this.sums[n] = this.sums[n] + thisDist * (double)unassignedObjs;
            int n2 = (int)currentObj.getClassVal();
            this.sumOfSquares[n2] = this.sumOfSquares[n2] + thisDist * thisDist * (double)unassignedObjs;
            this.sumsSquared[(int)currentObj.getClassVal()] = this.sums[(int)currentObj.getClassVal()] * this.sums[(int)currentObj.getClassVal()];
        }
        double part1 = 0.0;
        double part2 = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            part1 += this.sumOfSquares[i];
            part2 += this.sums[i];
        }
        part2 *= part2;
        double ssTotal = part1 - (part2 /= (double)this.numInstances);
        part1 = 0.0;
        part2 = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            part1 += this.sumsSquared[i] / (double)this.parentClassDist.get((double)i);
            part2 += this.sums[i];
        }
        double ssAmoung = part1 - part2 * part2 / (double)this.numInstances;
        double ssWithin = ssTotal - ssAmoung;
        int dfAmoung = numClasses - 1;
        int dfWithin = this.numInstances - numClasses;
        double msAmoung = ssAmoung / (double)dfAmoung;
        double msWithin = ssWithin / (double)dfWithin;
        double f = msAmoung / msWithin;
        multiplyer = 1;
        for (OrderLineObj currentObj : this.meanDistOrderLine) {
            double thisDist;
            int unassignedObjs = this.parentClassDist.get(currentObj.getClassVal()) - this.orderLineClassDist.get(currentObj.getClassVal());
            if (currentObj.getClassVal() == min.getClassVal()) {
                thisDist = this.minDistance;
            } else if (currentObj.getClassVal() == max.getClassVal()) {
                thisDist = this.maxDistance;
            } else {
                thisDist = this.minDistance + d * (double)multiplyer;
                ++multiplyer;
            }
            int n = (int)currentObj.getClassVal();
            this.sums[n] = this.sums[n] - thisDist * (double)unassignedObjs;
            int n3 = (int)currentObj.getClassVal();
            this.sumOfSquares[n3] = this.sumOfSquares[n3] - thisDist * thisDist * (double)unassignedObjs;
            this.sumsSquared[(int)currentObj.getClassVal()] = this.sums[(int)currentObj.getClassVal()] * this.sums[(int)currentObj.getClassVal()];
        }
        return Double.isNaN(f) ? 0.0 : f;
    }

    @Override
    public boolean pruneCandidate() {
        if (this.orderLine.size() % this.parentClassDist.size() != 0) {
            return false;
        }
        return super.pruneCandidate();
    }
}

