/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityMeasure;
import utilities.class_distributions.ClassDistribution;

public class FStat
implements ShapeletQualityMeasure,
Serializable {
    protected FStat() {
    }

    @Override
    public double calculateQuality(List<OrderLineObj> orderline, ClassDistribution classDistribution) {
        Collections.sort(orderline);
        int numClasses = classDistribution.size();
        int numInstances = orderline.size();
        double[] sums = new double[numClasses];
        double[] sumsSquared = new double[numClasses];
        double[] sumOfSquares = new double[numClasses];
        for (int i = 0; i < numClasses; ++i) {
            sums[i] = 0.0;
            sumsSquared[i] = 0.0;
            sumOfSquares[i] = 0.0;
        }
        for (OrderLineObj orderline1 : orderline) {
            int c = (int)orderline1.getClassVal();
            double thisDist = orderline1.getDistance();
            int n = c;
            sums[n] = sums[n] + thisDist;
            int n2 = c;
            sumOfSquares[n2] = sumOfSquares[n2] + thisDist * thisDist;
        }
        for (int i = 0; i < numClasses; ++i) {
            sumsSquared[i] = sums[i] * sums[i];
        }
        double ssTotal = 0.0;
        double part1 = 0.0;
        double part2 = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            part1 += sumOfSquares[i];
            part2 += sums[i];
        }
        part2 *= part2;
        ssTotal = part1 - (part2 /= (double)numInstances);
        double ssAmoung = 0.0;
        part1 = 0.0;
        part2 = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            part1 += sumsSquared[i] / (double)classDistribution.get((double)i);
            part2 += sums[i];
        }
        ssAmoung = part1 - part2 * part2 / (double)numInstances;
        int dfAmoung = numClasses - 1;
        double msAmoung = ssAmoung / (double)dfAmoung;
        double ssWithin = ssTotal - ssAmoung;
        int dfWithin = numInstances - numClasses;
        double msWithin = ssWithin / (double)dfWithin;
        double f = msAmoung / msWithin;
        return Double.isNaN(f) ? 0.0 : f;
    }

    public double calculateQualityNew(List<OrderLineObj> orderline, Map<Double, Integer> classDistribution) {
        Collections.sort(orderline);
        int numClasses = classDistribution.size();
        int numInstances = orderline.size();
        double[] sums = new double[numClasses];
        double[] sumsSquared = new double[numClasses];
        double[] sumOfSquares = new double[numClasses];
        for (int i = 0; i < orderline.size(); ++i) {
            int c = (int)orderline.get(i).getClassVal();
            double thisDist = orderline.get(i).getDistance();
            int n = c;
            sums[n] = sums[n] + thisDist;
            int n2 = c;
            sumOfSquares[n2] = sumOfSquares[n2] + thisDist * thisDist;
        }
        double ssTotal = 0.0;
        double part1 = 0.0;
        double part2 = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            sumsSquared[i] = sums[i] * sums[i];
            part1 += sumOfSquares[i];
            part2 += sums[i];
        }
        part2 *= part2;
        ssTotal = part1 - (part2 /= (double)numInstances);
        double ssAmoung = 0.0;
        part1 = 0.0;
        part2 = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            part1 += sumsSquared[i] / (double)classDistribution.get(i).intValue();
            part2 += sums[i];
        }
        ssAmoung = part1 - part2 * part2 / (double)numInstances;
        double ssWithin = ssTotal - ssAmoung;
        int dfAmoung = numClasses - 1;
        int dfWithin = numInstances - numClasses;
        double msAmoung = ssAmoung / (double)dfAmoung;
        double msWithin = ssWithin / (double)dfWithin;
        double f = msAmoung / msWithin;
        return f;
    }

    @Override
    public double calculateSeperationGap(List<OrderLineObj> orderline) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

