/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.distance_functions;

import java.util.Arrays;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import weka.core.Instance;

public class OnlineSubSeqDistance
extends SubSeqDistance {
    protected double[][] sortedIndices;

    @Override
    public void setShapelet(Shapelet shp) {
        super.setShapelet(shp);
        this.sortedIndices = OnlineSubSeqDistance.sortIndexes(this.cand.getShapeletContent());
    }

    @Override
    public void setCandidate(Instance inst, int start, int length, int dim) {
        super.setCandidate(inst, start, length, dim);
        this.sortedIndices = OnlineSubSeqDistance.sortIndexes(this.cand.getShapeletContent());
    }

    @Override
    public double calculate(double[] timeSeries, int timeSeriesId) {
        DoubleWrapper sumPointer = new DoubleWrapper();
        DoubleWrapper sumsqPointer = new DoubleWrapper();
        double[] subseq = new double[this.length];
        System.arraycopy(timeSeries, 0, subseq, 0, subseq.length);
        subseq = this.zNormalise(subseq, false, sumPointer, sumsqPointer);
        double sum = sumPointer.get();
        double sumsq = sumsqPointer.get();
        double bestDist = 0.0;
        int bestPos = 0;
        for (int i = 0; i < this.length; ++i) {
            double temp = this.cand.getShapeletContent()[i] - subseq[i];
            bestDist += temp * temp;
        }
        for (int i = 1; i < timeSeries.length - this.length; ++i) {
            double end = timeSeries[i - 1 + this.length];
            double start = timeSeries[i - 1];
            double currentDist = this.calculateBestDistance(i, timeSeries, bestDist, sum = sum + end - start, sumsq = sumsq + end * end - start * start);
            if (!(currentDist < bestDist)) continue;
            bestDist = currentDist;
            bestPos = i;
        }
        bestDist = bestDist == 0.0 ? 0.0 : 1.0 / (double)this.length * bestDist;
        return bestDist;
    }

    protected double calculateBestDistance(int i, double[] timeSeries, double bestDist, double sum, double sum2) {
        double currentDist;
        double toAdd;
        boolean dontStdv;
        double mean = sum / (double)this.length;
        double stdv2 = (sum2 - mean * mean * (double)this.length) / (double)this.length;
        double stdv = stdv2 < 1.0E-15 ? 0.0 : Math.sqrt(stdv2);
        int j = 0;
        double normalisedVal = 0.0;
        boolean bl = dontStdv = stdv == 0.0;
        for (currentDist = 0.0; j < this.length && currentDist < bestDist; currentDist += toAdd * toAdd, ++j) {
            this.incrementCount();
            int reordedIndex = (int)this.sortedIndices[j][0];
            normalisedVal = dontStdv ? 0.0 : (timeSeries[i + reordedIndex] - mean) / stdv;
            toAdd = this.cand.getShapeletContent()[reordedIndex] - normalisedVal;
        }
        return currentDist;
    }

    protected double[] zNormalise(double[] input, boolean classValOn, DoubleWrapper sum, DoubleWrapper sum2) {
        double mean;
        double num;
        double classValPenalty = classValOn ? 1.0 : 0.0;
        double[] output = new double[input.length];
        double seriesTotal = 0.0;
        double seriesTotal2 = 0.0;
        int i = 0;
        while ((double)i < (double)input.length - classValPenalty) {
            seriesTotal += input[i];
            seriesTotal2 += input[i] * input[i];
            ++i;
        }
        if (sum != null && sum2 != null) {
            sum.set(seriesTotal);
            sum2.set(seriesTotal2);
        }
        double stdv = (num = (seriesTotal2 - (mean = seriesTotal / ((double)input.length - classValPenalty)) * mean * ((double)input.length - classValPenalty)) / ((double)input.length - classValPenalty)) <= 1.0E-15 ? 0.0 : Math.sqrt(num);
        int i2 = 0;
        while ((double)i2 < (double)input.length - classValPenalty) {
            output[i2] = stdv == 0.0 ? 0.0 : (input[i2] - mean) / stdv;
            ++i2;
        }
        if (classValOn) {
            output[output.length - 1] = input[input.length - 1];
        }
        return output;
    }

    public static double[][] sortIndexes(double[] series) {
        double[][] sortedSeries = new double[series.length][2];
        for (int i = 0; i < series.length; ++i) {
            sortedSeries[i][0] = i;
            sortedSeries[i][1] = Math.abs(series[i]);
        }
        Arrays.sort(sortedSeries, (o1, o2) -> Double.compare(o2[1], o1[1]));
        return sortedSeries;
    }

    protected static class DoubleWrapper {
        private double d;

        public DoubleWrapper() {
            this.d = 0.0;
        }

        public DoubleWrapper(double d) {
            this.d = d;
        }

        public void set(double d) {
            this.d = d;
        }

        public double get() {
            return this.d;
        }
    }
}

