/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.distance_functions;

import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import weka.core.Instances;

public class OnlineCachedSubSeqDistance
extends SubSeqDistance {
    protected Stats stats;
    protected double[][] data;

    @Override
    public void init(Instances dataInst) {
        this.stats = new Stats();
        int dataSize = dataInst.numInstances();
        this.data = new double[dataSize][];
        for (int i = 0; i < dataSize; ++i) {
            this.data[i] = this.zNormalise(dataInst.get(i).toDoubleArray(), true);
        }
    }

    @Override
    public void setShapelet(Shapelet shp) {
        super.setShapelet(shp);
        this.stats = null;
    }

    @Override
    public void setSeries(int seriesId) {
        super.setSeries(seriesId);
        this.stats.computeStats(seriesId, this.data);
    }

    @Override
    public double calculate(double[] timeSeries, int timeSeriesId) {
        if (this.stats == null) {
            return super.calculate(timeSeries, timeSeriesId);
        }
        this.stats.setCurrentY(timeSeriesId, this.data);
        double minSum = Double.MAX_VALUE;
        int subLength = this.length;
        double xMean = this.stats.getMeanX(this.startPos, subLength);
        double xStdDev = this.stats.getStdDevX(this.startPos, subLength);
        for (int v = 0; v < timeSeries.length - subLength; ++v) {
            double dist;
            double yMean = this.stats.getMeanY(v, subLength);
            double yStdDev = this.stats.getStdDevY(v, subLength);
            double crossProd = this.stats.getSumOfProds(this.startPos, v, subLength);
            double cXY = 0.0;
            if (xStdDev != 0.0 && yStdDev != 0.0) {
                cXY = (crossProd - (double)subLength * xMean * yMean) / ((double)subLength * xStdDev * yStdDev);
            }
            if (!((dist = 2.0 * (1.0 - cXY)) < minSum)) continue;
            minSum = dist;
        }
        return minSum;
    }

    public static class Stats {
        private double[] cummSumsX = null;
        private double[] cummSqSumsX = null;
        private double[] cummSumsY = null;
        private double[] cummSqSumsY = null;
        private double[][] crossProdsY = null;
        private int xIndex = -1;

        public void setCurrentY(int yIndex, double[][] data) {
            double[][] sums = this.computeCummSums(data[yIndex]);
            this.cummSumsY = sums[0];
            this.cummSqSumsY = sums[1];
            this.crossProdsY = this.computeCrossProd(data[this.xIndex], data[yIndex]);
        }

        public double getMeanX(int startPos, int subLength) {
            double diff = this.cummSumsX[startPos + subLength] - this.cummSumsY[startPos];
            return diff / (double)subLength;
        }

        public double getMeanY(int startPos, int subLength) {
            double diff = this.cummSumsY[startPos + subLength] - this.cummSumsY[startPos];
            return diff / (double)subLength;
        }

        public double getStdDevX(int startPos, int subLength) {
            double diff = this.cummSqSumsX[startPos + subLength] - this.cummSqSumsX[startPos];
            double meanSqrd = this.getMeanX(startPos, subLength) * this.getMeanX(startPos, subLength);
            double temp = diff / (double)subLength;
            double temp1 = temp - meanSqrd;
            return Math.sqrt(temp1);
        }

        public double getStdDevY(int startPos, int subLength) {
            double diff = this.cummSqSumsY[startPos + subLength] - this.cummSqSumsY[startPos];
            double meanSqrd = this.getMeanX(startPos, subLength) * this.getMeanX(startPos, subLength);
            double temp = diff / (double)subLength;
            double temp1 = temp - meanSqrd;
            return Math.sqrt(temp1);
        }

        public double getSumOfProds(int startX, int startY, int length) {
            return this.crossProdsY[startX + length][startY + length] - this.crossProdsY[startX][startY];
        }

        private double[][] computeCummSums(double[] currentSeries) {
            double[][] output = new double[][]{new double[currentSeries.length], new double[currentSeries.length]};
            output[0][0] = 0.0;
            output[1][0] = 0.0;
            for (int i = 1; i < currentSeries.length; ++i) {
                output[0][i] = output[0][i - 1] + currentSeries[i - 1];
                output[1][i] = output[1][i - 1] + currentSeries[i - 1] * currentSeries[i - 1];
            }
            return output;
        }

        private double[][] computeCrossProd(double[] x, double[] y) {
            double[][] output = new double[x.length][y.length];
            for (int u = 1; u < x.length; ++u) {
                for (int v = 1; v < y.length; ++v) {
                    int t;
                    if (v < u) {
                        t = u - v;
                        output[u][v] = output[u - 1][v - 1] + x[v - 1 + t] * y[v - 1];
                        continue;
                    }
                    t = v - u;
                    output[u][v] = output[u - 1][v - 1] + x[u - 1] * y[u - 1 + t];
                }
            }
            return output;
        }

        public void computeStats(int candidateInstIndex, double[][] data) {
            this.xIndex = candidateInstIndex;
            double[][] sums = this.computeCummSums(data[this.xIndex]);
            this.cummSumsX = sums[0];
            this.cummSqSumsX = sums[1];
        }
    }
}

