/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.distance_functions;

import java.io.Serializable;
import timeseriesweka.filters.shapelet_transforms.distance_functions.MultivariateDistance;
import utilities.MultivariateInstanceTools;
import weka.core.Instance;

public class MultivariateDependentDistance
extends MultivariateDistance
implements Serializable {
    @Override
    public double calculate(Instance inst, int timeSeriesId) {
        return this.calculate(MultivariateInstanceTools.convertMultiInstanceToArrays(MultivariateInstanceTools.splitMultivariateInstance(inst)), timeSeriesId);
    }

    public double calculate(double[][] timeSeries, int timeSeriesId) {
        double bestSum = Double.MAX_VALUE;
        for (int i = 0; i < this.seriesLength - this.length + 1; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.numChannels; ++j) {
                double[] subseq = new double[this.length];
                System.arraycopy(timeSeries[j], i, subseq, 0, this.length);
                subseq = this.zNormalise(subseq, false);
                for (int k = 0; k < this.length; ++k) {
                    this.incrementCount();
                    double temp = this.cand.getShapeletContent(j)[k] - subseq[k];
                    sum += temp * temp;
                }
            }
            if (!(sum < bestSum)) continue;
            bestSum = sum;
        }
        double dist = bestSum == 0.0 ? 0.0 : 1.0 / (double)this.length * bestSum;
        return dist;
    }
}

